/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.midp.ui.Form;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import de.enough.polish.util.TimePoint;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Graphics;

public class DateField
extends StringItem
implements CommandListener {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private Date date;
    private int inputMode;
    private TimeZone timeZone;
    private boolean showCaret;
    private int originalWidth;
    private int originalHeight;
    private long lastCaretSwitch;
    private Calendar calendar;
    private javax.microedition.lcdui.DateField midpDateField;
    private Form form;
    private String dateFormatPattern;

    public DateField(String label, int mode) {
        this(label, mode, null, null);
    }

    public DateField(String label, int mode, Style style) {
        this(label, mode, null, style);
    }

    public DateField(String label, int mode, TimeZone timeZone) {
        this(label, mode, timeZone, null);
    }

    public DateField(String label, int mode, TimeZone timeZone, Style style) {
        super(label, null, 3, style);
        this.inputMode = mode;
        this.timeZone = timeZone != null ? timeZone : TimeZone.getDefault();
        this.setDate(null);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date != null && this.inputMode == 2 && date.getTime() > 86400000L) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeZone(this.timeZone);
            }
            this.calendar.setTime(date);
            long timeOnly = this.calendar.get(14) + this.calendar.get(13) * 1000 + this.calendar.get(12) * 60 * 1000 + this.calendar.get(11) * 60 * 60 * 1000;
            date.setTime(timeOnly);
        }
        this.date = date;
        if (this.midpDateField != null) {
            this.midpDateField.setDate(date);
        }
        if (date == null) {
            if (this.inputMode == 1 || this.inputMode == 3) {
                this.text = Locale.get(156);
                if (this.inputMode == 3) {
                    this.text = this.text + " hh:mm";
                }
            } else if (this.inputMode == 2) {
                this.text = "hh:mm";
            }
        } else {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeZone(this.timeZone);
            }
            this.calendar.setTime(date);
            this.text = Locale.formatDate(this.calendar, this.getDateFormatPattern());
        }
        if (this.isInitialized()) {
            this.isTextInitializationRequired = true;
            this.setInitialized(false);
        }
        this.repaint();
    }

    public void setTimePoint(TimePoint date) {
        this.setDate(date.getAsDate());
    }

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        if (this.dateFormatPattern == null) {
            this.dateFormatPattern = this.createDefaultDateFormatPattern();
        }
        return this.dateFormatPattern;
    }

    protected String createDefaultDateFormatPattern() {
        if (this.inputMode == 2) {
            return "HH:mm";
        }
        String defaultPattern = Locale.getDefaultDateFormatPattern();
        if (this.inputMode == 3 && defaultPattern.indexOf("HH") == -1) {
            defaultPattern = defaultPattern + " HH:mm";
        }
        return defaultPattern;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(int mode) {
        this.inputMode = mode;
        if (this.midpDateField != null) {
            this.midpDateField.setInputMode(mode);
        }
        this.setDate(this.date);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        if (this.showCaret) {
            if (this.text == null) {
                g.setFont(this.font);
                g.setColor(this.textColor);
            }
            if (this.isLayoutCenter) {
                int centerX = leftBorder + (rightBorder - leftBorder) / 2 + this.originalWidth / 2 + 2;
                if (this.originalHeight > 0) {
                    y += this.originalHeight - this.getFontHeight();
                }
                g.drawChar('|', centerX, y, 20);
            } else {
                x += this.originalWidth + 2;
                if (this.originalHeight > 0) {
                    y += this.originalHeight - this.getFontHeight();
                }
                g.drawChar('|', x, y, 20);
            }
        }
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        if (this.date == null) {
            this.setDate(null);
        }
        super.initContent(firstLineWidth, availWidth, availHeight);
        this.originalWidth = this.contentWidth;
        this.originalHeight = this.contentHeight;
    }

    protected String createCssSelector() {
        return "datefield";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public boolean animate() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCaretSwitch > 500L) {
            this.lastCaretSwitch = currentTime;
            this.showCaret = !this.showCaret;
            return true;
        }
        return false;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        this.showCaret = false;
    }

    private void checkOutDate() {
    }

    private int getNextDateTimeEnd(int start) {
        for (int i = start; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (Character.isDigit(c) || i <= start) continue;
            return i;
        }
        return this.text.length();
    }

    protected synchronized boolean handleKeyPressed(int keyCode, int gameAction) {
        if (!(keyCode >= 48 && keyCode <= 57 || this.getScreen().isGameActionFire(keyCode, gameAction))) {
            return false;
        }
        this.showDateForm();
        return true;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        int clearKey = -8;
        if (keyCode == clearKey) {
            return true;
        }
        boolean handled = super.handleKeyReleased(keyCode, gameAction);
        return handled;
    }

    private void showDateForm() {
        if (this.midpDateField == null) {
            this.midpDateField = new javax.microedition.lcdui.DateField(this.getLabel(), this.inputMode, this.timeZone);
            this.midpDateField.setDate(this.date);
            this.form = new Form(StyleSheet.currentScreen.getTitle());
            this.form.append(this.midpDateField);
            this.form.addCommand(StyleSheet.OK_CMD);
            this.form.addCommand(StyleSheet.CANCEL_CMD);
            this.form.setCommandListener(this);
        }
        this.screen = StyleSheet.currentScreen;
        Display.getInstance().setCurrent(this.form);
    }

    public void commandAction(Command cmd, Displayable box) {
        if (cmd == StyleSheet.CANCEL_CMD) {
            this.midpDateField.setDate(this.date);
        } else {
            this.setDate(this.midpDateField.getDate());
            this.notifyStateChanged();
        }
        Display.getInstance().setCurrent(this.screen);
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        if (this.isInItemArea(relX, relY)) {
            this.showDateForm();
            return true;
        }
        return super.handlePointerReleased(relX, relY);
    }
}

