/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CommandItem
extends IconItem {
    protected final Command command;
    protected Container children;
    protected boolean hasChildren;
    private int childIndicatorWidth = 5;
    private int childIndicatorYOffset;
    private int childIndicatorHeight = 5;
    private int childIndicatorColor = -1;
    private boolean isOpen;

    public CommandItem(Command command, Item parent) {
        this(command, parent, command.getStyle());
    }

    public CommandItem(Command command, Item parent, Style style) {
        super(null, command.getLabel(), null, command.getStyle() != null ? command.getStyle() : style);
        this.appearanceMode = 3;
        this.command = command;
        this.parent = parent;
        if (command.hasSubCommands()) {
            Command child;
            Object[] cmds = command.getSubCommmandsArray();
            for (int i = 0; i < cmds.length && (child = (Command)cmds[i]) != null; ++i) {
                this.addChild(child, child.getStyle());
            }
        }
        if (command.getCommandType() == 100) {
            this.appearanceMode = 0;
        }
    }

    public void addChild(Command childCommand) {
        this.addChild(childCommand, null);
    }

    public void addChild(Command childCommand, Style childStyle) {
        CommandItem child = new CommandItem(childCommand, this, childStyle);
        this.addChild(child);
    }

    public void addChild(CommandItem child) {
        boolean inserted = false;
        if (this.children == null) {
            int layer = this.getLayer();
            if (layer == 0) {
                this.children = new Container(true);
            } else if (layer == 1) {
                this.children = new Container(true);
            } else if (layer == 2) {
                this.children = new Container(true);
            }
            if (this.children == null) {
                this.children = new Container(true, this.parent.style);
            } else if (this.children.style == null) {
                this.children.style = this.parent.style;
            }
            this.hasChildren = true;
            this.children.parent = this;
        } else {
            int priority = child.command.getPriority();
            for (int i = 0; i < this.children.size(); ++i) {
                CommandItem item = (CommandItem)this.children.get(i);
                if (item.command.getPriority() <= priority) continue;
                this.children.add(i, child);
                inserted = true;
                break;
            }
        }
        if (!inserted) {
            this.children.add(child);
        }
    }

    public int getLayer() {
        Item parentItem = this.parent;
        int layer = 0;
        while (parentItem != null) {
            while (!(parentItem instanceof CommandItem)) {
                parentItem = parentItem.parent;
                if (parentItem != null) continue;
                return layer;
            }
            if (parentItem == null) {
                return layer;
            }
            parentItem = parentItem.parent;
            ++layer;
        }
        return layer;
    }

    public boolean removeChild(Command childCommand) {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            CommandItem item = (CommandItem)this.children.get(i);
            if (item.command != childCommand) continue;
            this.children.remove(i);
            return true;
        }
        return false;
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        if (this.command.getCommandType() == 100) {
            this.contentWidth = availWidth;
            this.contentHeight = 0;
            return;
        }
        if (this.hasChildren) {
            firstLineWidth -= this.childIndicatorWidth + this.paddingHorizontal;
            availWidth -= this.childIndicatorWidth + this.paddingHorizontal;
        }
        super.initContent(firstLineWidth, availWidth, availHeight);
        if (this.hasChildren) {
            this.contentWidth += this.childIndicatorWidth + this.paddingHorizontal;
            if (this.childIndicatorHeight > this.contentHeight) {
                this.contentHeight = this.childIndicatorHeight;
            } else {
                this.childIndicatorYOffset = (this.contentHeight - this.childIndicatorHeight) / 2;
            }
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        if (this.hasChildren) {
            this.paintChildren(x, y, leftBorder, rightBorder, g);
        }
    }

    protected void paintChildren(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.childIndicatorColor != -1) {
            g.setColor(this.childIndicatorColor);
        }
        x = rightBorder - this.childIndicatorWidth;
        int indicatorY = y + this.childIndicatorYOffset;
        g.fillTriangle(x, indicatorY, rightBorder, indicatorY + this.childIndicatorHeight / 2, x, indicatorY + this.childIndicatorHeight);
        if (this.isOpen) {
            int originalY = y;
            int clipX = g.getClipX();
            int clipWidth = g.getClipWidth();
            int clipY = g.getClipY() - 1;
            int clipHeight = g.getClipHeight();
            int availWidth = clipWidth * 2 / 3;
            int availHeight = this.availableHeight;
            int childrenWidth = this.children.getItemWidth(availWidth, availWidth, availHeight);
            int childrenHeight = this.children.itemHeight;
            x = (rightBorder += this.paddingHorizontal) + childrenWidth < clipX + clipWidth ? rightBorder : (clipX + clipWidth - childrenWidth > leftBorder + 10 ? clipX + clipWidth - (childrenWidth + 1) : Math.max(leftBorder - childrenWidth, clipX));
            if (y + childrenHeight > clipY + clipHeight && (y -= y + childrenHeight - (clipY + clipHeight)) < clipY) {
                y = clipY;
            }
            this.children.relativeX = x - leftBorder;
            this.children.relativeY = y - originalY;
            this.children.setScrollHeight(clipHeight);
            this.children.paint(x, y, x, x + childrenWidth, g);
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean isFireGameAction = this.getScreen().isGameActionFire(keyCode, gameAction);
        if (this.isOpen) {
            if (gameAction == 2 && keyCode != 52) {
                this.notifyItemPressedStart();
            } else {
                boolean handled = this.children.handleKeyPressed(keyCode, gameAction);
                if (!handled) {
                    int index;
                    if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) <= this.children.size()) {
                        CommandItem item = (CommandItem)this.children.get(index);
                        return item.notifyItemPressedStart();
                    }
                    this.notifyItemPressedStart();
                }
            }
            return true;
        }
        if (this.hasChildren && this.appearanceMode != 0 ? isFireGameAction || gameAction == 5 && keyCode != 54 : isFireGameAction && this.appearanceMode != 0) {
            return this.notifyItemPressedStart();
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (!this.isPressed && !this.isOpen) {
            return super.handleKeyReleased(keyCode, gameAction);
        }
        if (this.isOpen) {
            if (gameAction == 2 && keyCode != 52) {
                this.open(false);
                this.notifyItemPressedEnd();
            } else {
                boolean handled = this.children.handleKeyReleased(keyCode, gameAction);
                if (!handled) {
                    if (keyCode >= 49 && keyCode <= 57) {
                        int index = keyCode - 49;
                        if (index <= this.children.size()) {
                            CommandItem item = (CommandItem)this.children.get(index);
                            if (item.appearanceMode != 0) {
                                item.notifyItemPressedEnd();
                                item.handleKeyReleased(0, 8);
                                return true;
                            }
                        }
                        return false;
                    }
                    if (gameAction == 1 || gameAction == 6) {
                        return false;
                    }
                    this.open(false);
                    this.notifyItemPressedEnd();
                }
            }
            return true;
        }
        boolean isFireGameAction = this.getScreen().isGameActionFire(keyCode, gameAction);
        if (this.hasChildren && this.appearanceMode != 0) {
            if (isFireGameAction || gameAction == 5 && keyCode != 54) {
                this.notifyItemPressedEnd();
                this.open(true);
                return true;
            }
        } else if (isFireGameAction && this.appearanceMode != 0) {
            this.notifyItemPressedEnd();
            Screen scr = this.getScreen();
            if (scr == null) {
                Debug.debug("error", "de.enough.polish.ui.CommandItem", 468, (Object)("Unable to retrieve screen for " + this + ", parent="), this.parent);
            }
            scr.callCommandListener(this.command);
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handlePointerPressed(int x, int y) {
        boolean handled = false;
        if (this.isOpen) {
            this.children.handlePointerPressed(x - this.children.relativeX, y - this.children.relativeY);
            handled = true;
        }
        return handled || super.handlePointerPressed(x, y);
    }

    protected boolean handlePointerReleased(int x, int y) {
        int relY;
        int relX;
        boolean handled = false;
        if (!(!this.isOpen || (handled = this.children.handlePointerReleased(relX = x - this.children.relativeX, relY = y - this.children.relativeY)) && this.children.isInItemArea(relX, relY))) {
            this.open(false);
            handled = true;
        }
        return handled || super.handlePointerReleased(x, y);
    }

    protected boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        boolean handled = false;
        if (this.isOpen) {
            handled = this.children.handlePointerDragged(x - this.children.relativeX, y - this.children.relativeY, repaintRegion);
        }
        return handled || super.handlePointerDragged(x, y, repaintRegion);
    }

    public void open(boolean open) {
        this.isOpen = open;
        if (open) {
            this.children.showNotify();
            this.children.focus(this.getFocusedStyle(), 0);
            this.children.focusChild(0);
        } else if (this.children != null) {
            this.children.hideNotify();
            this.children.focusChild(-1);
            this.children.setScrollYOffset(0);
        }
    }

    public CommandItem getChild(Command parentCommand) {
        if (!this.hasChildren) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            CommandItem child = (CommandItem)this.children.get(i);
            if (child.command == parentCommand) {
                return child;
            }
            if (!child.hasChildren || (child = child.getChild(parentCommand)) == null) continue;
            return child;
        }
        return null;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
        if (this.childIndicatorWidth == 0) {
            this.childIndicatorHeight = this.childIndicatorWidth = this.font.getHeight();
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        Integer childIndicatorHeightInt;
        Integer childIndicatorWidthInt;
        super.setStyle(style, resetStyle);
        Integer childIndicatorColorInt = style.getIntProperty(147);
        if (childIndicatorColorInt != null) {
            this.childIndicatorColor = childIndicatorColorInt;
        }
        if ((childIndicatorWidthInt = style.getIntProperty(148)) != null) {
            this.childIndicatorWidth = childIndicatorWidthInt;
        }
        if ((childIndicatorHeightInt = style.getIntProperty(149)) != null) {
            this.childIndicatorHeight = childIndicatorHeightInt;
        }
    }

    public void onScreenSizeChanged(int screenWidth, int screenHeight) {
        super.onScreenSizeChanged(screenWidth, screenHeight);
        if (this.children != null) {
            this.children.onScreenSizeChanged(screenWidth, screenHeight);
        }
    }

    public void resetStyle(boolean recursive) {
        super.resetStyle(recursive);
        if (recursive && this.children != null) {
            this.children.resetStyle(recursive);
        }
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.isOpen && this.isFocused) {
            this.children.animate(currentTime, repaintRegion);
        }
    }

    protected void hideNotify() {
        if (this.hasChildren) {
            this.children.hideNotify();
            if (this.isOpen) {
                this.open(false);
            }
        }
        super.hideNotify();
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public CommandItem getChild(int index) {
        if (index < 0 || this.children == null || index >= this.children.size()) {
            return null;
        }
        return (CommandItem)this.children.get(index);
    }

    public void fireEvent(String eventName, Object eventData) {
        super.fireEvent(eventName, eventData);
        if (this.children != null) {
            this.children.fireEvent(eventName, eventData);
        }
    }

    public Item getItemAt(int relX, int relY) {
        int itemRelY;
        int itemRelX;
        Item item;
        if (this.isOpen && (item = this.children.getItemAt(itemRelX = relX - this.children.relativeX, itemRelY = relY - this.children.relativeY)) != null) {
            return item;
        }
        return super.getItemAt(relX, relY);
    }

    public boolean isInItemArea(int relX, int relY) {
        int itemRelY;
        int itemRelX;
        if (this.isOpen && this.children.isInItemArea(itemRelX = relX - this.children.relativeX, itemRelY = relY - this.children.relativeY)) {
            return true;
        }
        return super.isInItemArea(relX, relY);
    }

    public void focusChild(Item item) {
        if (this.hasChildren) {
            int index = this.children.indexOf(item);
            if (index != -1) {
                this.children.focusChild(index);
            } else if (this.children.focusedItem != null) {
                ((CommandItem)this.children.focusedItem).focusChild(item);
            }
        }
    }

    protected void defocus(Style originalStyle) {
        if (this.isOpen) {
            this.open(false);
        }
        super.defocus(originalStyle);
    }
}

