/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

public class ClippingRegion {
    private int leftX = Integer.MAX_VALUE;
    private int topY = Integer.MAX_VALUE;
    private int rightX = Integer.MIN_VALUE;
    private int bottomY = Integer.MIN_VALUE;
    private boolean containsRegion;

    public void reset() {
        this.leftX = Integer.MAX_VALUE;
        this.topY = Integer.MAX_VALUE;
        this.rightX = Integer.MIN_VALUE;
        this.bottomY = Integer.MIN_VALUE;
        this.containsRegion = false;
    }

    public void addRegion(int x, int y, int width, int height) {
        if (x < this.leftX) {
            this.leftX = x;
        }
        if (y < this.topY) {
            this.topY = y;
        }
        if (x + width > this.rightX) {
            this.rightX = x + width;
        }
        if (y + height > this.bottomY) {
            this.bottomY = y + height;
        }
        this.containsRegion = true;
    }

    public boolean containsRegion() {
        return this.containsRegion;
    }

    public int getX() {
        if (this.leftX == Integer.MAX_VALUE) {
            return 0;
        }
        return this.leftX;
    }

    public int getY() {
        if (this.topY == Integer.MAX_VALUE) {
            return 0;
        }
        return this.topY;
    }

    public int getWidth() {
        if (this.rightX == Integer.MIN_VALUE) {
            return 0;
        }
        return this.rightX - this.leftX;
    }

    public int getHeight() {
        if (this.bottomY == Integer.MIN_VALUE) {
            return 0;
        }
        return this.bottomY - this.topY;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClipReg.( ").append(this.leftX).append(", ").append(this.topY).append(", ").append(this.rightX).append(", ").append(this.bottomY).append(" ); containsRegion=").append(this.containsRegion).append("] ").append(super.toString());
        return buffer.toString();
    }
}

