/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Ticker;
import de.enough.polish.util.Debug;
import de.enough.polish.util.IdentityArrayList;
import javax.microedition.lcdui.Graphics;

public abstract class Canvas
implements Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    private CommandListener _commandListener;
    boolean _isShown;
    public IdentityArrayList _commands;
    String _title;

    protected Canvas() {
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public boolean hasPointerEvents() {
        Display display = Display.getInstance();
        if (display != null) {
            return display.hasPointerEvents();
        }
        return false;
    }

    public boolean hasPointerMotionEvents() {
        Display display = Display.getInstance();
        if (display != null) {
            return display.hasPointerMotionEvents();
        }
        return false;
    }

    public boolean hasRepeatEvents() {
        return true;
    }

    public int getKeyCode(int gameAction) {
        return Display.getInstance().getKeyCode(gameAction);
    }

    public String getKeyName(int keyCode) {
        return Display.getInstance().getKeyName(keyCode);
    }

    public int getGameAction(int keyCode) {
        try {
            return Display.getInstance().getGameAction(keyCode);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setFullScreenMode(boolean mode) {
        try {
            Display._setFullScreenMode(mode);
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.Canvas", 649, (Object)"Unable to switch to fullscreen mode ", e);
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected boolean _keyPressed(int keyCode) {
        this.keyPressed(keyCode);
        return true;
    }

    protected boolean _keyRepeated(int keyCode) {
        this.keyRepeated(keyCode);
        return true;
    }

    protected boolean _keyReleased(int keyCode) {
        this.keyReleased(keyCode);
        return true;
    }

    protected boolean _pointerPressed(int x, int y) {
        this.pointerPressed(x, y);
        return true;
    }

    protected boolean _pointerReleased(int x, int y) {
        this.pointerReleased(x, y);
        return true;
    }

    protected boolean _pointerDragged(int x, int y) {
        this.pointerDragged(x, y);
        return true;
    }

    public boolean handlePointerTouchDown(int x, int y) {
        return false;
    }

    public boolean handlePointerTouchUp(int x, int y) {
        return false;
    }

    public final void repaint(int x, int y, int width, int height) {
        Display display = Display.getInstance();
        if (display != null) {
            display.requestRepaint(x, y, width, height);
        }
    }

    public void repaint(ClippingRegion region) {
        Display display = Display.getInstance();
        if (display != null) {
            display.requestRepaint(region.getX(), region.getY(), region.getWidth(), region.getHeight());
        }
    }

    public final void repaint() {
        Display display = Display.getInstance();
        if (display != null) {
            display.requestRepaint();
        }
    }

    public final void serviceRepaints() {
        Display.getInstance().serviceRepaints();
    }

    protected void _showNotify() {
        Display instance = Display.getInstance();
        instance.setFullScreenMode(this._commands == null && this._title == null);
        if (this._commands != null) {
            Command cmd;
            Object[] commands = this._commands.getInternalArray();
            for (int i = 0; i < commands.length && (cmd = (Command)commands[i]) != null; ++i) {
                instance.addCommand(cmd);
            }
            instance.setCommandListener(this._commandListener);
        }
        instance.setTitle(this._title);
        this._isShown = true;
        this.showNotify();
    }

    protected void _hideNotify() {
        if (this._commands != null) {
            Command cmd;
            Object[] commands = this._commands.getInternalArray();
            Display instance = Display.getInstance();
            Canvas current = instance.currentCanvas;
            for (int i = 0; i < commands.length && (cmd = (Command)commands[i]) != null; ++i) {
                if (current != null && current._commands != null && current._commands.contains(cmd)) continue;
                instance.removeCommand(cmd);
            }
        }
        this._isShown = false;
        this.hideNotify();
    }

    protected void _hideNotifyExternal() {
        this._hideNotify();
        this.hideNotifyExternal();
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void hideNotifyExternal() {
    }

    protected abstract void paint(Graphics var1);

    public void sizeChanged(int w, int h) {
    }

    public boolean isShown() {
        return this._isShown;
    }

    public int getWidth() {
        return Display.getScreenWidth();
    }

    public int getHeight() {
        if (this._commands != null) {
            return Display.getInstance().nonFullScreenHeight;
        }
        return Display.getScreenHeight();
    }

    public Ticker getPolishTicker() {
        return null;
    }

    public void setTicker(Ticker ticker) {
    }

    public void setCommandListener(CommandListener l) {
        this._commandListener = l;
    }

    public CommandListener getCommandListener() {
        return this._commandListener;
    }

    public void addCommand(Command cmd) {
        if (this._commands == null) {
            this._commands = new IdentityArrayList();
        }
        boolean add = !this._commands.contains(cmd);
        this._commands.add(cmd);
        if (add && this._isShown) {
            Display.getInstance().addCommand(cmd);
        }
    }

    public void removeCommand(Command cmd) {
        if (this._commands == null) {
            return;
        }
        this._commands.remove(cmd);
        if (this._isShown && !this._commands.contains(cmd)) {
            Display.getInstance().removeCommand(cmd);
        }
    }

    public Object[] getCommands() {
        if (this._commands == null) {
            return null;
        }
        Object[] commands = this._commands.getInternalArray();
        return commands;
    }

    public void setTitle(String s) {
        this._title = s;
        if (this._isShown) {
            Display.getInstance().setTitle(s);
        }
    }

    public String getTitle() {
        return this._title;
    }
}

