/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.rmi.bluetooth;

import de.enough.polish.bluetooth.DiscoveryHelper;
import de.enough.polish.rmi.RemoteClient;
import de.enough.polish.rmi.RemoteException;
import de.enough.polish.rmi.bluetooth.BluetoothRemoteClient;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public class SppRemoteClient
extends RemoteClient
implements BluetoothRemoteClient {
    protected StreamConnection connection;
    private boolean isConnecting;
    private DataInputStream in;
    private DataOutputStream out;

    public SppRemoteClient(String uuid) {
        super(uuid);
    }

    protected Object callMethod(String name, long primitivesFlag, Object[] parameters) throws RemoteException {
        if (this.connection == null) {
            try {
                this.connect();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.rmi.bluetooth.SppRemoteClient", 81, (Object)"Unable to establish bluetooth connection", e);
                throw new RemoteException(e);
            }
        }
        try {
            this.writeMethodParameters(name, primitivesFlag, parameters, this.out);
            this.out.flush();
            Object e = this.readResponse(this.in);
            Object var8_7 = null;
            return e;
        }
        catch (IOException e) {
            try {
                Debug.debug("error", "de.enough.polish.rmi.bluetooth.SppRemoteClient", 93, (Object)"Unable to write/read method call", e);
                try {
                    this.connection.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                this.connection = null;
                throw new RemoteException(e);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.isConnecting) {
            return;
        }
        this.isConnecting = true;
        try {
            StreamConnection con = (StreamConnection)DiscoveryHelper.findAndConnectService(this.url, 10390323, 256, true);
            if (con == null) {
                throw new IOException(this.url + " not found");
            }
            this.connection = con;
            this.in = con.openDataInputStream();
            this.out = con.openDataOutputStream();
            Object var3_2 = null;
            this.isConnecting = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isConnecting = false;
            throw throwable;
        }
    }

    public void disconnect() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (!(connection instanceof StreamConnection)) {
            throw new IllegalArgumentException();
        }
        this.connection = (StreamConnection)connection;
    }
}

