/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.ProcessingContextContainerInterface;
import de.enough.polish.processing.ProcessingInterface;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class ProcessingScreen
extends Screen
implements ProcessingContextContainerInterface {
    protected Command cmd = new Command("", 8, 0);
    protected String softkeyCommandText = null;
    protected ProcessingInterface context = null;
    protected boolean focusHasBeenTriggered = false;

    public void initProcessingContext() {
        this.context.signalInitialization();
        this.context.setParent(this);
    }

    public ProcessingScreen(String title, ProcessingInterface context) {
        super(title, null, true);
        this.context = context;
        this.initProcessingContext();
    }

    public ProcessingScreen(String title, ProcessingInterface context, Style style) {
        super(title, style, true);
        this.context = context;
        this.initProcessingContext();
    }

    protected boolean isWithinBounds(int x, int y) {
        return x >= this.contentX && x <= this.contentWidth + this.contentX && y >= this.contentY && y <= this.contentHeight + this.contentY;
    }

    protected void paintScreen(Graphics g) {
        this.context.signalSizeChange(this.contentWidth, this.contentHeight);
        if (!this.focusHasBeenTriggered) {
            this.context.signalHasFocus();
            this.focusHasBeenTriggered = true;
        }
        if (!this.context.isDrawingTransparent()) {
            g.drawImage(this.context.getBuffer(), this.contentX, this.contentY, 20);
        } else {
            this.context.getTransparentRgbImage().paint(this.contentX, this.contentY, g);
        }
    }

    protected boolean handleCommand(Command cmd) {
        this.context.signalSoftkeyPressed(cmd.getLabel());
        return this.context.areSoftkeysCaptured() || super.handleCommand(cmd);
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.context.signalKeyPressed(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        this.context.signalKeyReleased(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        this.context.signalKeyPressed(keyCode);
        return this.context.areKeypressesCaptured();
    }

    protected boolean handlePointerPressed(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerPressed(x -= this.contentX, y -= this.contentY);
        return this.context.arePointerEventsCaptured();
    }

    protected boolean handlePointerReleased(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return false;
        }
        this.context.signalPointerReleased(x -= this.contentX, y -= this.contentY);
        return this.context.arePointerEventsCaptured();
    }

    protected boolean handlePointerDragged(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerDragged(x -= this.contentX, y -= this.contentY);
        return this.context.arePointerEventsCaptured();
    }

    public boolean handlePointerTouchDown(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerPressed(x -= this.contentX, y -= this.contentY);
        return this.context.arePointerEventsCaptured();
    }

    public boolean handlePointerTouchUp(int x, int y) {
        if (!this.isWithinBounds(x, y)) {
            return this.context.arePointerEventsCaptured();
        }
        this.context.signalPointerReleased(x -= this.contentX, y -= this.contentY);
        return this.context.arePointerEventsCaptured();
    }

    protected String createCssSelector() {
        return "processing";
    }

    public void processingRequestRepaint() {
        this.repaint();
    }

    public void hideNotify() {
        this.context.signalLostFocus();
        this.focusHasBeenTriggered = false;
        super.hideNotify();
    }

    public void releaseResources() {
        this.context.signalDestroy();
        super.releaseResources();
    }

    public void setSoftkey(String text) {
        this.softkeyCommandText = text;
        if (this.softkeyCommandText != null) {
            this.removeCommand(this.cmd);
            this.cmd = new Command(this.softkeyCommandText, 8, 0);
            this.addCommand(this.cmd);
        } else {
            this.removeCommand(this.cmd);
        }
    }
}

