/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.processing;

import de.enough.polish.processing.color;
import de.enough.polish.util.BitMapFont;
import de.enough.polish.util.BitMapFontViewer;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class PFont {
    protected Font platformFont = null;
    protected BitMapFont bitmapFont = null;
    protected int color = 0;
    protected int bgColor;
    protected boolean useNativeFontColor = false;
    public static int FACE_SYSTEM = 0;
    public static int FACE_MONOSPACE = 32;
    public static int FACE_PROPORTIONAL = 64;
    public static int SIZE_LARGE = 16;
    public static int SIZE_MEDIUM = 0;
    public static int SIZE_SMALL = 8;
    public static int STYLE_PLAIN = 0;
    public static int STYLE_BOLD = 1;
    public static int STYLE_ITALIC = 2;
    public static int STYLE_UNDERLINED = 4;

    public PFont(Font font) {
        this.platformFont = font;
    }

    public PFont(String fontUrl) {
        this.bitmapFont = BitMapFont.getInstance(fontUrl);
        this.useNativeFontColor = true;
    }

    public PFont(String fontUrl, color textColor, color bgColor) {
        this.color = textColor.color;
        this.bgColor = bgColor.color;
        this.useNativeFontColor = false;
        this.bitmapFont = BitMapFont.getInstance(fontUrl);
    }

    public int getHeight() {
        if (this.platformFont != null) {
            return this.platformFont.getHeight();
        }
        return this.bitmapFont.getFontHeight();
    }

    public int getBaseline() {
        if (this.platformFont != null) {
            return this.platformFont.getBaselinePosition();
        }
        return this.getHeight();
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int result = 0;
        if (this.platformFont != null) {
            result = this.platformFont.charsWidth(ch, offset, length);
        } else {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                int temp = this.bitmapFont.charWidth(ch[i]);
                if (temp == -1) {
                    result += this.bitmapFont.charWidth('a');
                    continue;
                }
                result += temp;
            }
        }
        return result;
    }

    public int charWidth(char ch) {
        int temp;
        int result = 0;
        result = this.platformFont != null ? this.platformFont.charWidth(ch) : ((temp = this.bitmapFont.charWidth(ch)) == -1 ? (result += this.bitmapFont.charWidth('a')) : (result += temp));
        return result;
    }

    public int stringWidth(String str) {
        int result = this.platformFont != null ? this.platformFont.stringWidth(str) : this.substringWidth(str, 0, str.length());
        return result;
    }

    public int substringWidth(String str, int offset, int length) {
        int result = 0;
        if (this.platformFont != null) {
            result = this.platformFont.substringWidth(str, offset, length);
        } else {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                int temp = this.bitmapFont.charWidth(str.charAt(i));
                if (temp == -1) {
                    result += this.bitmapFont.charWidth('a');
                    continue;
                }
                result += temp;
            }
        }
        return result;
    }

    public void draw(Graphics g, String str, int x, int y, int textAlign) {
        if (this.platformFont != null) {
            g.setFont(this.platformFont);
            int align = 16;
            align = textAlign == 0 ? (align |= 1) : (textAlign == 5 ? (align |= 8) : (align |= 4));
            g.drawString(str, x, y - this.platformFont.getBaselinePosition(), align);
        } else {
            if (textAlign != 2) {
                int width = this.stringWidth(str);
                if (textAlign == 0) {
                    x -= width >> 1;
                } else if (textAlign == 5) {
                    x -= width;
                }
            }
            BitMapFontViewer bfv = null;
            bfv = this.useNativeFontColor ? this.bitmapFont.getViewer(str) : this.bitmapFont.getViewer(str, this.color);
            bfv.paint(x, y - this.bitmapFont.getFontHeight(), g);
        }
    }

    public boolean isBitmapFont() {
        return this.bitmapFont != null;
    }
}

