/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.pim;

import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.pim.ContactAddress;
import de.enough.polish.pim.ContactName;
import de.enough.polish.pim.PimContact;
import de.enough.polish.pim.PimToDo;
import de.enough.polish.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDo;
import javax.microedition.pim.ToDoList;

public class PimUtility {
    private PIM pimInstance = PIM.getInstance();

    public PIM getPimInstance() {
        return this.pimInstance;
    }

    public void setPimInstance(PIM pimInstance) {
        this.pimInstance = pimInstance;
    }

    public String[] getNamesOfContactLists() {
        String[] contactLists = this.pimInstance.listPIMLists(1);
        return contactLists;
    }

    public String[] getNamesOfEventLists() {
        String[] eventLists = this.pimInstance.listPIMLists(2);
        return eventLists;
    }

    public String[] getNamesOfToDoLists() {
        String[] toDoLists = this.pimInstance.listPIMLists(3);
        return toDoLists;
    }

    public ContactList getDefaultContactList() {
        return this.getDefaultContactListHelper(3);
    }

    public ContactList getDefaultContactList(int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getDefaultContactListHelper(mode);
        }
        return null;
    }

    private ContactList getDefaultContactListHelper(int mode) {
        ContactList contactList = null;
        try {
            contactList = (ContactList)this.pimInstance.openPIMList(1, mode);
        }
        catch (PIMException e) {
            contactList = null;
        }
        return contactList;
    }

    public ContactList getContactList(String nameOfList) {
        return this.getContactListHelper(nameOfList, 3);
    }

    public ContactList getContactList(String nameOfList, int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getContactListHelper(nameOfList, mode);
        }
        return null;
    }

    private ContactList getContactListHelper(String nameOfList, int mode) {
        ContactList contactList = null;
        try {
            contactList = (ContactList)this.pimInstance.openPIMList(1, mode, nameOfList);
        }
        catch (PIMException e) {
            contactList = null;
        }
        return contactList;
    }

    public EventList getDefaultEventList() {
        return this.getDefaultEventListHelper(3);
    }

    public EventList getDefaultEventList(int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getDefaultEventListHelper(mode);
        }
        return null;
    }

    private EventList getDefaultEventListHelper(int mode) {
        EventList eventList = null;
        try {
            eventList = (EventList)this.pimInstance.openPIMList(2, mode);
        }
        catch (PIMException e) {
            eventList = null;
        }
        return eventList;
    }

    public EventList getEventList(String nameOfList) {
        return this.getEventListHelper(nameOfList, 3);
    }

    public EventList getEventList(String nameOfList, int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getEventListHelper(nameOfList, mode);
        }
        return null;
    }

    private EventList getEventListHelper(String nameOfList, int mode) {
        EventList eventList = null;
        try {
            eventList = (EventList)this.pimInstance.openPIMList(2, mode, nameOfList);
        }
        catch (PIMException e) {
            eventList = null;
        }
        return eventList;
    }

    public ToDoList getDefaultToDoList() {
        return this.getDefaultToDoListHelper(3);
    }

    public ToDoList getDefaultToDoList(int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getDefaultToDoListHelper(mode);
        }
        return null;
    }

    private ToDoList getDefaultToDoListHelper(int mode) {
        ToDoList toDoList = null;
        try {
            toDoList = (ToDoList)this.pimInstance.openPIMList(3, mode);
        }
        catch (PIMException e) {
            toDoList = null;
        }
        return toDoList;
    }

    public ToDoList getToDoList(String nameOfList) {
        return this.getToDoListHelper(nameOfList, 3);
    }

    public ToDoList getToDoList(String nameOfList, int mode) {
        if (3 == mode || 1 == mode || 2 == mode) {
            return this.getToDoListHelper(nameOfList, mode);
        }
        return null;
    }

    public ToDoList getToDoListHelper(String nameOfList, int mode) {
        ToDoList toDoList = null;
        try {
            toDoList = (ToDoList)this.pimInstance.openPIMList(3, mode, nameOfList);
        }
        catch (PIMException e) {
            toDoList = null;
        }
        return toDoList;
    }

    public PimContact[] getAllContacts() throws PIMException {
        ContactList contactList = null;
        contactList = this.getDefaultContactList();
        return this.getAllContactsHelper(contactList);
    }

    public PimContact[] getAllContacts(String nameOfList) throws PIMException {
        ContactList contactList = null;
        contactList = this.getContactList(nameOfList);
        return this.getAllContactsHelper(contactList);
    }

    private PimContact[] getAllContactsHelper(ContactList contactList) throws PIMException {
        return this.getAllContactsOfEnumeration(contactList, contactList.items());
    }

    private PimContact[] getAllContactsOfEnumeration(ContactList contactList, Enumeration contacts) {
        ArrayList pimList = new ArrayList();
        PimContact pimContact = null;
        while (contacts.hasMoreElements()) {
            Contact contact = (Contact)contacts.nextElement();
            pimContact = new PimContact();
            int[] fields = contact.getPIMList().getSupportedFields();
            block9: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                if (field == 102 || contact.countValues(field) == 0) continue;
                int dataType = contact.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 105) {
                            pimContact.setFormattedName(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 104) {
                            pimContact.setFormattedAddress(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 103) {
                            pimContact.setEmailAddress(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 107) {
                            pimContact.setNickName(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 108) {
                            pimContact.setNotes(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 115) {
                            pimContact.setTelephoneNumber(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 118) {
                            pimContact.setUrlForContact(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 111) {
                            pimContact.setPhotoUrl(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field == 113) {
                            pimContact.setPublicKeyString(contact.getString(field, 0));
                            continue block9;
                        }
                        if (field != 117) continue block9;
                        pimContact.setUid(contact.getString(field, 0));
                        continue block9;
                    }
                    case 1: {
                        continue block9;
                    }
                    case 5: {
                        if (field == 100) {
                            String[] addressArray = contact.getStringArray(field, 0);
                            ContactAddress address = new ContactAddress();
                            if (contactList.isSupportedArrayElement(100, 6)) {
                                address.setCountryOfAddress(addressArray[6]);
                            } else if (contactList.isSupportedArrayElement(100, 1)) {
                                address.setExtraInfoOfAddress(addressArray[1]);
                            } else if (contactList.isSupportedArrayElement(100, 3)) {
                                address.setLocalityOfAddress(addressArray[3]);
                            } else if (contactList.isSupportedArrayElement(100, 0)) {
                                address.setPoBoxOfAddress(addressArray[0]);
                            } else if (contactList.isSupportedArrayElement(100, 5)) {
                                address.setPostalCode(addressArray[5]);
                            } else if (contactList.isSupportedArrayElement(100, 4)) {
                                address.setRegionOfAddress(addressArray[4]);
                            } else if (contactList.isSupportedArrayElement(100, 2)) {
                                address.setStreetAddress(addressArray[2]);
                            }
                            pimContact.setContactAddress(address);
                            continue block9;
                        }
                        if (field != 106) continue block9;
                        String[] nameArray = contact.getStringArray(field, 0);
                        ContactName contactName = new ContactName();
                        if (contactList.isSupportedArrayElement(106, 0)) {
                            contactName.setFamilyName(nameArray[0]);
                        } else if (contactList.isSupportedArrayElement(106, 1)) {
                            contactName.setGivenName(nameArray[1]);
                        } else if (contactList.isSupportedArrayElement(106, 2)) {
                            contactName.setOtherName(nameArray[2]);
                        } else if (contactList.isSupportedArrayElement(106, 3)) {
                            contactName.setPrefixOfName(nameArray[3]);
                        } else if (contactList.isSupportedArrayElement(106, 4)) {
                            contactName.setSuffixOfName(nameArray[4]);
                        }
                        pimContact.setContactName(contactName);
                        continue block9;
                    }
                    case 2: {
                        if (field == 101) {
                            pimContact.setDateOfBirth(new Date(contact.getDate(field, 0)));
                            continue block9;
                        }
                        if (field != 114) continue block9;
                        pimContact.setLastRevision(new Date(contact.getDate(field, 0)));
                        continue block9;
                    }
                    case 3: {
                        if (field != 102) continue block9;
                        pimContact.setClassOfContact(contact.getInt(field, 0));
                        continue block9;
                    }
                    case 0: {
                        if (field == 110) {
                            pimContact.setPhoto(contact.getBinary(field, 0));
                            continue block9;
                        }
                        if (field != 112) continue block9;
                        pimContact.setPublicKey(contact.getBinary(field, 0));
                    }
                }
            }
            pimList.add(pimContact);
        }
        return (PimContact[])pimList.toArray(new PimContact[pimList.size()]);
    }

    public CalendarEntry[] getAllEvents() throws PIMException {
        EventList eventList = null;
        eventList = this.getDefaultEventList();
        return this.getAllEventsHelper(eventList);
    }

    public CalendarEntry[] getAllEvents(String nameOfList) throws PIMException {
        EventList eventList = null;
        eventList = this.getEventList(nameOfList);
        return this.getAllEventsHelper(eventList);
    }

    private CalendarEntry[] getAllEventsHelper(EventList eventList) throws PIMException {
        Enumeration events = eventList.items();
        return this.getAllEventsOfEnumeration(eventList, events);
    }

    private CalendarEntry[] getAllEventsOfEnumeration(EventList eventList, Enumeration events) {
        ArrayList pimEventList = new ArrayList();
        CalendarEntry calendarEntry = null;
        while (events.hasMoreElements()) {
            Event event = (Event)events.nextElement();
            calendarEntry = new CalendarEntry();
            int[] fields = event.getPIMList().getSupportedFields();
            block8: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                if (field == 102 || event.countValues(field) == 0) continue;
                int dataType = event.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 103) {
                            calendarEntry.setLocation(event.getString(field, 0));
                            continue block8;
                        }
                        if (field == 104) {
                            calendarEntry.setNotes(event.getString(field, 0));
                            continue block8;
                        }
                        if (field == 107) {
                            calendarEntry.setSummary(event.getString(field, 0));
                            continue block8;
                        }
                        if (field != 108) continue block8;
                        calendarEntry.setId(event.getString(field, 0));
                        continue block8;
                    }
                    case 1: {
                        continue block8;
                    }
                    case 5: {
                        continue block8;
                    }
                    case 2: {
                        if (field == 106) {
                            calendarEntry.setStartDate(new Date(event.getDate(field, 0)));
                            continue block8;
                        }
                        if (field != 102) continue block8;
                        calendarEntry.setEndDate(new Date(event.getDate(field, 0)));
                        continue block8;
                    }
                    case 3: {
                        if (field == 101) {
                            calendarEntry.setField("ClassOfEvent", new Integer(event.getInt(field, 0)));
                            continue block8;
                        }
                        if (field != 100) continue block8;
                        calendarEntry.setAlarm(event.getInt(field, 0));
                        continue block8;
                    }
                }
            }
            pimEventList.add(calendarEntry);
        }
        return (CalendarEntry[])pimEventList.toArray(new CalendarEntry[pimEventList.size()]);
    }

    public PimToDo[] getAllToDos() throws PIMException {
        ToDoList toDoList = null;
        toDoList = this.getDefaultToDoList();
        return this.getAllToDosHelper(toDoList);
    }

    public PimToDo[] getAllToDos(String nameOfList) throws PIMException {
        ToDoList toDoList = null;
        toDoList = this.getToDoList(nameOfList);
        return this.getAllToDosHelper(toDoList);
    }

    private PimToDo[] getAllToDosHelper(ToDoList toDoList) throws PIMException {
        Enumeration toDos = toDoList.items();
        return this.getAllToDosOfEnumeration(toDoList, toDos);
    }

    private PimToDo[] getAllToDosOfEnumeration(ToDoList toDoList, Enumeration toDos) {
        ArrayList pimToDoList = new ArrayList();
        PimToDo pimToDo = null;
        while (toDos.hasMoreElements()) {
            ToDo toDo = (ToDo)toDos.nextElement();
            pimToDo = new PimToDo();
            int[] fields = toDo.getPIMList().getSupportedFields();
            block8: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                if (field == 102 || toDo.countValues(field) == 0) continue;
                int dataType = toDo.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 104) {
                            pimToDo.setNote(toDo.getString(field, 0));
                            continue block8;
                        }
                        if (field == 107) {
                            pimToDo.setSummary(toDo.getString(field, 0));
                            continue block8;
                        }
                        if (field != 108) continue block8;
                        pimToDo.setUid(toDo.getString(field, 0));
                        continue block8;
                    }
                    case 1: {
                        if (field != 101) continue block8;
                        pimToDo.setCompleted(toDo.getBoolean(field, 0));
                        continue block8;
                    }
                    case 5: {
                        continue block8;
                    }
                    case 2: {
                        if (field == 102) {
                            pimToDo.setCompletionDate(new Date(toDo.getDate(field, 0)));
                            continue block8;
                        }
                        if (field == 103) {
                            pimToDo.setDueDate(new Date(toDo.getDate(field, 0)));
                            continue block8;
                        }
                        if (field != 106) continue block8;
                        pimToDo.setLastRevisedDate(new Date(toDo.getDate(field, 0)));
                        continue block8;
                    }
                    case 3: {
                        if (field != 100) continue block8;
                        pimToDo.setClassOfToDo(toDo.getInt(field, 0));
                        continue block8;
                    }
                }
            }
            pimToDoList.add(pimToDo);
        }
        return (PimToDo[])pimToDoList.toArray(new PimToDo[pimToDoList.size()]);
    }

    public void addContact(PimContact pimContact) throws PIMException {
        ContactList contactList = null;
        contactList = this.getDefaultContactList();
        this.addContactHelper(pimContact, contactList);
    }

    public void addContact(PimContact pimContact, String nameOfList) throws PIMException {
        ContactList contactList = null;
        contactList = this.getContactList(nameOfList);
        this.addContactHelper(pimContact, contactList);
    }

    private void addContactHelper(PimContact pimContact, ContactList contactList) throws PIMException {
        try {
            Contact contact = contactList.createContact();
            int[] fields = contact.getPIMList().getSupportedFields();
            block10: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = contact.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 105 && pimContact.getFormattedName() != null) {
                            contact.addString(105, 0, pimContact.getFormattedName());
                            continue block10;
                        }
                        if (field == 104 && pimContact.getFormattedAddress() != null) {
                            contact.addString(104, 0, pimContact.getFormattedAddress());
                            continue block10;
                        }
                        if (field == 103 && pimContact.getEmailAddress() != null) {
                            contact.addString(103, 0, pimContact.getEmailAddress());
                            continue block10;
                        }
                        if (field == 107 && pimContact.getNickName() != null) {
                            contact.addString(107, 0, pimContact.getNickName());
                            continue block10;
                        }
                        if (field == 108 && pimContact.getNotes() != null) {
                            contact.addString(108, 0, pimContact.getNotes());
                            continue block10;
                        }
                        if (field == 115 && pimContact.getTelephoneNumber() != null) {
                            contact.addString(115, 0, pimContact.getTelephoneNumber());
                            continue block10;
                        }
                        if (field == 118 && pimContact.getUrlForContact() != null) {
                            contact.addString(118, 0, pimContact.getUrlForContact());
                            continue block10;
                        }
                        if (field == 111 && pimContact.getPhotoUrl() != null) {
                            contact.addString(111, 0, pimContact.getPhotoUrl());
                            continue block10;
                        }
                        if (field == 113 && pimContact.getPublicKeyString() != null) {
                            contact.addString(113, 0, pimContact.getPublicKeyString());
                            continue block10;
                        }
                        if (field != 117) continue block10;
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                    case 5: {
                        if (field == 100) {
                            String[] addressArray = new String[contactList.stringArraySize(100)];
                            if (pimContact.getContactAddress() != null) {
                                if (contactList.isSupportedArrayElement(100, 6) && pimContact.getContactAddress().getCountryOfAddress() != null) {
                                    addressArray[6] = pimContact.getContactAddress().getCountryOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 1) && pimContact.getContactAddress().getExtraInfoOfAddress() != null) {
                                    addressArray[1] = pimContact.getContactAddress().getExtraInfoOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 3) && pimContact.getContactAddress().getLocalityOfAddress() != null) {
                                    addressArray[3] = pimContact.getContactAddress().getLocalityOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 0) && pimContact.getContactAddress().getPoBoxOfAddress() != null) {
                                    addressArray[0] = pimContact.getContactAddress().getPoBoxOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 5) && pimContact.getContactAddress().getPostalCode() != null) {
                                    addressArray[5] = pimContact.getContactAddress().getPostalCode();
                                } else if (contactList.isSupportedArrayElement(100, 4) && pimContact.getContactAddress().getRegionOfAddress() != null) {
                                    addressArray[4] = pimContact.getContactAddress().getRegionOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 2) && pimContact.getContactAddress().getStreetAddress() != null) {
                                    addressArray[2] = pimContact.getContactAddress().getStreetAddress();
                                }
                            }
                            contact.addStringArray(100, 0, addressArray);
                            continue block10;
                        }
                        if (field != 106) continue block10;
                        String[] nameArray = new String[contactList.stringArraySize(106)];
                        if (pimContact.getContactName() != null) {
                            if (contactList.isSupportedArrayElement(106, 0) && pimContact.getContactName().getFamilyName() != null) {
                                nameArray[0] = pimContact.getContactName().getFamilyName();
                            } else if (contactList.isSupportedArrayElement(106, 1) && pimContact.getContactName().getGivenName() != null) {
                                nameArray[1] = pimContact.getContactName().getGivenName();
                            } else if (contactList.isSupportedArrayElement(106, 2) && pimContact.getContactName().getOtherName() != null) {
                                nameArray[2] = pimContact.getContactName().getOtherName();
                            } else if (contactList.isSupportedArrayElement(106, 3) && pimContact.getContactName().getPrefixOfName() != null) {
                                nameArray[3] = pimContact.getContactName().getPrefixOfName();
                            } else if (contactList.isSupportedArrayElement(106, 4) && pimContact.getContactName().getSuffixOfName() != null) {
                                nameArray[4] = pimContact.getContactName().getSuffixOfName();
                            }
                        }
                        contact.addStringArray(106, 0, nameArray);
                        continue block10;
                    }
                    case 2: {
                        if (field == 101 && pimContact.getDateOfBirth() != null) {
                            contact.addDate(101, 0, pimContact.getDateOfBirth().getTime());
                            continue block10;
                        }
                        if (field != 114 || pimContact.getLastRevision() == null) continue block10;
                        contact.addDate(114, 0, pimContact.getLastRevision().getTime());
                        continue block10;
                    }
                    case 3: {
                        if (field != 102 || pimContact.getClassOfContact() == 0) continue block10;
                        contact.addInt(102, 0, pimContact.getClassOfContact());
                        continue block10;
                    }
                    case 0: {
                        if (field == 110 && pimContact.getPhoto() != null) {
                            contact.addBinary(110, 0, pimContact.getPhoto(), 0, pimContact.getPhoto().length);
                            continue block10;
                        }
                        if (field != 112 || pimContact.getPublicKey() == null) continue block10;
                        contact.addBinary(112, 0, pimContact.getPublicKey(), 0, pimContact.getPublicKey().length);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while adding Contact Item with given details:" + e.getMessage());
        }
    }

    public void addEvent(CalendarEntry calendarEntry) throws PIMException {
        EventList eventList = null;
        eventList = this.getDefaultEventList();
        this.addEventHelper(calendarEntry, eventList);
    }

    public void addEvent(CalendarEntry calendarEntry, String nameOfList) throws PIMException {
        EventList eventList = null;
        eventList = this.getEventList(nameOfList);
        this.addEventHelper(calendarEntry, eventList);
    }

    private void addEventHelper(CalendarEntry calendarEntry, EventList eventList) throws PIMException {
        try {
            Event event = eventList.createEvent();
            int[] fields = event.getPIMList().getSupportedFields();
            block9: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = event.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 103) {
                            event.addString(103, 0, calendarEntry.getLocation());
                            continue block9;
                        }
                        if (field == 104) {
                            event.addString(104, 0, calendarEntry.getNotes());
                            continue block9;
                        }
                        if (field == 107) {
                            event.addString(107, 0, calendarEntry.getSummary());
                            continue block9;
                        }
                        if (field != 108) continue block9;
                        continue block9;
                    }
                    case 1: {
                        continue block9;
                    }
                    case 5: {
                        continue block9;
                    }
                    case 2: {
                        if (field == 106) {
                            event.addDate(106, 0, calendarEntry.getStartDate().getTimeInMillis());
                            continue block9;
                        }
                        if (field != 102) continue block9;
                        event.addDate(102, 0, calendarEntry.getEndDate().getTimeInMillis());
                        continue block9;
                    }
                    case 3: {
                        if (field == 101) {
                            Integer classOfEvent = (Integer)calendarEntry.getField("ClassOfEvent");
                            if (classOfEvent == null) continue block9;
                            event.addInt(101, 0, classOfEvent.intValue());
                            continue block9;
                        }
                        if (field != 100) continue block9;
                        event.addInt(100, 0, calendarEntry.getAlarm());
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while adding Event Item with given details:" + e.getMessage());
        }
    }

    public void addToDo(PimToDo pimToDo) throws PIMException {
        ToDoList toDoList = null;
        toDoList = this.getDefaultToDoList();
        this.addToDoHelper(pimToDo, toDoList);
    }

    public void addToDo(PimToDo pimToDo, String nameOfList) throws PIMException {
        ToDoList toDoList = null;
        toDoList = this.getToDoList(nameOfList);
        this.addToDoHelper(pimToDo, toDoList);
    }

    private void addToDoHelper(PimToDo pimToDo, ToDoList toDoList) throws PIMException {
        try {
            ToDo toDo = toDoList.createToDo();
            int[] fields = toDo.getPIMList().getSupportedFields();
            block9: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = toDo.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 104) {
                            toDo.addString(104, 0, pimToDo.getNote());
                            continue block9;
                        }
                        if (field == 107) {
                            toDo.addString(107, 0, pimToDo.getSummary());
                            continue block9;
                        }
                        if (field != 108) continue block9;
                        continue block9;
                    }
                    case 1: {
                        if (field != 101) continue block9;
                        toDo.addBoolean(101, 0, pimToDo.isCompleted());
                        continue block9;
                    }
                    case 5: {
                        continue block9;
                    }
                    case 2: {
                        if (field == 102) {
                            toDo.addDate(102, 0, pimToDo.getCompletionDate().getTime());
                            continue block9;
                        }
                        if (field == 103) {
                            toDo.addDate(103, 0, pimToDo.getDueDate().getTime());
                            continue block9;
                        }
                        if (field != 106) continue block9;
                        toDo.addDate(106, 0, pimToDo.getLastRevisedDate().getTime());
                        continue block9;
                    }
                    case 3: {
                        if (field != 100) continue block9;
                        toDo.addInt(100, 0, pimToDo.getClassOfToDo());
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while adding ToDo Item with given details:" + e.getMessage());
        }
    }

    public void removeContact(PimContact pimContact) throws PIMException {
        ContactList contactList = this.getDefaultContactList();
        this.removeContactHelper(pimContact, contactList);
    }

    public void removeContact(PimContact pimContact, String nameOfList) throws PIMException {
        ContactList contactList = this.getContactList(nameOfList);
        this.removeContactHelper(pimContact, contactList);
    }

    private void removeContactHelper(PimContact pimContact, ContactList contactList) throws PIMException {
        Contact matchingContact = contactList.createContact();
        if (pimContact.getFormattedName() != null) {
            matchingContact.addString(105, 0, pimContact.getFormattedName());
        }
        if (pimContact.getUid() != null) {
            matchingContact.addString(117, 0, pimContact.getUid());
        }
        matchingContact.addInt(102, 0, 202);
        Enumeration matchingItems = null;
        matchingItems = contactList.items((PIMItem)matchingContact);
        Vector<Contact> contactItems = new Vector<Contact>();
        while (matchingItems.hasMoreElements()) {
            Contact contactItem = (Contact)matchingItems.nextElement();
            contactItems.addElement(contactItem);
        }
        if (contactItems.size() == 1) {
            contactList.removeContact((Contact)contactItems.elementAt(0));
        }
    }

    public void removeEvent(CalendarEntry calendarEntry) throws PIMException {
        EventList eventList = this.getDefaultEventList();
        this.removeEventHelper(calendarEntry, eventList);
    }

    public void removeEvent(CalendarEntry calendarEntry, String nameOfList) throws PIMException {
        EventList eventList = this.getEventList(nameOfList);
        this.removeEventHelper(calendarEntry, eventList);
    }

    private void removeEventHelper(CalendarEntry calendarEntry, EventList eventList) throws PIMException {
        Event matchingEvent = eventList.createEvent();
        if (calendarEntry.getSummary() != null) {
            matchingEvent.addString(107, 0, calendarEntry.getSummary());
        }
        if (calendarEntry.getLocation() != null) {
            matchingEvent.addString(103, 0, calendarEntry.getLocation());
        }
        if (calendarEntry.getStartDate() != null) {
            matchingEvent.addDate(106, 0, calendarEntry.getStartDate().getTimeInMillis());
        }
        if (calendarEntry.getId() != null) {
            matchingEvent.addString(108, 0, calendarEntry.getId());
        }
        matchingEvent.addInt(101, 0, 202);
        Enumeration matchingItems = null;
        matchingItems = eventList.items((PIMItem)matchingEvent);
        Vector<Event> eventItems = new Vector<Event>();
        while (matchingItems.hasMoreElements()) {
            Event eventItem = (Event)matchingItems.nextElement();
            eventItems.addElement(eventItem);
        }
        if (eventItems.size() == 1) {
            eventList.removeEvent((Event)eventItems.elementAt(0));
        }
    }

    public void removeToDo(PimToDo pimToDo) throws PIMException {
        ToDoList toDoList = this.getDefaultToDoList();
        this.removeToDoHelper(pimToDo, toDoList);
    }

    public void removeToDo(PimToDo pimToDo, String nameOfList) throws PIMException {
        ToDoList toDoList = this.getToDoList(nameOfList);
        this.removeToDoHelper(pimToDo, toDoList);
    }

    private void removeToDoHelper(PimToDo pimToDo, ToDoList toDoList) throws PIMException {
        ToDo matchingToDo = toDoList.createToDo();
        if (pimToDo.getNote() != null) {
            matchingToDo.addString(104, 0, pimToDo.getSummary());
        }
        if (pimToDo.getPriority() <= 9 && pimToDo.getPriority() >= 0) {
            matchingToDo.addInt(105, 0, pimToDo.getPriority());
        }
        if (pimToDo.getDueDate() != null) {
            matchingToDo.addDate(103, 0, pimToDo.getDueDate().getTime());
        }
        if (pimToDo.getUid() != null) {
            matchingToDo.addString(108, 0, pimToDo.getUid());
        }
        matchingToDo.addInt(100, 0, 202);
        Enumeration matchingItems = null;
        matchingItems = toDoList.items((PIMItem)matchingToDo);
        Vector<ToDo> toDoItems = new Vector<ToDo>();
        while (matchingItems.hasMoreElements()) {
            ToDo toDoItem = (ToDo)matchingItems.nextElement();
            toDoItems.addElement(toDoItem);
        }
        if (toDoItems.size() == 1) {
            toDoList.removeToDo((ToDo)toDoItems.elementAt(0));
        }
    }

    public void updateContact(PimContact pimContact) throws PIMException {
        ContactList contactList = this.getDefaultContactList();
        this.updateContactHelper(pimContact, contactList);
    }

    public void updateContact(PimContact pimContact, String nameOfList) throws PIMException {
        ContactList contactList = this.getContactList(nameOfList);
        this.updateContactHelper(pimContact, contactList);
    }

    private void updateContactHelper(PimContact pimContact, ContactList contactList) throws PIMException {
        try {
            Contact contact = contactList.createContact();
            int[] fields = contact.getPIMList().getSupportedFields();
            block10: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = contact.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 105 && pimContact.getFormattedName() != null) {
                            contact.setString(105, 0, 0, pimContact.getFormattedName());
                            continue block10;
                        }
                        if (field == 104 && pimContact.getFormattedAddress() != null) {
                            contact.setString(104, 0, 0, pimContact.getFormattedAddress());
                            continue block10;
                        }
                        if (field == 103 && pimContact.getEmailAddress() != null) {
                            contact.setString(103, 0, 0, pimContact.getEmailAddress());
                            continue block10;
                        }
                        if (field == 107 && pimContact.getNickName() != null) {
                            contact.setString(107, 0, 0, pimContact.getNickName());
                            continue block10;
                        }
                        if (field == 108 && pimContact.getNotes() != null) {
                            contact.setString(108, 0, 0, pimContact.getNotes());
                            continue block10;
                        }
                        if (field == 115 && pimContact.getTelephoneNumber() != null) {
                            contact.setString(115, 0, 0, pimContact.getTelephoneNumber());
                            continue block10;
                        }
                        if (field == 118 && pimContact.getUrlForContact() != null) {
                            contact.setString(118, 0, 0, pimContact.getUrlForContact());
                            continue block10;
                        }
                        if (field == 111 && pimContact.getPhotoUrl() != null) {
                            contact.setString(111, 0, 0, pimContact.getPhotoUrl());
                            continue block10;
                        }
                        if (field == 113 && pimContact.getPublicKeyString() != null) {
                            contact.setString(113, 0, 0, pimContact.getPublicKeyString());
                            continue block10;
                        }
                        if (field != 117) continue block10;
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                    case 5: {
                        if (field == 100) {
                            String[] addressArray = new String[contactList.stringArraySize(100)];
                            if (pimContact.getContactAddress() != null) {
                                if (contactList.isSupportedArrayElement(100, 6) && pimContact.getContactAddress().getCountryOfAddress() != null) {
                                    addressArray[6] = pimContact.getContactAddress().getCountryOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 1) && pimContact.getContactAddress().getExtraInfoOfAddress() != null) {
                                    addressArray[1] = pimContact.getContactAddress().getExtraInfoOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 3) && pimContact.getContactAddress().getLocalityOfAddress() != null) {
                                    addressArray[3] = pimContact.getContactAddress().getLocalityOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 0) && pimContact.getContactAddress().getPoBoxOfAddress() != null) {
                                    addressArray[0] = pimContact.getContactAddress().getPoBoxOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 5) && pimContact.getContactAddress().getPostalCode() != null) {
                                    addressArray[5] = pimContact.getContactAddress().getPostalCode();
                                } else if (contactList.isSupportedArrayElement(100, 4) && pimContact.getContactAddress().getRegionOfAddress() != null) {
                                    addressArray[4] = pimContact.getContactAddress().getRegionOfAddress();
                                } else if (contactList.isSupportedArrayElement(100, 2) && pimContact.getContactAddress().getStreetAddress() != null) {
                                    addressArray[2] = pimContact.getContactAddress().getStreetAddress();
                                }
                            }
                            contact.setStringArray(100, 0, 0, addressArray);
                            continue block10;
                        }
                        if (field != 106) continue block10;
                        String[] nameArray = new String[contactList.stringArraySize(106)];
                        if (pimContact.getContactName() != null) {
                            if (contactList.isSupportedArrayElement(106, 0) && pimContact.getContactName().getFamilyName() != null) {
                                nameArray[0] = pimContact.getContactName().getFamilyName();
                            } else if (contactList.isSupportedArrayElement(106, 1) && pimContact.getContactName().getGivenName() != null) {
                                nameArray[1] = pimContact.getContactName().getGivenName();
                            } else if (contactList.isSupportedArrayElement(106, 2) && pimContact.getContactName().getOtherName() != null) {
                                nameArray[2] = pimContact.getContactName().getOtherName();
                            } else if (contactList.isSupportedArrayElement(106, 3) && pimContact.getContactName().getPrefixOfName() != null) {
                                nameArray[3] = pimContact.getContactName().getPrefixOfName();
                            } else if (contactList.isSupportedArrayElement(106, 4) && pimContact.getContactName().getSuffixOfName() != null) {
                                nameArray[4] = pimContact.getContactName().getSuffixOfName();
                            }
                        }
                        contact.addStringArray(106, 0, nameArray);
                        continue block10;
                    }
                    case 2: {
                        if (field == 101 && pimContact.getDateOfBirth() != null) {
                            contact.setDate(101, 0, 0, pimContact.getDateOfBirth().getTime());
                            continue block10;
                        }
                        if (field != 114 || pimContact.getLastRevision() == null) continue block10;
                        contact.setDate(114, 0, 0, pimContact.getLastRevision().getTime());
                        continue block10;
                    }
                    case 3: {
                        if (field != 102 || pimContact.getClassOfContact() == 0) continue block10;
                        contact.setInt(102, 0, 0, pimContact.getClassOfContact());
                        continue block10;
                    }
                    case 0: {
                        if (field == 110 && pimContact.getPhoto() != null) {
                            contact.setBinary(110, 0, 0, pimContact.getPhoto(), 0, pimContact.getPhoto().length);
                            continue block10;
                        }
                        if (field != 112 || pimContact.getPublicKey() == null) continue block10;
                        contact.setBinary(112, 0, 0, pimContact.getPublicKey(), 0, pimContact.getPublicKey().length);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while updating Contact Item with given details:" + e.getMessage());
        }
    }

    public void updateEvent(CalendarEntry calendarEntry) throws PIMException {
        EventList eventList = this.getDefaultEventList();
        this.updateEventHelper(calendarEntry, eventList);
    }

    public void updateEvent(CalendarEntry calendarEntry, String nameOfList) throws PIMException {
        EventList eventList = this.getEventList(nameOfList);
        this.updateEventHelper(calendarEntry, eventList);
    }

    private void updateEventHelper(CalendarEntry calendarEntry, EventList eventList) throws PIMException {
        try {
            Event event = eventList.createEvent();
            int[] fields = event.getPIMList().getSupportedFields();
            block9: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = event.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 103) {
                            event.setString(103, 0, 0, calendarEntry.getLocation());
                            continue block9;
                        }
                        if (field == 104) {
                            event.setString(104, 0, 0, calendarEntry.getNotes());
                            continue block9;
                        }
                        if (field == 107) {
                            event.setString(107, 0, 0, calendarEntry.getSummary());
                            continue block9;
                        }
                        if (field != 108) continue block9;
                        continue block9;
                    }
                    case 1: {
                        continue block9;
                    }
                    case 5: {
                        continue block9;
                    }
                    case 2: {
                        if (field == 106) {
                            event.setDate(106, 0, 0, calendarEntry.getStartDate().getTimeInMillis());
                            continue block9;
                        }
                        if (field != 102) continue block9;
                        event.setDate(102, 0, 0, calendarEntry.getEndDate().getTimeInMillis());
                        continue block9;
                    }
                    case 3: {
                        if (field == 101) {
                            Integer classOfEvent = (Integer)calendarEntry.getField("ClassOfEvent");
                            if (classOfEvent == null) continue block9;
                            event.setInt(101, 0, 0, classOfEvent.intValue());
                            continue block9;
                        }
                        if (field != 100) continue block9;
                        event.setInt(100, 0, 0, calendarEntry.getAlarm());
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while updating Event Item with given details:" + e.getMessage());
        }
    }

    public void updateToDo(PimToDo pimToDo) throws PIMException {
        ToDoList toDoList = this.getDefaultToDoList();
        this.updateToDoHelper(pimToDo, toDoList);
    }

    public void updateToDo(PimToDo pimToDo, String nameOfList) throws PIMException {
        ToDoList toDoList = this.getToDoList(nameOfList);
        this.updateToDoHelper(pimToDo, toDoList);
    }

    private void updateToDoHelper(PimToDo pimToDo, ToDoList toDoList) throws PIMException {
        try {
            ToDo toDo = toDoList.createToDo();
            int[] fields = toDo.getPIMList().getSupportedFields();
            block9: for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                int dataType = toDo.getPIMList().getFieldDataType(field);
                switch (dataType) {
                    case 4: {
                        if (field == 104) {
                            toDo.setString(104, 0, 0, pimToDo.getNote());
                            continue block9;
                        }
                        if (field == 107) {
                            toDo.setString(107, 0, 0, pimToDo.getSummary());
                            continue block9;
                        }
                        if (field != 108) continue block9;
                        continue block9;
                    }
                    case 1: {
                        if (field != 101) continue block9;
                        toDo.setBoolean(101, 0, 0, pimToDo.isCompleted());
                        continue block9;
                    }
                    case 5: {
                        continue block9;
                    }
                    case 2: {
                        if (field == 102) {
                            toDo.setDate(102, 0, 0, pimToDo.getCompletionDate().getTime());
                            continue block9;
                        }
                        if (field == 103) {
                            toDo.setDate(103, 0, 0, pimToDo.getDueDate().getTime());
                            continue block9;
                        }
                        if (field != 106) continue block9;
                        toDo.setDate(106, 0, 0, pimToDo.getLastRevisedDate().getTime());
                        continue block9;
                    }
                    case 3: {
                        if (field != 100) continue block9;
                        toDo.setInt(100, 0, 0, pimToDo.getClassOfToDo());
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PIMException("Error Occured while updating ToDo Item with given details:" + e.getMessage());
        }
    }

    public String[] getAllCategoriesOfContactList(ContactList contactList) throws PIMException {
        String[] categories = null;
        categories = contactList.getCategories();
        return categories;
    }

    public String[] getAllCategoriesOfEventList(EventList eventList) throws PIMException {
        String[] categories = null;
        categories = eventList.getCategories();
        return categories;
    }

    public String[] getAllCategoriesOfToDoList(ToDoList toDoList) throws PIMException {
        String[] categories = null;
        categories = toDoList.getCategories();
        return categories;
    }

    public void addCategoryToContactList(ContactList contactList, String nameOfCategory) throws PIMException {
        String[] categories = contactList.getCategories();
        if (contactList.maxCategories() == categories.length) {
            throw new PIMException("Max Number Of categories Limit is reached");
        }
        contactList.addCategory(nameOfCategory);
    }

    public void addCategoryToEventList(EventList eventList, String nameOfCategory) throws PIMException {
        String[] categories = eventList.getCategories();
        if (eventList.maxCategories() == categories.length) {
            throw new PIMException("Max Number Of categories Limit is reached");
        }
        eventList.addCategory(nameOfCategory);
    }

    public void addCategoryToToDoList(ToDoList toDoList, String nameOfCategory) throws PIMException {
        String[] categories = toDoList.getCategories();
        if (toDoList.maxCategories() == categories.length) {
            throw new PIMException("Max Number Of categories Limit is reached");
        }
        toDoList.addCategory(nameOfCategory);
    }

    public PimContact[] getAllContactsByCategory(ContactList contactList, String nameOfCategory) throws PIMException {
        if (contactList.isCategory(nameOfCategory)) {
            Enumeration enumeratedItems = contactList.itemsByCategory(nameOfCategory);
            return this.getAllContactsOfEnumeration(contactList, enumeratedItems);
        }
        return null;
    }

    public CalendarEntry[] getAllEventsByCategory(EventList eventList, String nameOfCategory) throws PIMException {
        if (eventList.isCategory(nameOfCategory)) {
            Enumeration enumeratedItems = eventList.itemsByCategory(nameOfCategory);
            return this.getAllEventsOfEnumeration(eventList, enumeratedItems);
        }
        return null;
    }

    public PimToDo[] getAllToDosByCategory(ToDoList toDoList, String nameOfCategory) throws PIMException {
        if (toDoList.isCategory(nameOfCategory)) {
            Enumeration enumeratedItems = toDoList.itemsByCategory(nameOfCategory);
            return this.getAllToDosOfEnumeration(toDoList, enumeratedItems);
        }
        return null;
    }

    public void deleteCategoryFromPimList(PIMList pimList, String nameOfCategory) throws PIMException {
        if (pimList.isCategory(nameOfCategory)) {
            pimList.deleteCategory(nameOfCategory, false);
        }
    }

    public void renameCategory(PIMList pimList, String fromNameOfCategory, String toNameOfCategory) throws PIMException {
        if (pimList.isCategory(fromNameOfCategory)) {
            pimList.renameCategory(fromNameOfCategory, toNameOfCategory);
        }
    }

    public String[] getFieldLabelsOfContactList(String nameOfList) throws PIMException {
        ContactList contactList = this.getContactList(nameOfList);
        int[] fields = contactList.getSupportedFields();
        String[] fieldLabels = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldLabels[i] = contactList.getFieldLabel(fields[i]);
        }
        return fieldLabels;
    }

    public String[] getFieldLabelsOfEventList(String nameOfList) throws PIMException {
        EventList eventList = this.getEventList(nameOfList);
        int[] fields = eventList.getSupportedFields();
        String[] fieldLabels = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldLabels[i] = eventList.getFieldLabel(fields[i]);
        }
        return fieldLabels;
    }

    public String[] getFieldLabelsOfToDoList(String nameOfList) throws PIMException {
        ToDoList toDoList = this.getToDoList(nameOfList);
        int[] fields = toDoList.getSupportedFields();
        String[] fieldLabels = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldLabels[i] = toDoList.getFieldLabel(fields[i]);
        }
        return fieldLabels;
    }

    public PimContact findContactByUid(String uid) throws PIMException {
        ContactList contactList = this.getDefaultContactList();
        Contact matchingContact = contactList.createContact();
        if (uid != null) {
            matchingContact.addString(117, 0, uid);
        }
        Enumeration matchingItems = null;
        matchingItems = contactList.items((PIMItem)matchingContact);
        PimContact[] contactItems = this.getAllContactsOfEnumeration(contactList, matchingItems);
        if (contactItems != null && contactItems.length >= 0) {
            return contactItems[0];
        }
        return null;
    }

    public CalendarEntry findEventByUid(String uid) throws PIMException {
        EventList eventList = this.getDefaultEventList();
        Event matchingEvent = eventList.createEvent();
        if (uid != null) {
            matchingEvent.addString(117, 0, uid);
        }
        Enumeration matchingItems = null;
        matchingItems = eventList.items((PIMItem)matchingEvent);
        CalendarEntry[] eventItems = this.getAllEventsOfEnumeration(eventList, matchingItems);
        if (eventItems != null && eventItems.length >= 0) {
            return eventItems[0];
        }
        return null;
    }

    public PimToDo findToDoByUid(String uid) throws PIMException {
        ToDoList toDoList = this.getDefaultToDoList();
        ToDo matchingToDo = toDoList.createToDo();
        if (uid != null) {
            matchingToDo.addString(117, 0, uid);
        }
        Enumeration matchingItems = null;
        matchingItems = toDoList.items((PIMItem)matchingToDo);
        PimToDo[] toDoItems = this.getAllToDosOfEnumeration(toDoList, matchingItems);
        if (toDoItems != null && toDoItems.length >= 0) {
            return toDoItems[0];
        }
        return null;
    }

    public String[] getArrayElementNamesOfContactList(String fieldLabel, String nameOfList) throws PIMException {
        String[] arrayElementNames = null;
        ContactList contactList = null;
        contactList = nameOfList == null ? this.getDefaultContactList() : this.getContactList(nameOfList);
        int[] fields = contactList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            int dataType = contactList.getFieldDataType(field);
            String label = contactList.getFieldLabel(field);
            if (dataType != 5 || !fieldLabel.equals(label)) continue;
            int[] supportedArrayElements = contactList.getSupportedArrayElements(field);
            arrayElementNames = new String[supportedArrayElements.length];
            for (int j = 0; j < supportedArrayElements.length; ++j) {
                arrayElementNames[j] = contactList.getArrayElementLabel(field, supportedArrayElements[j]);
            }
        }
        return arrayElementNames;
    }

    public String[] getAttributeNamesOfContactList(String fieldLabel, String nameOfList) throws PIMException {
        String[] attributeNames = null;
        ContactList contactList = null;
        contactList = nameOfList == null ? this.getDefaultContactList() : this.getContactList(nameOfList);
        int[] fields = contactList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int[] supportedAttributes;
            int field = fields[i];
            String label = contactList.getFieldLabel(field);
            if (!fieldLabel.equals(label) || (supportedAttributes = contactList.getSupportedAttributes(field)) == null) continue;
            attributeNames = new String[supportedAttributes.length];
            for (int j = 0; j < supportedAttributes.length; ++j) {
                attributeNames[j] = contactList.getAttributeLabel(supportedAttributes[j]);
            }
        }
        return attributeNames;
    }

    public String[] getArrayElementNamesOfEventList(String fieldLabel, String nameOfList) throws PIMException {
        String[] arrayElementNames = null;
        EventList eventList = null;
        eventList = nameOfList == null ? this.getDefaultEventList() : this.getEventList(nameOfList);
        int[] fields = eventList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            int dataType = eventList.getFieldDataType(field);
            String label = eventList.getFieldLabel(field);
            if (dataType != 5 || !fieldLabel.equals(label)) continue;
            int[] supportedArrayElements = eventList.getSupportedArrayElements(field);
            arrayElementNames = new String[supportedArrayElements.length];
            for (int j = 0; j < supportedArrayElements.length; ++j) {
                arrayElementNames[j] = eventList.getArrayElementLabel(field, supportedArrayElements[j]);
            }
        }
        return arrayElementNames;
    }

    public String[] getAttributeNamesOfEventList(String fieldLabel, String nameOfList) throws PIMException {
        String[] attributeNames = null;
        EventList eventList = null;
        eventList = nameOfList == null ? this.getDefaultEventList() : this.getEventList(nameOfList);
        int[] fields = eventList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int[] supportedAttributes;
            int field = fields[i];
            String label = eventList.getFieldLabel(field);
            if (!fieldLabel.equals(label) || (supportedAttributes = eventList.getSupportedAttributes(field)) == null) continue;
            attributeNames = new String[supportedAttributes.length];
            for (int j = 0; j < supportedAttributes.length; ++j) {
                attributeNames[j] = eventList.getAttributeLabel(supportedAttributes[j]);
            }
        }
        return attributeNames;
    }

    public String[] getArrayElementNamesOfToDoList(String fieldLabel, String nameOfList) throws PIMException {
        String[] arrayElementNames = null;
        ToDoList toDoList = null;
        toDoList = nameOfList == null ? this.getDefaultToDoList() : this.getToDoList(nameOfList);
        int[] fields = toDoList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            int dataType = toDoList.getFieldDataType(field);
            String label = toDoList.getFieldLabel(field);
            if (dataType != 5 || !fieldLabel.equals(label)) continue;
            int[] supportedArrayElements = toDoList.getSupportedArrayElements(field);
            arrayElementNames = new String[supportedArrayElements.length];
            for (int j = 0; j < supportedArrayElements.length; ++j) {
                arrayElementNames[j] = toDoList.getArrayElementLabel(field, supportedArrayElements[j]);
            }
        }
        return arrayElementNames;
    }

    public String[] getAttributeNamesOfToDoList(String fieldLabel, String nameOfList) throws PIMException {
        String[] attributeNames = null;
        ToDoList toDoList = null;
        toDoList = nameOfList == null ? this.getDefaultToDoList() : this.getToDoList(nameOfList);
        int[] fields = toDoList.getSupportedFields();
        for (int i = 0; i < fields.length; ++i) {
            int[] supportedAttributes;
            int field = fields[i];
            String label = toDoList.getFieldLabel(field);
            if (!fieldLabel.equals(label) || (supportedAttributes = toDoList.getSupportedAttributes(field)) == null) continue;
            attributeNames = new String[supportedAttributes.length];
            for (int j = 0; j < supportedAttributes.length; ++j) {
                attributeNames[j] = toDoList.getAttributeLabel(supportedAttributes[j]);
            }
        }
        return attributeNames;
    }
}

