/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io.xmlrpc;

import de.enough.polish.util.TextUtil;
import de.enough.polish.util.base64.Base64;
import de.enough.polish.xml.XmlDomNode;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XmlRpcSerializer {
    public static void serialize(StringBuffer buffer, Object object) throws IOException {
        if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            buffer.append("<i4>").append(object.toString()).append("</i4>");
        } else if (object instanceof Long) {
            buffer.append("<i8>").append(object.toString()).append("</i8>");
        } else if (object instanceof Double || object instanceof Float) {
            buffer.append("<double>").append(object.toString()).append("</double>");
        } else if (object instanceof Boolean) {
            buffer.append("<boolean>").append((Boolean)object != false ? (char)'1' : '0').append("</boolean>");
        } else if (object instanceof String) {
            String value = (String)object;
            value = TextUtil.replace(value, "&", "&amp;");
            value = TextUtil.replace(value, "<", "&lt;");
            buffer.append("<string>").append(value).append("</string>");
        } else if (object instanceof Date) {
            Date date = (Date)object;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            XmlRpcSerializer.serialize(buffer, calendar);
        } else if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            buffer.append("<dateTime.iso8601>");
            buffer.append(calendar.get(1));
            int month = calendar.get(2);
            if (month < 9) {
                buffer.append('0');
            }
            buffer.append(++month);
            int day = calendar.get(5);
            if (day < 10) {
                buffer.append('0');
            }
            buffer.append(day);
            buffer.append('T');
            int hour = calendar.get(11);
            if (hour < 10) {
                buffer.append('0');
            }
            buffer.append(hour).append(':');
            int minute = calendar.get(12);
            if (minute < 10) {
                buffer.append('0');
            }
            buffer.append(minute).append(':');
            int second = calendar.get(13);
            if (second < 10) {
                buffer.append('0');
            }
            buffer.append(second);
            buffer.append("</dateTime.iso8601>");
        } else if (object instanceof byte[]) {
            String value = Base64.encodeBytes((byte[])object);
            buffer.append("<base64>").append(value).append("</base64>");
        } else if (object instanceof Vector) {
            buffer.append("<array><data>");
            Vector vector = (Vector)object;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                buffer.append("<value>");
                XmlRpcSerializer.serialize(buffer, o);
                buffer.append("</value>");
            }
            buffer.append("</data></array>");
        } else if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            buffer.append("<array><data>");
            for (int i = 0; i < objects.length; ++i) {
                Object o = objects[i];
                buffer.append("<value>");
                XmlRpcSerializer.serialize(buffer, o);
                buffer.append("</value>");
            }
            buffer.append("</data></array>");
        } else if (object instanceof Hashtable) {
            buffer.append("<struct>");
            Hashtable table = (Hashtable)object;
            Enumeration enumeration = table.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = table.get(key);
                buffer.append("<member>");
                buffer.append("<name>").append(key.toString()).append("</name>");
                buffer.append("<value>");
                XmlRpcSerializer.serialize(buffer, value);
                buffer.append("</value>");
                buffer.append("</member>");
            }
            buffer.append("</struct>");
        } else {
            throw new IOException("Unable to xml-rpc serialize " + object);
        }
    }

    public static Object deserialize(XmlDomNode node) throws IOException {
        if (node.getChildCount() == 0) {
            String value = node.getText();
            value = TextUtil.replace(value, "&lt;", "<");
            value = TextUtil.replace(value, "&amp;", "&");
            return value;
        }
        XmlDomNode nextNode = node.getChild(0);
        String nextElement = nextNode.getName();
        if (nextElement.equals("int") || nextElement.equals("i4")) {
            String value = nextNode.getText();
            return new Integer(Integer.parseInt(value));
        }
        if (nextElement.equals("i8")) {
            String value = nextNode.getText();
            return new Long(Long.parseLong(value));
        }
        if (nextElement.equals("double")) {
            String value = nextNode.getText();
            return new Double(Double.parseDouble(value));
        }
        if (nextElement.equals("boolean")) {
            String value = nextNode.getText();
            Boolean result = value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
            return result;
        }
        if (nextElement.equals("string")) {
            String value = nextNode.getText();
            value = TextUtil.replace(value, "&lt;", "<");
            value = TextUtil.replace(value, "&amp;", "&");
            return value;
        }
        if (nextElement.equals("dateTime.iso8601")) {
            String value = nextNode.getText();
            if (value.length() != 17) {
                throw new IOException("Unable to deserialize dateTime " + value + " - not 17 chars long");
            }
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(4, 6)) - 1;
            int day = Integer.parseInt(value.substring(6, 8));
            int hour = Integer.parseInt(value.substring(9, 11));
            int minute = Integer.parseInt(value.substring(12, 14));
            int seconds = Integer.parseInt(value.substring(15, 17));
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, seconds);
            return calendar;
        }
        if (nextElement.equals("base64")) {
            String dataStr = nextNode.getText();
            return Base64.decode(dataStr);
        }
        if (nextElement.equals("array")) {
            XmlDomNode dataNode = nextNode.getChild("data");
            Object[] results = new Object[dataNode.getChildCount()];
            for (int i = 0; i < results.length; ++i) {
                results[i] = XmlRpcSerializer.deserialize(dataNode.getChild(i));
            }
            return results;
        }
        if (nextElement.equals("struct")) {
            Hashtable<String, Object> table = new Hashtable<String, Object>(nextNode.getChildCount());
            for (int i = 0; i < nextNode.getChildCount(); ++i) {
                XmlDomNode memberNode = nextNode.getChild(i);
                String name = memberNode.getChild("name").getText();
                Object value = XmlRpcSerializer.deserialize(memberNode.getChild("value"));
                table.put(name, value);
            }
            return table;
        }
        throw new IOException("Unable to deserialize " + nextElement);
    }
}

