/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io.file;

import de.enough.polish.io.file.FileSystemNode;
import de.enough.polish.ui.TreeModel;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileSystemTreeModel
implements TreeModel {
    private FileConnection fileConnection;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChildren(Object parent, ArrayList list) {
        if (parent == this) {
            Enumeration enumeration = FileSystemRegistry.listRoots();
            while (enumeration.hasMoreElements()) {
                String path = (String)enumeration.nextElement();
                list.add(new FileSystemNode(path, null));
            }
            return;
        }
        if (!(parent instanceof FileSystemNode)) return;
        FileSystemNode node = (FileSystemNode)parent;
        String nodePath = node.getPath();
        boolean establishNewFileConnection = false;
        if (this.fileConnection == null) {
            establishNewFileConnection = true;
        } else {
            String newPathName;
            String currentPath = this.fileConnection.getPath();
            int pos = nodePath.indexOf(currentPath);
            if (pos != -1) {
                newPathName = nodePath.substring(pos + currentPath.length());
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < currentPath.length(); ++i) {
                    char c = currentPath.charAt(i);
                    if (c != '/') continue;
                    buffer.append("../");
                }
                buffer.append(nodePath);
                newPathName = buffer.toString();
            }
            try {
                this.fileConnection.setFileConnection(newPathName);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.io.file.FileSystemTreeModel", 93, (Object)("Unable to reset fileconnection to \"" + newPathName + "\""), e);
                establishNewFileConnection = true;
            }
        }
        if (establishNewFileConnection) {
            if (this.fileConnection != null) {
                try {
                    this.fileConnection.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.fileConnection = (FileConnection)Connector.open("file:///" + node.getAbsolutePath(), 1);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.io.file.FileSystemTreeModel", 112, (Object)("Unable to open file connection to \"file:///" + node.getAbsolutePath() + "\""), e);
                return;
            }
        }
        try {
            Enumeration enumeration = this.fileConnection.list("*", true);
            while (enumeration.hasMoreElements()) {
                String path = (String)enumeration.nextElement();
                list.add(new FileSystemNode(path, node));
            }
            if (list.size() != 0) return;
            enumeration = this.fileConnection.list();
            while (enumeration.hasMoreElements()) {
                String path = (String)enumeration.nextElement();
                list.add(new FileSystemNode(path, node));
            }
            return;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.io.file.FileSystemTreeModel", 133, (Object)("Unable to list contents of \"" + this.fileConnection.getPath() + "\""), e);
        }
    }

    public Object getRoot() {
        return this;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof FileSystemNode) {
            FileSystemNode fsNode = (FileSystemNode)node;
            return !fsNode.isDirectory();
        }
        return true;
    }
}

