/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io;

import de.enough.polish.io.Serializer;
import de.enough.polish.io.Storage;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RmsStorage
implements Storage {
    private RecordStore masterRecordStore;
    private final HashMap masterRecordSetIdsByName;
    private final HashMap masterRecordSetNameById;
    private final int indexRecordId;
    private boolean isClosed;
    private String mastRecordStoreName;
    static ArrayList masterRecordStores = new ArrayList();

    public RmsStorage() {
        this.masterRecordStore = null;
        this.masterRecordSetIdsByName = null;
        this.masterRecordSetNameById = null;
        this.indexRecordId = -1;
    }

    public RmsStorage(String singleRecordStoreName) throws IOException {
        if (singleRecordStoreName != null) {
            try {
                this.mastRecordStoreName = singleRecordStoreName;
                this.masterRecordStore = RecordStore.openRecordStore(singleRecordStoreName, true);
                this.masterRecordSetIdsByName = new HashMap();
                this.masterRecordSetNameById = new HashMap();
                if (!masterRecordStores.contains(this.masterRecordStore)) {
                    masterRecordStores.add(this.masterRecordStore);
                }
                RecordEnumeration enumeration = this.masterRecordStore.enumerateRecords(null, null, false);
                int firstId = Integer.MAX_VALUE;
                while (enumeration.hasNextElement()) {
                    int id = enumeration.nextRecordId();
                    if (id >= firstId) continue;
                    firstId = id;
                }
                enumeration.destroy();
                if (firstId == Integer.MAX_VALUE) {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(byteOut);
                    out.writeInt(0);
                    byte[] data = byteOut.toByteArray();
                    this.indexRecordId = this.masterRecordStore.addRecord(data, 0, data.length);
                    out.close();
                    byteOut.close();
                }
                this.indexRecordId = firstId;
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.masterRecordStore.getRecord(firstId)));
                int numberOfEntries = in.readInt();
                Integer inte = null;
                for (int i = 0; i < numberOfEntries; ++i) {
                    String name = in.readUTF();
                    int recordId = in.readInt();
                    inte = new Integer(recordId);
                    this.masterRecordSetIdsByName.put(name, inte);
                    this.masterRecordSetNameById.put(inte, name);
                    inte = null;
                }
                in.close();
            }
            catch (RecordStoreException e) {
                throw new IOException(e.toString());
            }
        } else {
            this.masterRecordStore = null;
            this.masterRecordSetIdsByName = null;
            this.masterRecordSetNameById = null;
            this.indexRecordId = -1;
        }
    }

    public static void shutdown() {
        for (int i = 0; i < masterRecordStores.size(); ++i) {
            RecordStore store = (RecordStore)masterRecordStores.get(i);
            try {
                store.closeRecordStore();
                continue;
            }
            catch (RecordStoreNotOpenException e) {
                continue;
            }
            catch (RecordStoreException e) {
                Debug.debug("error", "de.enough.polish.io.RmsStorage", 179, (Object)"unable to close master recordstore ", e.toString());
            }
        }
    }

    public int getRecordSetId(String name) {
        Integer id = (Integer)this.masterRecordSetIdsByName.get(name);
        if (id != null) {
            return id;
        }
        return -1;
    }

    public String getRecordLogicKey(int recordSetId) {
        String logicalKey = (String)this.masterRecordSetNameById.get(new Integer(recordSetId));
        return logicalKey;
    }

    private void registerRecordSetId(int id, String name) throws IOException, RecordStoreException {
        Integer idInt = new Integer(id);
        this.masterRecordSetIdsByName.put(name, idInt);
        this.masterRecordSetNameById.put(idInt, name);
        idInt = null;
        Object[] keys = this.masterRecordSetIdsByName.keys();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        out.writeInt(this.masterRecordSetIdsByName.size());
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            idInt = (Integer)this.masterRecordSetIdsByName.get(key);
            out.writeUTF(key);
            out.writeInt(idInt);
        }
        byte[] data = byteOut.toByteArray();
        this.masterRecordStore.setRecord(this.indexRecordId, data, 0, data.length);
        out.close();
        byteOut.close();
    }

    public void save(Object object, String name) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        Serializer.serialize(object, out);
        byte[] data = byteOut.toByteArray();
        out.close();
        byteOut.close();
        this.saveData(name, data);
    }

    public void update(Object object, String newKey, String oldKey) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        Serializer.serialize(object, out);
        byte[] data = byteOut.toByteArray();
        out.close();
        byteOut.close();
        this.saveData(newKey, oldKey, data);
    }

    private void saveData(String name, byte[] data) throws IOException {
        this.saveData(name, null, data);
    }

    private void saveData(String newKey, String oldKey, byte[] data) throws IOException {
        try {
            if (this.masterRecordStore != null) {
                this.ensureOpen();
                int recordSetId = -1;
                if (oldKey != null) {
                    recordSetId = this.getRecordSetId(oldKey);
                    Integer recordInt = new Integer(recordSetId);
                    if (recordSetId != -1) {
                        if (this.getRecordSetId(newKey) != -1 && !newKey.equals(oldKey)) {
                            throw new IOException("key already used");
                        }
                        this.masterRecordSetIdsByName.remove(oldKey);
                        this.masterRecordSetNameById.remove(recordInt);
                        recordInt = null;
                        this.masterRecordStore.setRecord(recordSetId, data, 0, data.length);
                        this.registerRecordSetId(recordSetId, newKey);
                    }
                } else {
                    if (this.getRecordSetId(newKey) != -1) {
                        throw new IOException("key already used");
                    }
                    recordSetId = this.masterRecordStore.addRecord(data, 0, data.length);
                    this.registerRecordSetId(recordSetId, newKey);
                }
            } else {
                RecordStore store = RecordStore.openRecordStore(newKey, true);
                int recordSetId = -1;
                RecordEnumeration enumeration = store.enumerateRecords(null, null, false);
                if (enumeration.hasNextElement()) {
                    recordSetId = enumeration.nextRecordId();
                }
                enumeration.destroy();
                if (recordSetId == -1) {
                    store.addRecord(data, 0, data.length);
                } else {
                    store.setRecord(recordSetId, data, 0, data.length);
                }
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.io.RmsStorage", 356, (Object)("Unable to store object under name [" + newKey + "]"), e);
            throw new IOException(e.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object read(String name) throws IOException {
        block12: {
            store = null;
            if (this.masterRecordStore != null) {
                this.ensureOpen();
                recordId = this.getRecordSetId(name);
                if (recordId == -1) {
                    throw new IOException(name + " is unknown");
                }
                data = this.masterRecordStore.getRecord(recordId);
                break block12;
            }
            store = RecordStore.openRecordStore(name, false);
            enumeration = store.enumerateRecords(null, null, false);
            data = enumeration.nextRecord();
            enumeration.destroy();
        }
        var6_8 = null;
        try {
            if (store == null) ** GOTO lbl41
            store.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
        }
        catch (RecordStoreException e) {
            throw new IOException(e.toString());
        }
        {
            catch (RecordStoreException e) {
                throw new IOException(e.toString());
            }
        }
        catch (Throwable var5_14) {
            var6_9 = null;
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException e) {
                throw new IOException(e.toString());
            }
            throw var5_14;
        }
lbl41:
        // 3 sources

        in = new DataInputStream(new ByteArrayInputStream(data));
        return Serializer.deserialize(in);
    }

    public Enumeration enumerate(String name) throws IOException {
        throw new IOException("Sorry, not supported - might drop this method altogether");
    }

    public String[] list() throws IOException {
        if (this.masterRecordStore == null) {
            throw new IllegalStateException();
        }
        return (String[])this.masterRecordSetIdsByName.keys(new String[this.masterRecordSetIdsByName.size()]);
    }

    public void delete(String name) throws IOException {
        try {
            if (this.masterRecordStore == null) {
                RecordStore.deleteRecordStore(name);
            } else if (this.masterRecordSetIdsByName != null && !this.masterRecordSetIdsByName.isEmpty()) {
                this.ensureOpen();
                Integer id = (Integer)this.masterRecordSetIdsByName.remove(name);
                this.masterRecordSetNameById.remove(id);
                if (id != null) {
                    this.masterRecordStore.deleteRecord(id);
                }
                this.registerAfterDeletingAKeyRecordSetId();
            }
        }
        catch (RecordStoreException e) {
            throw new IOException(e.toString());
        }
    }

    public void deleteAll() throws IOException {
        if (this.masterRecordSetIdsByName != null && !this.masterRecordSetIdsByName.isEmpty()) {
            this.masterRecordSetIdsByName.clear();
            this.masterRecordSetNameById.clear();
            try {
                if (this.masterRecordStore.getName() != null) {
                    String temp = this.masterRecordStore.getName();
                    this.masterRecordStore.closeRecordStore();
                    RecordStore.deleteRecordStore(temp);
                }
            }
            catch (RecordStoreException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private void registerAfterDeletingAKeyRecordSetId() throws IOException, RecordStoreException {
        Object[] keys = this.masterRecordSetIdsByName.keys();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        out.writeInt(this.masterRecordSetIdsByName.size());
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            Integer idInt = (Integer)this.masterRecordSetIdsByName.get(key);
            out.writeUTF(key);
            out.writeInt(idInt);
        }
        byte[] data = byteOut.toByteArray();
        this.masterRecordStore.setRecord(this.indexRecordId, data, 0, data.length);
        out.close();
        byteOut.close();
    }

    public int getSize() {
        if (this.masterRecordStore == null) {
            return -1;
        }
        try {
            return this.masterRecordStore.getSize();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            return -1;
        }
    }

    public int getSize(String name) {
        if (this.masterRecordStore != null) {
            return this.getSize();
        }
        try {
            RecordStore store = RecordStore.openRecordStore(name, false);
            int size = store.getSize();
            store.closeRecordStore();
            return size;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    public int getSizeAvailable() {
        if (this.masterRecordStore == null) {
            return -1;
        }
        try {
            return this.masterRecordStore.getSizeAvailable();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            return -1;
        }
    }

    public int getSizeAvailable(String name) {
        if (this.masterRecordStore != null) {
            return this.getSizeAvailable();
        }
        try {
            RecordStore store = RecordStore.openRecordStore(name, false);
            int sizeAvailable = store.getSizeAvailable();
            store.closeRecordStore();
            return sizeAvailable;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed && this.masterRecordStore != null) {
            try {
                this.masterRecordStore = RecordStore.openRecordStore(this.mastRecordStoreName, true);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
    }

    public void close() {
        try {
            this.masterRecordStore.closeRecordStore();
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.io.RmsStorage", 604, (Object)"Unable to close record store", e);
        }
        this.isClosed = true;
    }

    public boolean exists(String name) {
        if (this.masterRecordStore != null) {
            return this.getRecordSetId(name) != -1;
        }
        String[] names = RecordStore.listRecordStores();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String rcdstName = names[i];
                if (!name.equals(rcdstName)) continue;
                return true;
            }
        }
        return false;
    }
}

