/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.geometry2d;

import de.enough.polish.geometry2d.Line2D;
import de.enough.polish.geometry2d.Point2D;
import de.enough.polish.geometry2d.Polygon2D;
import de.enough.polish.geometry2d.Util2D;
import java.util.Enumeration;
import java.util.Vector;

public class Intersection2D {
    public static Point2D intersection(Point2D p1, Point2D p2) {
        if (Math.abs(p1.x - p2.x) < 1.0E-6 && Math.abs(p1.y - p2.y) < 1.0E-6) {
            return p1;
        }
        return null;
    }

    public static Point2D intersection(Line2D line, Point2D point) {
        boolean areIntersecting = false;
        if (line.isSegment) {
            areIntersecting = Math.abs(Util2D.getDistance(line.p1, line.p2) - Util2D.getDistance(line.p1, point) - Util2D.getDistance(line.p2, point)) < 1.0E-6;
        } else if (Util2D.isVertical(line)) {
            areIntersecting = Math.abs(point.x - line.p1.x) < 1.0E-6;
        } else {
            boolean bl = areIntersecting = Math.abs(Util2D.getSlope(line) - Util2D.getSlope(line.p1, point)) < 1.0E-6;
        }
        if (areIntersecting) {
            return point;
        }
        return null;
    }

    public static boolean areOverlapping(Line2D line1, Line2D line2) {
        return !(!Util2D.areParallel(line1, line2) || Intersection2D.intersection(line2, line1.p1) == null && Intersection2D.intersection(line2, line1.p2) == null || Intersection2D.intersection(line1, line2.p1) == null && Intersection2D.intersection(line1, line2.p2) == null);
    }

    public static Point2D intersection(Line2D line1, Line2D line2) {
        Point2D result;
        if (Util2D.areParallel(line1, line2)) {
            return null;
        }
        if (Util2D.isVertical(line1)) {
            double y = Util2D.getSlope(line2) * line1.p1.x + Util2D.getYIntercept(line2);
            result = new Point2D(line1.p1.x, y);
        } else if (Util2D.isVertical(line2)) {
            double y = Util2D.getSlope(line1) * line2.p1.x + Util2D.getYIntercept(line1);
            result = new Point2D(line2.p1.x, y);
        } else {
            double yIntercept1 = Util2D.getYIntercept(line1);
            double yIntercept2 = Util2D.getYIntercept(line2);
            double slope1 = Util2D.getSlope(line1);
            double slope2 = Util2D.getSlope(line2);
            double xIntersection = -(yIntercept1 - yIntercept2) / (slope1 - slope2);
            double yIntersection = yIntercept1 + slope1 * xIntersection;
            result = new Point2D(xIntersection, yIntersection);
        }
        if (Intersection2D.intersection(line2, result) == null || Intersection2D.intersection(line1, result) == null) {
            result = null;
        }
        return result;
    }

    public static Point2D intersection(Polygon2D polygon, Point2D point) {
        Point2D intersectionPoint;
        Point2D firstPoint;
        Point2D p1;
        Enumeration points = polygon.points.elements();
        Line2D tempLine = new Line2D();
        if (polygon.points.size() > 2) {
            firstPoint = p1 = (Point2D)points.nextElement();
        } else {
            return null;
        }
        while (points.hasMoreElements()) {
            Point2D p2 = (Point2D)points.nextElement();
            tempLine.p1 = p1;
            tempLine.p2 = p2;
            intersectionPoint = Intersection2D.intersection(tempLine, point);
            if (intersectionPoint != null) {
                return point;
            }
            p1 = p2;
        }
        tempLine.p1 = p1;
        tempLine.p2 = firstPoint;
        intersectionPoint = Intersection2D.intersection(tempLine, point);
        if (intersectionPoint != null) {
            return point;
        }
        return null;
    }

    public static Point2D isInside(Polygon2D polygon, Point2D point) {
        Point2D intersectionPoint;
        Point2D firstPoint;
        Point2D p1;
        Enumeration points = polygon.points.elements();
        Line2D tempLine = new Line2D();
        int intersectionCount = 0;
        Line2D line = new Line2D();
        line.p1 = point;
        line.p2 = new Point2D(9999999.0, point.y);
        if (polygon.points.size() > 2) {
            firstPoint = p1 = (Point2D)points.nextElement();
        } else {
            return null;
        }
        while (points.hasMoreElements()) {
            Point2D p2 = (Point2D)points.nextElement();
            tempLine.p1 = p1;
            tempLine.p2 = p2;
            intersectionPoint = Intersection2D.intersection(tempLine, line);
            if (intersectionPoint != null) {
                if (Intersection2D.intersection(p1, intersectionPoint) != null) {
                    if (p2.y < point.y) {
                        ++intersectionCount;
                    }
                } else {
                    ++intersectionCount;
                }
            }
            p1 = p2;
        }
        tempLine.p1 = p1;
        tempLine.p2 = firstPoint;
        intersectionPoint = Intersection2D.intersection(tempLine, line);
        if (intersectionPoint != null) {
            if (Intersection2D.intersection(p1, intersectionPoint) != null) {
                if (firstPoint.y < point.y) {
                    ++intersectionCount;
                }
            } else {
                ++intersectionCount;
            }
        }
        if (intersectionCount % 2 == 1) {
            return point;
        }
        return null;
    }

    public static Vector intersection(Polygon2D polygon, Line2D line) {
        Point2D intersectionPoint;
        Point2D p1;
        Enumeration points = polygon.points.elements();
        Vector<Point2D> result = null;
        Line2D tempLine = new Line2D();
        Point2D lastIntersectionPoint = new Point2D(5.992310449541053E307, 5.992310449541053E307);
        if (polygon.points.size() <= 2) {
            return result;
        }
        Point2D firstPoint = p1 = (Point2D)points.nextElement();
        result = new Vector<Point2D>();
        while (points.hasMoreElements()) {
            Point2D p2 = (Point2D)points.nextElement();
            tempLine.p1 = p1;
            tempLine.p2 = p2;
            intersectionPoint = Intersection2D.intersection(tempLine, line);
            if (intersectionPoint != null && Intersection2D.intersection(lastIntersectionPoint, intersectionPoint) == null) {
                result.addElement(intersectionPoint);
                lastIntersectionPoint = intersectionPoint;
            }
            p1 = p2;
        }
        tempLine.p1 = p1;
        tempLine.p2 = firstPoint;
        intersectionPoint = Intersection2D.intersection(tempLine, line);
        if (intersectionPoint != null && Intersection2D.intersection(lastIntersectionPoint, intersectionPoint) == null) {
            result.addElement(intersectionPoint);
            lastIntersectionPoint = intersectionPoint;
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    public static Vector intersection(Polygon2D polygon1, Polygon2D polygon2) {
        Point2D temp;
        Enumeration tempPoints;
        Vector intersection;
        Point2D p1;
        Enumeration points = polygon1.points.elements();
        Vector<Point2D> result = null;
        Line2D tempLine = new Line2D();
        if (polygon1.points.size() <= 2) {
            return result;
        }
        Point2D firstPoint = p1 = (Point2D)points.nextElement();
        result = new Vector<Point2D>();
        while (points.hasMoreElements()) {
            Point2D p2 = (Point2D)points.nextElement();
            tempLine.p1 = p1;
            tempLine.p2 = p2;
            intersection = Intersection2D.intersection(polygon2, tempLine);
            if (intersection != null) {
                tempPoints = intersection.elements();
                while (tempPoints.hasMoreElements()) {
                    temp = (Point2D)tempPoints.nextElement();
                    if (Intersection2D.intersection(temp, tempLine.p1) != null) continue;
                    result.addElement(temp);
                }
            }
            p1 = p2;
        }
        tempLine.p1 = p1;
        tempLine.p2 = firstPoint;
        intersection = Intersection2D.intersection(polygon2, tempLine);
        if (intersection != null) {
            tempPoints = intersection.elements();
            while (tempPoints.hasMoreElements()) {
                temp = (Point2D)tempPoints.nextElement();
                if (Intersection2D.intersection(temp, tempLine.p1) != null) continue;
                result.addElement(temp);
            }
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }
}

