/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content.source.impl;

import de.enough.polish.content.storage.StorageIndex;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RmsStorageIndex
extends StorageIndex {
    static final String STORAGE = "RMSStorageIndex";
    static final int RECORD_UNKNOWN = Integer.MIN_VALUE;
    RecordStore store;
    int recordId = Integer.MIN_VALUE;

    public RmsStorageIndex(int maxCacheSize) {
        super(maxCacheSize);
        try {
            this.store = RecordStore.openRecordStore(STORAGE, true);
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                this.recordId = recordEnumeration.nextRecordId();
            }
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 47, (Object)"unable to open record store ", e);
        }
    }

    protected ArrayList load() {
        try {
            if (this.recordId != Integer.MIN_VALUE) {
                byte[] bytes = this.store.getRecord(this.recordId);
                ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
                Object data = Serializer.deserialize(new DataInputStream(byteStream));
                return (ArrayList)data;
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 71, (Object)"unable to read index ", e);
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 75, (Object)"unable to open record store ", e);
        }
        return null;
    }

    protected void store(ArrayList index) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            Serializer.serialize(index, new DataOutputStream(byteStream));
            byte[] bytes = byteStream.toByteArray();
            if (this.recordId != Integer.MIN_VALUE) {
                this.store.setRecord(this.recordId, bytes, 0, bytes.length);
            } else {
                this.recordId = this.store.addRecord(bytes, 0, bytes.length);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 109, (Object)"unable to serialize index ", e);
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 112, (Object)"unable to store index ", e);
        }
    }

    public void shutdown() {
        super.shutdown();
        try {
            this.store.closeRecordStore();
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsStorageIndex", 123, (Object)"unable to close index ", e.toString());
        }
    }
}

