/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content;

import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.ContentListener;
import de.enough.polish.content.source.ContentSource;
import de.enough.polish.content.storage.StorageIndex;
import de.enough.polish.content.storage.StorageReference;
import de.enough.polish.util.IntHashMap;
import java.io.IOException;

public class ContentLoader
extends ContentSource
implements Runnable {
    public static final String ID = "ContentLoader";
    public static final int LOADER_CACHE_SIZE = 100000;
    final IntHashMap cache = new IntHashMap();
    final IntHashMap listeners = new IntHashMap();
    Object lock = new Object();
    ContentQueue queue;
    Thread thread;
    boolean shutdown = false;

    public ContentLoader() {
        super(ID, new StorageIndex(100000L));
    }

    public ContentLoader(ContentSource source) {
        this(new StorageIndex(100000L), source);
    }

    public ContentLoader(StorageIndex index, ContentSource source) {
        super(ID, index);
        this.attachSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestContent(ContentDescriptor descriptor, ContentListener listener) {
        if (this.thread == null) {
            this.queue = new ContentQueue();
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (this.listeners.get(descriptor.getHash()) == null) {
            this.listeners.put(descriptor.getHash(), listener);
            this.queue.push(descriptor);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelContent(ContentDescriptor descriptor) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.queue.cancel(descriptor);
                this.listeners.remove(descriptor.getHash());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        do {
            Object var5_6;
            ContentDescriptor descriptor;
            ContentListener listener;
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (this.queue.isEmpty()) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.shutdown || this.queue.isEmpty() || (listener = (ContentListener)this.listeners.get((descriptor = (ContentDescriptor)this.queue.pop()).getHash())) == null) continue;
            }
            try {
                try {
                    Object data = this.loadContent(descriptor);
                    listener.onContentLoaded(descriptor, data);
                }
                catch (Exception e) {
                    listener.onContentError(descriptor, e);
                    var5_6 = null;
                    this.listeners.remove(descriptor.getHash());
                    continue;
                }
                var5_6 = null;
                this.listeners.remove(descriptor.getHash());
            }
            catch (Throwable throwable) {
                var5_6 = null;
                this.listeners.remove(descriptor.getHash());
                throw throwable;
            }
        } while (!this.shutdown);
    }

    protected void destroy(StorageReference reference) {
        this.cache.remove(reference.getHash());
    }

    protected Object load(StorageReference reference) {
        return this.cache.get(reference.getHash());
    }

    protected Object load(ContentDescriptor descriptor) {
        return null;
    }

    protected Object store(ContentDescriptor descriptor, Object data) {
        this.cache.put(descriptor.getHash(), data);
        return null;
    }

    protected Object[] storeContentAndGetDataSize(ContentDescriptor descriptor, Object data) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        super.shutdown();
    }

    private class QueueElement {
        Object content;
        QueueElement prev;
        QueueElement next;

        private QueueElement() {
        }
    }

    private class ContentQueue {
        private QueueElement root;

        public ContentQueue() {
            this.root = new QueueElement();
            this.root.content = null;
            this.root.prev = this.root;
            this.root.next = this.root;
        }

        public synchronized boolean isEmpty() {
            return this.root.content == null;
        }

        public synchronized void push(Object o) {
            if (this.root.content == null) {
                this.root.content = o;
            } else {
                QueueElement e = new QueueElement();
                e.content = o;
                this.root.prev.next = e;
                e.next = this.root;
                e.prev = this.root.prev;
                this.root.prev = e;
            }
        }

        public synchronized Object pop() {
            if (this.root.content == null) {
                return null;
            }
            Object o = this.root.content;
            this.remove(this.root);
            this.root = this.root.next;
            return o;
        }

        public synchronized boolean contains(Object obj) {
            QueueElement e = this.root.next;
            while (e != this.root) {
                if (e.content.equals(obj)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        public synchronized void cancel(Object o) throws InterruptedException {
            if (this.root.content != null) {
                if (this.root.content.equals(o)) {
                    this.pop();
                } else {
                    QueueElement e = this.root.next;
                    while (e != this.root) {
                        if (e.content.equals(o)) {
                            this.remove(e);
                            break;
                        }
                        e = e.next;
                    }
                }
            }
        }

        protected Object latest() {
            return this.root.content == null ? null : this.root.prev.content;
        }

        private void remove(QueueElement e) {
            e.content = null;
            e.prev.next = e.next;
            e.next.prev = e.prev;
        }
    }
}

