/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content;

import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.ToStringHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ContentDescriptor
implements Externalizable {
    public static String TRANSFORM_NONE = "none";
    public static int VERSION_DEFAULT = Integer.MIN_VALUE;
    public static int CACHING_READ = 1;
    public static int CACHING_READ_WRITE = 2;
    protected String url;
    protected int hash;
    protected String transformId = TRANSFORM_NONE;
    protected int version = VERSION_DEFAULT;
    protected int cachingPolicy = CACHING_READ_WRITE;
    protected Hashtable attributes = new Hashtable();
    protected int priority = 0;

    public ContentDescriptor() {
    }

    public ContentDescriptor(String url) {
        this.url = url;
        this.hash = url == null ? 0 : url.hashCode();
    }

    protected ContentDescriptor(ContentDescriptor descriptor) {
        this.url = descriptor.getUrl();
        this.hash = descriptor.getHash();
        this.version = descriptor.getVersion();
        this.transformId = descriptor.getTransformID();
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getUrl() {
        return this.url;
    }

    public int getHash() {
        return this.hash;
    }

    public String getTransformID() {
        return this.transformId;
    }

    public void setTransformID(String transformId) {
        this.transformId = transformId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCachingPolicy() {
        return this.cachingPolicy;
    }

    public void setCachingPolicy(int cachingPolicy) {
        this.cachingPolicy = cachingPolicy;
    }

    public boolean equals(Object obj) {
        ContentDescriptor reference = (ContentDescriptor)obj;
        return reference.getHash() == this.getHash();
    }

    public int hashCode() {
        return this.getHash();
    }

    public Object getAttribute(Object attributeKey) {
        return this.attributes.get(attributeKey);
    }

    public void setAttribute(Object attributeKey, Object attributeValue) {
        this.attributes.put(attributeKey, attributeValue);
    }

    public String toString() {
        return ToStringHelper.createInstance("ContentDescriptor").set("url", this.url).set("hash", this.hash).set("version", this.version).set("cachingPolicy", this.cachingPolicy).toString();
    }

    public void read(DataInputStream in) throws IOException {
        this.url = in.readUTF();
        this.hash = in.readInt();
        this.transformId = in.readUTF();
        this.version = in.readInt();
        this.cachingPolicy = in.readInt();
        this.priority = in.readInt();
        this.attributes = (Hashtable)Serializer.deserialize(in);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.url);
        out.writeInt(this.hash);
        out.writeUTF(this.transformId);
        out.writeInt(this.version);
        out.writeInt(this.cachingPolicy);
        out.writeInt(this.priority);
        Serializer.serialize(this.attributes, out);
    }
}

