/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.calendar.CalendarAlarm;
import de.enough.polish.calendar.CalendarCategory;
import de.enough.polish.calendar.CalendarEntryList;
import de.enough.polish.calendar.CalendarTextResolver;
import de.enough.polish.calendar.EventRepeatRule;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class CalendarEntry
implements Externalizable {
    private static final int VERSION = 103;
    public static final int REOCCURENCE_NONE = 0;
    public static final int REOCCURENCE_DAILY = 1;
    public static final int REOCCURENCE_WEEKLY = 2;
    public static final int REOCCURENCE_MONTHLY = 3;
    public static final int REOCCURENCE_YEARLY = 4;
    public static final String CLASS_PUBLIC = "PUBLIC";
    public static final String CLASS_PRIVATE = "PRIVATE";
    public static final String CLASS_CONFIDENTIAL = "CONFIDENTIAL";
    private TimePoint startDate;
    private TimePoint endDate;
    private boolean isAllday;
    private int durationInMinutes;
    private int simpleReoccurence;
    private int anniversaryYear;
    private int sequence;
    private String summary;
    private int alarm;
    private String notes;
    private Hashtable otherFields;
    private String location;
    private String description;
    private String organizer;
    private String status;
    private int type;
    private String id;
    private String userId;
    private String classType;
    private CalendarCategory category;
    private CalendarAlarm calendarAlarm;
    private EventRepeatRule eventRepeatRule;
    private TimeZone timeZone;
    private CalendarEntry parent;
    private CalendarEntry[] children;
    private CalendarTextResolver textResolver;

    public CalendarEntry() {
    }

    public CalendarEntry(String summary, CalendarCategory category, int year, int month, int day) {
        this(summary, category, year, month, day, null, 0);
    }

    public CalendarEntry(String summary, CalendarCategory category, int year, int month, int day, int reoccurence) {
        this(summary, category, year, month, day, null, reoccurence);
    }

    public CalendarEntry(String summary, CalendarCategory category, int year, int month, int day, String description) {
        this(summary, category, year, month, day, description, 0);
    }

    public CalendarEntry(String summary, CalendarCategory category, int year, int month, int day, String description, int reoccurence) {
        this(summary, category, new TimePoint(year, month, day), description, reoccurence);
    }

    public CalendarEntry(String summary, CalendarCategory category, TimePoint start) {
        this(summary, category, start, null, 0);
    }

    public CalendarEntry(String summary, CalendarCategory category, TimePoint start, int reoccurence) {
        this(summary, category, start, null, reoccurence);
    }

    public CalendarEntry(String summary, CalendarCategory category, TimePoint start, String description) {
        this(summary, category, start, null, 0);
    }

    public CalendarEntry(String summary, CalendarCategory category, TimePoint start, String description, int reoccurence) {
        this.summary = summary;
        this.category = category;
        this.startDate = start;
        this.description = description;
        this.simpleReoccurence = reoccurence;
    }

    public CalendarEntry(TimePoint startDate, String description) {
        this.startDate = startDate;
        this.description = description;
    }

    CalendarEntry(TimePoint startDate, TimePoint endDate, boolean isAllday, CalendarCategory category, String description, TimeZone timeZone, int durationInMinutes) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.isAllday = isAllday;
        this.category = category;
        this.description = description;
        this.timeZone = timeZone;
        this.durationInMinutes = durationInMinutes;
    }

    CalendarEntry(TimePoint startDate, TimePoint endDate, boolean isAllday, CalendarCategory category, String description, TimeZone timeZone, int durationInMinutes, String location, int reoccurence, String organizer) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.isAllday = isAllday;
        this.category = category;
        this.description = description;
        this.timeZone = timeZone;
        this.durationInMinutes = durationInMinutes;
        this.location = location;
        this.simpleReoccurence = reoccurence;
        this.organizer = organizer;
    }

    public CalendarEntry(CalendarEntry original) {
        this.alarm = original.alarm;
        this.calendarAlarm = original.calendarAlarm;
        this.category = original.category;
        this.classType = original.classType;
        this.description = original.description;
        this.durationInMinutes = original.durationInMinutes;
        this.endDate = original.endDate;
        this.eventRepeatRule = original.eventRepeatRule;
        this.id = original.id;
        this.isAllday = original.isAllday;
        this.location = original.location;
        this.notes = original.notes;
        this.organizer = original.organizer;
        this.otherFields = original.otherFields;
        this.simpleReoccurence = original.simpleReoccurence;
        this.sequence = original.sequence;
        this.startDate = original.startDate;
        this.status = original.status;
        this.summary = original.summary;
        this.timeZone = original.timeZone;
        this.type = original.type;
        this.userId = original.userId;
        this.textResolver = original.textResolver;
    }

    public CalendarAlarm getCalendarAlarm() {
        return this.calendarAlarm;
    }

    public CalendarCategory getCategory() {
        return this.category;
    }

    public String getDescription() {
        if (this.textResolver != null) {
            return this.textResolver.resolveDescription(this.description, this);
        }
        return this.description;
    }

    public TimePoint getStartDate() {
        return this.startDate;
    }

    public TimePoint getEndDate() {
        return this.endDate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getStatus() {
        return this.status;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isAllday() {
        return this.isAllday;
    }

    public String getId() {
        return this.id;
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public String getSummary() {
        return this.getSummary(null);
    }

    public String getSummary(TimePoint calendarTimePoint) {
        String returnSummary = calendarTimePoint != null && this.textResolver != null ? this.textResolver.resolveSummary(this.summary, this, calendarTimePoint) : this.summary;
        return returnSummary;
    }

    public void setCategory(CalendarCategory category) {
        this.category = category;
    }

    public void setCalendarAlarm(CalendarAlarm calendarAlarm) {
        this.calendarAlarm = calendarAlarm;
    }

    public void setStartDate(TimePoint startDate, int durationInMinutes) {
        this.startDate = startDate;
        this.durationInMinutes = durationInMinutes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(TimePoint startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(TimePoint endDate) {
        this.endDate = endDate;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setDurationInMinutes(int durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setReoccurence(int reoccurence) {
        this.simpleReoccurence = reoccurence;
    }

    public void setRepeat(EventRepeatRule eventRepeatRule) {
        this.eventRepeatRule = eventRepeatRule;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAllday(boolean isAllday) {
        this.isAllday = isAllday;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public EventRepeatRule getRepeat() {
        EventRepeatRule rule = this.eventRepeatRule;
        if (rule == null && this.simpleReoccurence != 0) {
            switch (this.simpleReoccurence) {
                case 4: {
                    rule = EventRepeatRule.RULE_YEARLY;
                    break;
                }
                case 3: {
                    rule = EventRepeatRule.RULE_MONTHLY;
                    break;
                }
                case 2: {
                    rule = new EventRepeatRule(EventRepeatRule.INTERVAL_WEEKLY);
                    break;
                }
                case 1: {
                    rule = new EventRepeatRule(new TimePoint(0, 0, 1));
                }
            }
        }
        return rule;
    }

    public int getAlarm() {
        return this.alarm;
    }

    public void setAlarm(int alarm) {
        this.alarm = alarm;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Object getField(String name) {
        if (this.otherFields == null) {
            return null;
        }
        return this.otherFields.get(name);
    }

    public void setField(String name, Object value) {
        if (this.otherFields == null) {
            this.otherFields = new Hashtable();
        }
        this.otherFields.put(name, value);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(103);
        boolean notNull = this.startDate != null;
        out.writeBoolean(notNull);
        if (notNull) {
            this.startDate.write(out);
        }
        notNull = this.endDate != null;
        out.writeBoolean(notNull);
        if (notNull) {
            this.endDate.write(out);
        }
        out.writeBoolean(this.isAllday);
        out.writeInt(this.durationInMinutes);
        out.writeInt(this.simpleReoccurence);
        out.writeInt(this.sequence);
        boolean isNotNull = this.summary != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.summary);
        }
        out.writeInt(this.alarm);
        isNotNull = this.notes != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.notes);
        }
        isNotNull = this.otherFields != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            Serializer.serialize(this.otherFields, out);
        }
        isNotNull = this.location != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.location);
        }
        isNotNull = this.description != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.description);
        }
        isNotNull = this.organizer != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.organizer);
        }
        isNotNull = this.status != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.status);
        }
        out.writeInt(this.type);
        isNotNull = this.id != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.id);
        }
        isNotNull = this.userId != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.userId);
        }
        isNotNull = this.classType != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.classType);
        }
        isNotNull = this.category != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            this.category.write(out);
        }
        isNotNull = this.calendarAlarm != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            this.calendarAlarm.write(out);
        }
        isNotNull = this.eventRepeatRule != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            this.eventRepeatRule.write(out);
        }
        isNotNull = this.timeZone != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.timeZone.getID());
        }
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 103) {
            throw new IOException("unknown version " + version);
        }
        if (version == 100) {
            Calendar cal;
            long time = in.readLong();
            if (time != -1L) {
                cal = Calendar.getInstance();
                cal.setTime(new Date(time));
                this.startDate = new TimePoint(cal);
            }
            if ((time = in.readLong()) != -1L) {
                cal = Calendar.getInstance();
                cal.setTime(new Date(time));
                this.endDate = new TimePoint(cal);
            }
        } else {
            boolean notNull = in.readBoolean();
            if (notNull) {
                this.startDate = new TimePoint(in);
            }
            if (notNull = in.readBoolean()) {
                this.endDate = new TimePoint(in);
            }
        }
        if (version == 101) {
            in.readLong();
            in.readLong();
            in.readLong();
        }
        this.isAllday = in.readBoolean();
        this.durationInMinutes = in.readInt();
        this.simpleReoccurence = in.readInt();
        this.sequence = in.readInt();
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.summary = in.readUTF();
        }
        this.alarm = in.readInt();
        isNotNull = in.readBoolean();
        if (isNotNull) {
            this.notes = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.otherFields = (Hashtable)Serializer.deserialize(in);
        }
        if (isNotNull = in.readBoolean()) {
            this.location = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.description = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.organizer = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.status = in.readUTF();
        }
        if (version == 102) {
            isNotNull = in.readBoolean();
            if (isNotNull) {
                in.readUTF();
            }
        } else {
            this.type = in.readInt();
        }
        if (isNotNull = in.readBoolean()) {
            this.id = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.userId = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.classType = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.category = new CalendarCategory();
            this.category.read(in);
        }
        if (isNotNull = in.readBoolean()) {
            this.calendarAlarm = new CalendarAlarm();
            this.calendarAlarm.read(in);
        }
        if (isNotNull = in.readBoolean()) {
            this.eventRepeatRule = new EventRepeatRule();
            this.eventRepeatRule.read(in);
        }
        if (isNotNull = in.readBoolean()) {
            String timeZoneId = in.readUTF();
            this.timeZone = TimeZone.getTimeZone(timeZoneId);
        }
    }

    public CalendarEntry clone(TimePoint start) {
        CalendarEntry copy = new CalendarEntry(this);
        copy.setStartDate(start, this.durationInMinutes);
        copy.simpleReoccurence = 0;
        copy.eventRepeatRule = null;
        copy.parent = this;
        return copy;
    }

    public boolean matches(TimePeriod period) {
        return this.startDate != null && period.matches(this.startDate) || this.endDate != null && period.matches(this.endDate);
    }

    public CalendarEntry getParent() {
        return this.parent;
    }

    public CalendarEntry[] getChildren() {
        return this.children;
    }

    public void setChildren(CalendarEntryList entryList) {
        this.children = entryList.getEntries();
    }

    public int getYearsSinceStart(TimePoint timePoint) {
        return timePoint.getYear() - this.startDate.getYear();
    }

    public void setStartDate(Date date) {
        this.setStartDate(new TimePoint(date));
    }

    public void setEndDate(Date date) {
        this.setEndDate(new TimePoint(date));
    }

    public void setTextResolver(CalendarTextResolver resolver) {
        this.textResolver = resolver;
    }

    public CalendarTextResolver getTextResolver() {
        return this.textResolver;
    }

    public long getGuid() {
        long guid = 0L;
        if (this.id != null) {
            guid = this.id.hashCode();
        } else if (this.summary != null) {
            guid = this.summary.hashCode();
        }
        if (this.startDate != null) {
            guid |= (long)(this.startDate.hashCode() >> 32);
        }
        return guid;
    }
}

