/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.ArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CalendarCategory
implements Externalizable {
    private static final int VERSION = 102;
    private String name;
    private String id;
    private transient CalendarCategory parentCategory;
    private ArrayList childCategories;
    private String image;
    private boolean isEnabled;
    private String styleName;

    public CalendarCategory() {
        this(null, null, null, null, null);
    }

    public CalendarCategory(String name) {
        this(name, null, null, null, null);
    }

    public CalendarCategory(String name, String id) {
        this(name, id, null, null, null);
    }

    public CalendarCategory(String name, String id, CalendarCategory parentCategory) {
        this(name, id, parentCategory, null, null);
    }

    public CalendarCategory(String name, String id, CalendarCategory parentCategory, ArrayList childCategories) {
        this(name, id, parentCategory, childCategories, null);
    }

    public CalendarCategory(String name, String id, CalendarCategory parentCategory, ArrayList childCategories, String image) {
        this.name = name;
        this.id = id;
        this.parentCategory = parentCategory;
        this.childCategories = childCategories;
        this.image = image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CalendarCategory getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(CalendarCategory parentCategory) {
        this.parentCategory = parentCategory;
    }

    public CalendarCategory[] getChildCategories() {
        if (this.childCategories == null) {
            return new CalendarCategory[0];
        }
        return (CalendarCategory[])this.childCategories.toArray(new CalendarCategory[this.childCategories.size()]);
    }

    public CalendarCategory[] getEnabledChildCategories() {
        CalendarCategory child;
        if (this.childCategories == null) {
            return new CalendarCategory[0];
        }
        ArrayList list = new ArrayList(this.childCategories.size());
        Object[] children = this.childCategories.getInternalArray();
        for (int i = 0; i < children.length && (child = (CalendarCategory)children[i]) != null; ++i) {
            list.add(child);
        }
        return (CalendarCategory[])list.toArray(new CalendarCategory[list.size()]);
    }

    public void addChildCategory(CalendarCategory child) {
        if (this.childCategories == null) {
            this.childCategories = new ArrayList();
        }
        child.setParentCategory(this);
        this.childCategories.add(child);
    }

    public CalendarCategory getChildCategory(int index) {
        if (this.childCategories == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (CalendarCategory)this.childCategories.get(index);
    }

    public int getSizeOfChildCategories() {
        if (this.childCategories == null) {
            return 0;
        }
        return this.childCategories.size();
    }

    public boolean hasChildCategories() {
        return this.childCategories != null && this.childCategories.size() != 0;
    }

    public Object[] getChildCategoriesAsInternalArray() {
        if (this.childCategories != null) {
            return this.childCategories.getInternalArray();
        }
        return new Object[0];
    }

    public ArrayList getChildCategoriesAsList() {
        return this.childCategories;
    }

    public void setChildCategories(ArrayList childCategories) {
        this.childCategories = childCategories;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setParentForChildren() {
        ArrayList children = this.childCategories;
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                CalendarCategory child = (CalendarCategory)children.get(i);
                child.setParentCategory(this);
            }
        }
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public String getStyleName() {
        String sName = this.styleName;
        if (sName == null && this.parentCategory != null) {
            sName = this.parentCategory.getStyleName();
        }
        return sName;
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 102) {
            throw new IOException("unknown version " + version);
        }
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.name = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.id = in.readUTF();
        }
        if (isNotNull = in.readBoolean()) {
            this.image = in.readUTF();
        }
        if (version > 101 && (isNotNull = in.readBoolean())) {
            this.styleName = in.readUTF();
        }
        this.isEnabled = version > 100 ? in.readBoolean() : true;
        isNotNull = in.readBoolean();
        if (isNotNull) {
            int size = in.readInt();
            this.childCategories = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                CalendarCategory child = new CalendarCategory();
                child.read(in);
                child.setParentCategory(this);
                this.childCategories.add(child);
            }
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(102);
        boolean isNotNull = this.name != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.name);
        }
        isNotNull = this.id != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.id);
        }
        isNotNull = this.image != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.image);
        }
        isNotNull = this.styleName != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            out.writeUTF(this.styleName);
        }
        out.writeBoolean(this.isEnabled);
        isNotNull = this.childCategories != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            CalendarCategory child;
            out.writeInt(this.childCategories.size());
            Object[] objects = this.childCategories.getInternalArray();
            for (int i = 0; i < objects.length && (child = (CalendarCategory)objects[i]) != null; ++i) {
                child.write(out);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            CalendarCategory p = this.parentCategory;
            while (p != null) {
                if (enabled) {
                    if (!p.isEnabled) {
                        p.isEnabled = true;
                    }
                } else {
                    CalendarCategory child;
                    boolean childIsEnabled = false;
                    Object[] children = p.getChildCategoriesAsInternalArray();
                    for (int i = 0; i < children.length && (child = (CalendarCategory)children[i]) != null; ++i) {
                        if (!child.isEnabled) continue;
                        childIsEnabled = true;
                        break;
                    }
                    if (childIsEnabled) break;
                    p.isEnabled = false;
                }
                p = p.parentCategory;
            }
            return true;
        }
        return false;
    }

    public long getGuid() {
        long guid = 0L;
        guid = this.name != null ? (long)this.name.hashCode() : (this.id != null ? (long)this.id.hashCode() : (long)this.hashCode());
        if (this.parentCategory != null) {
            guid ^= this.parentCategory.getGuid();
        }
        return guid;
    }

    public long getGuidOld() {
        long guid = 0L;
        if (this.id != null) {
            guid = this.id.hashCode();
        } else if (this.name != null) {
            guid = this.name.hashCode();
        }
        if (this.parentCategory != null) {
            guid ^= this.parentCategory.getGuid();
        }
        return guid;
    }

    public boolean equals(Object o) {
        if (o instanceof CalendarCategory) {
            CalendarCategory cc = (CalendarCategory)o;
            return cc.getGuid() == this.getGuid();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getGuid();
    }

    public CalendarCategory getChildCategory(long guid) {
        CalendarCategory child;
        if (this.childCategories == null) {
            return null;
        }
        Object[] children = this.childCategories.getInternalArray();
        for (int i = 0; i < children.length && (child = (CalendarCategory)children[i]) != null; ++i) {
            if (child.getGuid() != guid) continue;
            return child;
        }
        return null;
    }
}

