/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.rss;

import de.enough.polish.browser.html.HtmlBrowser;
import de.enough.polish.browser.html.HtmlTagHandler;
import de.enough.polish.browser.rss.DefaultRssItemCommandListener;
import de.enough.polish.browser.rss.RssTagHandler;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Style;

public class RssBrowser
extends HtmlBrowser
implements CommandListener {
    private ItemCommandListener rssItemCommandListener;
    private RssTagHandler rssTagHandler;
    private Command linkCommand = HtmlTagHandler.CMD_LINK;

    public RssBrowser() {
        this((Style)null);
    }

    public RssBrowser(Style style) {
        this(new DefaultRssItemCommandListener(), style);
    }

    public RssBrowser(ItemCommandListener listener) {
        this(listener, null);
    }

    public RssBrowser(ItemCommandListener listener, Style style) {
        super(style);
        this.rssItemCommandListener = listener;
        this.rssTagHandler = new RssTagHandler(this.getLinkCommand(), this.getRssItemCommandListener());
        this.rssTagHandler.register(this);
        if (listener instanceof DefaultRssItemCommandListener) {
            DefaultRssItemCommandListener rssListener = (DefaultRssItemCommandListener)listener;
            rssListener.setRssBrowser(this);
            rssListener.setCommandListener(this);
        }
    }

    public ItemCommandListener getRssItemCommandListener() {
        return this.rssItemCommandListener;
    }

    public Command getLinkCommand() {
        return this.linkCommand;
    }

    public void setLinkCommand(Command link) {
        this.linkCommand = link;
        this.rssTagHandler.setLinkCommand(link);
    }

    public void setRssTagHandler(RssTagHandler handler) {
        this.rssTagHandler = handler;
        handler.register(this);
    }

    public boolean handleCommand(Command command) {
        if (this.getRssItemCommandListener() != null && command == RssTagHandler.CMD_GO_TO_ARTICLE) {
            Item rssItem = this.getFocusedItem();
            String rssUrl = (String)rssItem.getAttribute("href");
            if (rssUrl != null) {
                this.rssTagHandler.onViewUrl(rssUrl, rssItem);
            }
            this.getRssItemCommandListener().commandAction(command, rssItem);
            return true;
        }
        return super.handleCommand(command);
    }

    public void commandAction(Command command, Displayable displayable) {
        this.handleCommand(command);
    }

    public boolean isIncludeDescriptions() {
        if (this.rssTagHandler != null) {
            return this.rssTagHandler.isIncludeDescriptions();
        }
        return false;
    }

    public void setIncludeDescriptions(boolean includeDescriptions) {
        if (this.rssTagHandler != null) {
            this.rssTagHandler.setIncludeDescriptions(includeDescriptions);
        }
    }

    public RssTagHandler getRssTagHandler() {
        return this.rssTagHandler;
    }
}

