/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.Browser;
import de.enough.polish.browser.RedirectThread;
import de.enough.polish.browser.TagHandler;
import de.enough.polish.browser.css.CssInterpreter;
import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlBrowser;
import de.enough.polish.browser.html.HtmlForm;
import de.enough.polish.browser.html.HtmlSelect;
import de.enough.polish.io.ResourceLoader;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ScaledImageItem;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.ui.TextField;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.BooleanStack;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.Locale;
import de.enough.polish.util.TextUtil;
import de.enough.polish.xml.SimplePullParser;

public class HtmlTagHandler
extends TagHandler
implements ItemCommandListener {
    private static final Style STYLE_LINE_BREAK = new Style();
    public static final String TAG_TITLE = "title";
    public static final String TAG_META = "meta";
    public static final String TAG_BODY = "body";
    public static final String TAG_STYLE = "style";
    public static final String TAG_BR = "br";
    public static final String TAG_P = "p";
    public static final String TAG_IMG = "img";
    public static final String TAG_DIV = "div";
    public static final String TAG_SPAN = "span";
    public static final String TAG_A = "a";
    public static final String TAG_B = "b";
    public static final String TAG_STRONG = "strong";
    public static final String TAG_I = "i";
    public static final String TAG_EM = "em";
    public static final String TAG_FORM = "form";
    public static final String TAG_INPUT = "input";
    public static final String TAG_BUTTON = "button";
    public static final String TAG_TEXT_AREA = "textarea";
    public static final String TAG_SELECT = "select";
    public static final String TAG_OPTION = "option";
    public static final String TAG_SCRIPT = "script";
    public static final String TAG_TABLE = "table";
    public static final String TAG_TR = "tr";
    public static final String TAG_TH = "th";
    public static final String TAG_TD = "td";
    public static final String TAG_CODE = "code";
    public static final String INPUT_TYPE = "type";
    public static final String INPUT_NAME = "name";
    public static final String INPUT_VALUE = "value";
    public static final String INPUTTYPE_TEXT = "text";
    public static final String INPUTTYPE_PASSWORD = "password";
    public static final String INPUTTYPE_HIDDEN = "hidden";
    public static final String INPUTTYPE_SUBMIT = "submit";
    public static final String INPUTTYPE_CHECKBOX = "checkbox";
    public static final String INPUTTYPE_RADIO = "radio";
    public static final String INPUTTYPE_NUMERIC = "numeric";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_FORM = "polish_form";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_MULTIPLE = "multiple";
    public static Command CMD_LINK = new Command(Locale.get(162), 4, 2);
    public static Command CMD_SUBMIT = new Command(Locale.get(168), 8, 2);
    public static Command CMD_BACK = new Command(Locale.get(157), 2, 10);
    private HtmlForm currentForm;
    private HtmlSelect currentSelect;
    private TableItem currentTable;
    protected HtmlBrowser browser;
    public boolean textBold;
    public boolean textItalic;
    public Style textStyle;
    private FormListener formListener;
    private ChoiceGroup currentCheckBoxChoiceGroup;
    private ChoiceGroup currentRadioChoiceGroup;
    private BooleanStack isDivOrSpanOpened;
    private String anchorHref;

    public HtmlTagHandler() {
        if (Locale.get(162) != CMD_LINK.getLabel()) {
            CMD_LINK = new Command(Locale.get(162), 4, 2);
            CMD_SUBMIT = new Command(Locale.get(168), 8, 2);
            CMD_BACK = new Command(Locale.get(157), 2, 10);
        }
        HtmlTagHandler.STYLE_LINE_BREAK.layout = 512;
    }

    public void register(Browser parent) {
        this.browser = (HtmlBrowser)parent;
        this.textBold = false;
        this.textItalic = false;
        parent.addTagHandler(TAG_BODY, this);
        parent.addTagHandler(TAG_TITLE, this);
        parent.addTagHandler(TAG_META, this);
        parent.addTagHandler(TAG_STYLE, this);
        parent.addTagHandler(TAG_BR, this);
        parent.addTagHandler(TAG_P, this);
        parent.addTagHandler(TAG_IMG, this);
        parent.addTagHandler(TAG_DIV, this);
        parent.addTagHandler(TAG_SPAN, this);
        parent.addTagHandler(TAG_A, this);
        parent.addTagHandler(TAG_B, this);
        parent.addTagHandler(TAG_STRONG, this);
        parent.addTagHandler(TAG_I, this);
        parent.addTagHandler(TAG_EM, this);
        parent.addTagHandler(TAG_FORM, this);
        parent.addTagHandler(TAG_INPUT, this);
        parent.addTagHandler(TAG_BUTTON, this);
        parent.addTagHandler(TAG_SELECT, this);
        parent.addTagHandler(TAG_OPTION, this);
        parent.addTagHandler(TAG_SCRIPT, this);
        parent.addTagHandler(TAG_TEXT_AREA, this);
        parent.addTagHandler(TAG_TABLE, this);
        parent.addTagHandler(TAG_TR, this);
        parent.addTagHandler(TAG_TH, this);
        parent.addTagHandler(TAG_TD, this);
        parent.addTagHandler(TAG_CODE, this);
    }

    public boolean handleTag(Container parentItem, SimplePullParser parser, String tagName, boolean opening, HashMap attributeMap, Style style) {
        String name;
        Container container;
        if (TAG_DIV.equals(tagName = tagName.toLowerCase()) || TAG_SPAN.equals(tagName)) {
            if (opening) {
                Style itemStyle;
                String itemStyleName = (String)attributeMap.get("textclass");
                Style style2 = itemStyle = itemStyleName == null ? null : StyleSheet.getStyle(itemStyleName);
                if (itemStyle != null) {
                    this.textStyle = itemStyle;
                }
                if (this.isDivOrSpanOpened == null) {
                    this.isDivOrSpanOpened = new BooleanStack();
                }
                if (style != null) {
                    this.browser.openContainer(style);
                }
                this.isDivOrSpanOpened.push(style != null);
            } else {
                this.textStyle = null;
                if (this.isDivOrSpanOpened.pop() && UiAccess.cast(container = this.browser.closeContainer()) instanceof TableItem) {
                    this.currentTable = (TableItem)UiAccess.cast(container);
                }
            }
        } else {
            if (TAG_SELECT.equals(tagName)) {
                if (opening) {
                    int size;
                    if (this.currentSelect != null) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 305, "Error in HTML-Code: You cannot open a <select>-tag inside another <select>-tag.");
                        ChoiceGroup choiceGroup = this.currentSelect.getChoiceGroup();
                        this.add(choiceGroup);
                        if (this.currentForm == null) {
                            Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 311, "Error in HTML-Code: no <form> for <select> element found!");
                        } else {
                            this.currentForm.addItem(choiceGroup);
                        }
                        this.currentSelect = null;
                    }
                    String name2 = parser.getAttributeValue("name");
                    String sizeStr = parser.getAttributeValue(ATTR_SIZE);
                    try {
                        size = Integer.parseInt(sizeStr);
                    }
                    catch (NumberFormatException e) {
                        size = -1;
                    }
                    boolean isMultiple = parser.getAttributeValue(ATTR_MULTIPLE) != null;
                    this.currentSelect = new HtmlSelect(name2, size, isMultiple, style);
                } else if (this.currentSelect != null) {
                    ChoiceGroup choiceGroup = this.currentSelect.getChoiceGroup();
                    this.add(choiceGroup);
                    if (this.currentForm == null) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 337, "Error in HTML-Code: no <form> for <select> element found!");
                    } else {
                        this.currentForm.addItem(choiceGroup);
                    }
                    this.currentSelect = null;
                } else {
                    Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 346, "Error in HTML-Code. You cannot close a <select>-tag without opening one.");
                }
                return true;
            }
            if (TAG_OPTION.equals(tagName)) {
                if (this.currentSelect != null && opening) {
                    String value = parser.getAttributeValue("value");
                    String selected = parser.getAttributeValue("selected");
                    parser.next();
                    String name3 = this.handleText(parser.getText());
                    if (value == null) {
                        value = name3;
                    }
                    this.currentSelect.addOption(name3, value, selected != null, style);
                }
                return true;
            }
            if (TAG_A.equals(tagName)) {
                if (opening) {
                    this.anchorHref = (String)attributeMap.get(ATTR_HREF);
                    if (this.anchorHref == null) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 373, (Object)"Unable to handle anchor tag <a> without href attribute: ", attributeMap);
                    }
                    this.browser.openContainer(style);
                    if (style == null) {
                        container = this.browser.getCurrentContainer();
                        UiAccess.setStyle(container, StyleSheet.browserlinkStyle);
                    }
                } else {
                    Item linkItem;
                    container = this.browser.removeCurrentContainer();
                    Style contStyle = container.getStyle();
                    if (container.size() == 0) {
                        linkItem = new StringItem(null, null);
                    } else if (container.size() == 1) {
                        linkItem = container.get(0);
                    } else {
                        boolean allItemsAreStringItems = true;
                        StringBuffer text = new StringBuffer();
                        for (int i = 0; i < container.size(); ++i) {
                            Item item = container.get(i);
                            if (!(item instanceof StringItem)) {
                                allItemsAreStringItems = false;
                                break;
                            }
                            if (text.length() > 0) {
                                text.append(' ');
                            }
                            text.append(((StringItem)item).getText());
                        }
                        linkItem = allItemsAreStringItems ? new StringItem(null, text.toString()) : container;
                    }
                    if (this.anchorHref != null) {
                        if (contStyle != null) {
                            linkItem.setStyle(contStyle);
                        } else if (linkItem.getStyle() == null) {
                            UiAccess.setStyle(linkItem, StyleSheet.browserlinkStyle);
                        }
                        linkItem.setDefaultCommand(CMD_LINK);
                        linkItem.setItemCommandListener(this);
                        linkItem.setAttribute(ATTR_HREF, this.anchorHref);
                        this.addCommands(TAG_A, linkItem);
                        this.add(linkItem);
                    }
                }
            }
        }
        if (opening) {
            TextField textField;
            if (TAG_BR.equals(tagName)) {
                this.addLineBreak();
                return true;
            }
            if (TAG_P.equals(tagName)) {
                this.addLineBreak();
                if (opening) {
                    this.textStyle = style;
                }
                return true;
            }
            if (TAG_IMG.equals(tagName)) {
                String src = (String)attributeMap.get("src");
                String url = this.browser.makeAbsoluteURL(src);
                Dimension width = this.parseSizeValue((String)attributeMap.get("width"));
                Dimension height = this.parseSizeValue((String)attributeMap.get("height"));
                Style imageStyle = new Style();
                imageStyle.addAttribute(58, width);
                imageStyle.addAttribute(144, height);
                ImageItem item = width != null || height != null ? new ScaledImageItem(null, null, width, height, 0, "") : new ImageItem(null, null, 0, "");
                if (imageStyle != null) {
                    item.setStyle(imageStyle);
                }
                this.browser.loadImageLater(item, url);
                this.add(item);
                return true;
            }
            if (TAG_TITLE.equals(tagName)) {
                parser.next();
                name = this.handleText(parser.getText());
                Screen myScreen = this.browser.getScreen();
                if (name != null && myScreen != null) {
                    myScreen.setTitle(name);
                }
                return true;
            }
            if (TAG_STYLE.equals(tagName)) {
                parser.next();
                String cssCode = parser.getText();
                try {
                    CssInterpreter reader = new CssInterpreter(cssCode, (ResourceLoader)this.browser);
                    this.browser.setCssStyles(reader.getAllStyles());
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 540, (Object)"Unable to parse CSS", e);
                }
                return true;
            }
            if (TAG_META.equals(tagName)) {
                String content;
                String httpEquiv = (String)attributeMap.get("http-equiv");
                if (httpEquiv != null && TextUtil.equalsIgnoreCase("refresh", httpEquiv) && (content = (String)attributeMap.get("content")) != null) {
                    int equalsPos;
                    String url;
                    int waitTime;
                    block117: {
                        int semicolonPos = content.indexOf(59);
                        waitTime = 0;
                        url = content;
                        if (semicolonPos != -1) {
                            try {
                                waitTime = Integer.parseInt(content.substring(0, semicolonPos));
                                url = content.substring(semicolonPos + 1);
                            }
                            catch (Exception e) {
                                if (semicolonPos != 0) break block117;
                                url = content.substring(1);
                            }
                        }
                    }
                    if ((equalsPos = url.indexOf(61)) != -1) {
                        url = url.substring(equalsPos + 1).trim();
                    }
                    if (url.indexOf(58) == -1) {
                        url = url.charAt(0) != '/' ? "resource://" + url : "resource:/" + url;
                    }
                    if (waitTime > 0) {
                        new RedirectThread(this.browser, (long)waitTime * 1000L, url).start();
                    } else {
                        while (parser.next() != 1) {
                        }
                        this.browser.go(url);
                    }
                    return true;
                }
                return false;
            }
            if (TAG_TEXT_AREA.equals(tagName)) {
                parser.next();
                String value = this.handleText(parser.getText());
                int maxCharNumber = 500;
                String cols = (String)attributeMap.get("cols");
                String rows = (String)attributeMap.get("rows");
                if (cols != null && rows != null) {
                    try {
                        maxCharNumber = Integer.parseInt(cols) * Integer.parseInt(rows);
                    }
                    catch (Exception e) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 604, (Object)("Unable to parse textarea cols or rows attribute: cols=" + cols + ", rows="), rows);
                    }
                }
                textField = new TextField(null, value, maxCharNumber, 0, StyleSheet.browserinputStyle);
                if (style != null) {
                    textField.setStyle(style);
                }
                this.add(textField);
                if (this.currentForm != null) {
                    this.currentForm.addItem(textField);
                    textField.setAttribute(ATTR_FORM, this.currentForm);
                    String name4 = (String)attributeMap.get("name");
                    if (value == null) {
                        value = name4;
                    }
                    if (name4 != null) {
                        textField.setAttribute("name", name4);
                        textField.setAttribute("value", value);
                    }
                }
                return true;
            }
            if (TAG_BUTTON.equals(tagName) && this.currentForm != null) {
                name = (String)attributeMap.get("name");
                String value = (String)attributeMap.get("value");
                if (value == null) {
                    value = name;
                }
                StringItem buttonItem = new StringItem(null, value, StyleSheet.browserlinkStyle);
                if (style != null) {
                    buttonItem.setStyle(style);
                }
                buttonItem.setDefaultCommand(CMD_SUBMIT);
                buttonItem.setItemCommandListener(this);
                this.addCommands(TAG_INPUT, "type", INPUTTYPE_SUBMIT, buttonItem);
                this.add(buttonItem);
                this.currentForm.addItem(buttonItem);
                buttonItem.setAttribute(ATTR_FORM, this.currentForm);
                buttonItem.setAttribute("type", INPUTTYPE_SUBMIT);
                if (name != null) {
                    buttonItem.setAttribute("name", name);
                    buttonItem.setAttribute("value", value);
                }
            } else {
                if (TAG_INPUT.equals(tagName)) {
                    if (this.currentForm != null) {
                        String type = (String)attributeMap.get("type");
                        String name5 = (String)attributeMap.get("name");
                        String value = (String)attributeMap.get("value");
                        if (type != null) {
                            type = type.toLowerCase();
                        }
                        if (this.formListener != null && name5 != null) {
                            value = this.formListener.verifyInitialFormValue(this.currentForm.getAction(), name5, value);
                        }
                        if (INPUTTYPE_TEXT.equals(type) || INPUTTYPE_PASSWORD.equals(type) || INPUTTYPE_NUMERIC.equals(type)) {
                            int constraints = INPUTTYPE_NUMERIC.equals(type) ? 2 : (INPUTTYPE_TEXT.equals(type) ? 0 : 65536);
                            textField = new TextField((String)attributeMap.get("label"), value, 100, constraints, StyleSheet.browserinputStyle);
                            if (style != null) {
                                textField.setStyle(style);
                            }
                            this.add(textField);
                            this.currentForm.addItem(textField);
                            textField.setAttribute(ATTR_FORM, this.currentForm);
                            if (name5 != null) {
                                textField.setAttribute("name", name5);
                                if (value == null) {
                                    value = "";
                                }
                                textField.setAttribute("value", value);
                            }
                        } else if (INPUTTYPE_SUBMIT.equals(type)) {
                            if (value == null) {
                                value = name5;
                            }
                            StringItem buttonItem = new StringItem((String)attributeMap.get("label"), value, StyleSheet.browserlinkStyle);
                            if (style != null) {
                                buttonItem.setStyle(style);
                            }
                            buttonItem.setDefaultCommand(CMD_SUBMIT);
                            buttonItem.setItemCommandListener(this);
                            this.addCommands(TAG_INPUT, "type", INPUTTYPE_SUBMIT, buttonItem);
                            this.add(buttonItem);
                            this.currentForm.addItem(buttonItem);
                            buttonItem.setAttribute(ATTR_FORM, this.currentForm);
                            buttonItem.setAttribute("type", INPUTTYPE_SUBMIT);
                            if (name5 != null) {
                                buttonItem.setAttribute("name", name5);
                                buttonItem.setAttribute("value", value);
                            }
                        } else if (INPUTTYPE_HIDDEN.equals(type)) {
                            this.currentForm.addHiddenElement(name5, value);
                        } else if (INPUTTYPE_CHECKBOX.equals(type) || INPUTTYPE_RADIO.equals(type)) {
                            ChoiceGroup choiceGroup;
                            boolean isCheckBox = INPUTTYPE_CHECKBOX.equals(type);
                            parser.next();
                            String label = parser.getText().trim();
                            int labelLength = label.length();
                            if (labelLength == 0) {
                                parser.next();
                                label = parser.getText().trim();
                                labelLength = label.length();
                            }
                            if (labelLength > 0 && label.charAt(labelLength - 1) == '\n') {
                                label = label.substring(0, labelLength - 1);
                            }
                            if ((choiceGroup = isCheckBox ? this.currentCheckBoxChoiceGroup : this.currentRadioChoiceGroup) == null || !name5.equals(choiceGroup.getAttribute("name"))) {
                                Style groupStyle;
                                String groupLabel = (String)attributeMap.get("label");
                                if (isCheckBox) {
                                    choiceGroup = new ChoiceGroup(groupLabel, 2, StyleSheet.browserchoicegroupmultipleStyle);
                                } else {
                                    String choiceType = (String)attributeMap.get("choice");
                                    this.currentRadioChoiceGroup = "popup".equals(choiceType) ? (choiceGroup = new ChoiceGroup(groupLabel, 4, StyleSheet.browserchoicegrouppopupStyle)) : (choiceGroup = new ChoiceGroup(groupLabel, 1, StyleSheet.browserchoicegroupexclusiveStyle));
                                }
                                choiceGroup.setAttribute("name", name5);
                                String styleName = (String)attributeMap.get("groupclass");
                                if (styleName != null && (groupStyle = StyleSheet.getStyle(styleName)) != null) {
                                    choiceGroup.setStyle(groupStyle);
                                }
                                this.add(choiceGroup);
                                if (this.currentForm == null) {
                                    Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 775, "Error in HTML-Code: no <form> for <select> element found!");
                                } else {
                                    this.currentForm.addItem(choiceGroup);
                                }
                            }
                            ChoiceItem item = isCheckBox ? new ChoiceItem(label, null, 2, StyleSheet.browsercheckboxStyle) : new ChoiceItem(label, null, choiceGroup.getType(), StyleSheet.browserradioStyle);
                            item.setAttribute("value", value);
                            choiceGroup.append(item);
                            if (attributeMap.get("checked") != null) {
                                choiceGroup.setSelectedIndex(choiceGroup.size() - 1, true);
                            }
                            if (style != null) {
                                item.setStyle(style);
                            }
                        }
                    }
                    return true;
                }
                if (TAG_SCRIPT.equals(tagName)) {
                    parser.next();
                    return true;
                }
                if (TAG_TABLE.equals(tagName)) {
                    TableItem table = new TableItem();
                    table.setSelectionMode(10);
                    table.setCellContainerStyle(this.browser.getStyle());
                    if (style != null) {
                        table.setStyle(style);
                    }
                    this.currentTable = table;
                    this.browser.openContainer(table);
                    return true;
                }
                if (this.currentTable != null && TAG_TR.equals(tagName)) {
                    this.currentTable.moveToNextRow();
                    return true;
                }
                if (this.currentTable != null && TAG_TH.equals(tagName)) {
                    this.currentTable.moveToNextColumn();
                    return true;
                }
                if (this.currentTable != null && TAG_TD.equals(tagName)) {
                    this.currentTable.moveToNextColumn();
                    return true;
                }
                if (TAG_CODE.equals(tagName)) {
                    this.textStyle = StyleSheet.browsertextcodeStyle;
                }
            }
        } else {
            if (TAG_TABLE.equals(tagName)) {
                container = this.browser.closeContainer();
                this.currentTable = UiAccess.cast(container) instanceof TableItem ? (TableItem)UiAccess.cast(container) : null;
                return true;
            }
            if (TAG_CODE.equals(tagName)) {
                this.textStyle = null;
            }
        }
        if (TAG_B.equals(tagName) || TAG_STRONG.equals(tagName)) {
            this.textBold = opening;
            return true;
        }
        if (TAG_I.equals(tagName) || TAG_EM.equals(tagName)) {
            this.textItalic = opening;
            return true;
        }
        if (TAG_FORM.equals(tagName)) {
            if (opening) {
                name = (String)attributeMap.get("name");
                String action = (String)attributeMap.get("action");
                String method = (String)attributeMap.get("method");
                String encoding = (String)attributeMap.get("enctype");
                if (method == null) {
                    method = "GET";
                }
                this.currentForm = new HtmlForm(name, action, method, encoding, this.browser, this.formListener);
                this.browser.addForm(this.currentForm);
                this.browser.openContainer(style);
            } else {
                this.browser.closeContainer();
                this.currentForm = null;
                this.currentCheckBoxChoiceGroup = null;
                this.currentRadioChoiceGroup = null;
            }
            return true;
        }
        if (opening && TAG_BODY.equals(tagName) && style != null) {
            this.browser.setBackground(style.background);
            this.browser.setBorder(style.border);
            this.browser.setStyle(style, false);
        }
        return false;
    }

    private Dimension parseSizeValue(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        boolean isPercent = false;
        if (s.endsWith("%")) {
            isPercent = true;
            s = s.substring(0, s.length() - 1);
        }
        int value = 0;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Dimension(value, isPercent);
    }

    protected void addLineBreak() {
        StringItem stringItem = new StringItem(null, null, STYLE_LINE_BREAK);
        this.add(stringItem);
    }

    protected String handleText(String text) {
        return text;
    }

    private void add(Item item) {
        this.browser.add(item);
    }

    public boolean handleCommand(Command command) {
        if (command == CMD_LINK) {
            this.handleLinkCommand();
            return true;
        }
        if (command == CMD_SUBMIT) {
            this.handleSubmitCommand();
            return true;
        }
        if (command == CMD_BACK) {
            this.handleBackCommand();
            return true;
        }
        return false;
    }

    protected void handleBackCommand() {
        this.browser.goBack();
    }

    protected void handleSubmitCommand() {
        Item submitItem = this.browser.getFocusedItem();
        HtmlForm form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        while (form == null && submitItem instanceof Container) {
            submitItem = ((Container)submitItem).getFocusedItem();
            form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        }
        if (form == null) {
            return;
        }
        form.submit(submitItem);
    }

    protected void handleLinkCommand() {
        Item linkItem = this.getFocusedItemWithAttribute(ATTR_HREF, this.browser);
        if (linkItem == null) {
            return;
        }
        String href = (String)linkItem.getAttribute(ATTR_HREF);
        if (href != null) {
            this.browser.go(this.browser.makeAbsoluteURL(href));
        } else {
            Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 1033, (Object)("Unable to handle link command for item " + linkItem + ": no " + ATTR_HREF), " attribute found.");
        }
    }

    protected Item getFocusedItemWithAttribute(String attribute, Container container) {
        Item item = container.getFocusedItem();
        if (item != null && item.getAttribute(attribute) == null && item instanceof Container) {
            return this.getFocusedItemWithAttribute(attribute, (Container)item);
        }
        return item;
    }

    public void commandAction(Command command, Item item) {
        this.handleCommand(command);
    }

    public void setFormListener(FormListener listener) {
        this.formListener = listener;
    }
}

