/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.Browser;
import de.enough.polish.browser.ProtocolHandler;
import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlForm;
import de.enough.polish.browser.html.HtmlTagHandler;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.StringTokenizer;
import de.enough.polish.util.TextUtil;
import de.enough.polish.xml.SimplePullParser;

public class HtmlBrowser
extends Browser {
    protected HtmlTagHandler htmlTagHandler;
    protected final ArrayList forms;

    public HtmlBrowser() {
        this(StyleSheet.browserStyle);
    }

    public HtmlBrowser(Style style) {
        this(new HtmlTagHandler(), HtmlBrowser.getDefaultProtocolHandlers(), style);
    }

    public HtmlBrowser(HtmlTagHandler tagHandler, ProtocolHandler[] protocolHandlers) {
        this(tagHandler, protocolHandlers, StyleSheet.browserStyle);
    }

    public HtmlBrowser(HtmlTagHandler tagHandler, ProtocolHandler[] protocolHandlers, Style style) {
        super(protocolHandlers, style);
        tagHandler.register(this);
        this.htmlTagHandler = tagHandler;
        this.forms = new ArrayList();
    }

    public void setFormListener(FormListener listener) {
        this.htmlTagHandler.setFormListener(listener);
    }

    protected void handleText(String text) {
        if (text.length() > 0) {
            StringTokenizer st = new StringTokenizer(text, " \r\n\t");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                str = TextUtil.replace(str, "&nbsp;", " ");
                StringItem stringItem = null;
                stringItem = this.htmlTagHandler.textStyle != null ? new StringItem(null, str, this.htmlTagHandler.textStyle) : (this.htmlTagHandler.textBold && this.htmlTagHandler.textItalic ? new StringItem(null, str, StyleSheet.browsertextbolditalicStyle) : (this.htmlTagHandler.textBold ? new StringItem(null, str, StyleSheet.browsertextboldStyle) : (this.htmlTagHandler.textItalic ? new StringItem(null, str, StyleSheet.browsertextitalicStyle) : new StringItem(null, str, StyleSheet.browsertextStyle))));
                this.add(stringItem);
            }
        }
    }

    protected void parsePage(SimplePullParser parser) {
        this.forms.clear();
        super.parsePage(parser);
    }

    public HtmlForm getForm(String name) {
        for (int i = 0; i < this.forms.size(); ++i) {
            HtmlForm form = (HtmlForm)this.forms.get(i);
            if (!name.equals(form.getName())) continue;
            return form;
        }
        return null;
    }

    public HtmlForm getForm(int index) {
        return (HtmlForm)this.forms.get(index);
    }

    public int getNumberOfForms() {
        return this.forms.size();
    }

    public HtmlForm[] getForms() {
        return (HtmlForm[])this.forms.toArray(new HtmlForm[this.forms.size()]);
    }

    public void submitForm(int index) {
        this.submitForm(index, null);
    }

    public void submitForm(int index, String submitElement) {
        this.getForm(index).submit(submitElement);
    }

    public void submitForm(String name) {
        this.submitForm(name, null);
    }

    public void submitForm(String name, String submitElement) {
        this.getForm(name).submit(submitElement);
    }

    protected void addForm(HtmlForm form) {
        this.forms.add(form);
    }
}

