/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.bluetooth;

import de.enough.polish.bluetooth.L2CapStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.bluetooth.L2CAPConnection;

public class L2CapOutputStream
extends OutputStream
implements L2CapStream {
    private final L2CAPConnection connection;
    private int mtu;
    private byte[] buffer;
    private int bufferIndex;
    private boolean isFlushing;
    private final byte[] confirmation = new byte[48];

    public L2CapOutputStream(L2CAPConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.mtu = this.connection.getTransmitMTU();
        this.buffer = new byte[this.mtu];
    }

    public void write(int data) throws IOException {
        this.buffer[this.bufferIndex] = (byte)data;
        ++this.bufferIndex;
        if (this.bufferIndex >= this.mtu) {
            this.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        byte[] eofBuffer = new byte[48];
        System.arraycopy(L2CapStream.EOF_SEQUENCE, 0, eofBuffer, 0, L2CapStream.EOF_SEQUENCE.length);
        this.send(eofBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.bufferIndex > 0) {
            try {
                this.isFlushing = true;
                int index = this.bufferIndex;
                this.bufferIndex = 0;
                this.write(this.buffer, 0, index);
            }
            finally {
                this.isFlushing = false;
            }
        }
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int len) throws IOException {
        if (this.bufferIndex + len < 48 && !this.isFlushing) {
            System.arraycopy(data, offset, this.buffer, this.bufferIndex, len);
            this.bufferIndex += len;
            return;
        }
        if (this.bufferIndex > 0) {
            byte[] copy = new byte[len + this.bufferIndex];
            System.arraycopy(this.buffer, 0, copy, 0, this.bufferIndex);
            System.arraycopy(data, offset, copy, this.bufferIndex, len);
            len += this.bufferIndex;
            offset = 0;
            data = copy;
            this.bufferIndex = 0;
        }
        if (len <= this.mtu && offset == 0 && len == data.length) {
            this.send(data);
        } else {
            while (len > 0) {
                int currentLength = Math.min(len, this.mtu);
                byte[] transfer = new byte[currentLength];
                System.arraycopy(data, offset, transfer, 0, currentLength);
                len -= currentLength;
                offset += currentLength;
                this.send(transfer);
            }
        }
    }

    private void send(byte[] data) throws IOException {
        this.connection.send(data);
        this.connection.receive(this.confirmation);
    }
}

