/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.bluetooth;

import de.enough.polish.bluetooth.L2CapStream;
import java.io.IOException;
import java.io.InputStream;
import javax.bluetooth.L2CAPConnection;

public class L2CapInputStream
extends InputStream
implements L2CapStream {
    private final L2CAPConnection connection;
    private int mtu;
    private final byte[] buffer;
    private int bufferOffset;
    private int bufferLen;
    private final byte[] confirmation = new byte[48];

    public L2CapInputStream(L2CAPConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.mtu = connection.getReceiveMTU();
        this.buffer = new byte[this.mtu];
    }

    public int read() throws IOException {
        byte[] readBuffer = new byte[1];
        this.read(readBuffer, 0, 1);
        return readBuffer[0] & 0xFF;
    }

    public int available() throws IOException {
        if (this.bufferLen == 0 && this.connection.ready()) {
            this.bufferLen = this.connection.receive(this.buffer);
        }
        return this.bufferLen;
    }

    public void close() throws IOException {
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        if (this.bufferLen != 0) {
            len = Math.min(len, this.bufferLen);
            System.arraycopy(this.buffer, this.bufferOffset, data, offset, len);
            this.bufferOffset += len;
            this.bufferLen -= len;
            if (this.bufferLen == 0) {
                this.bufferOffset = 0;
            }
            return len;
        }
        int read = this.connection.receive(this.buffer);
        if (read == 48) {
            boolean isEof = true;
            for (int i = 0; i < read; ++i) {
                byte is = this.buffer[i];
                byte should = 0;
                if (i < L2CapStream.EOF_SEQUENCE.length) {
                    should = L2CapStream.EOF_SEQUENCE[i];
                }
                if (is == should) continue;
                isEof = false;
                break;
            }
            if (isEof) {
                this.connection.send(this.confirmation);
                return -1;
            }
        }
        this.connection.send(this.confirmation);
        len = Math.min(len, read);
        System.arraycopy(this.buffer, 0, data, offset, len);
        if (len < read) {
            this.bufferOffset = len;
            this.bufferLen = read - len;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException();
    }
}

