/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.benchmark;

import de.enough.polish.util.HashMap;
import de.enough.polish.util.Iterator;

public class Benchmark {
    static HashMap benchmarks;
    long time = 0L;
    String key;
    private static long lastTime;
    private static HashMap totalExecutionTimes;
    private static HashMap tempExecutionTimes;
    private static HashMap timerDescriptions;
    private static boolean outputResults;
    private static long checkInterval;

    public static void start(String key) {
        Benchmark benchmark = (Benchmark)benchmarks.get(key);
        if (benchmark == null) {
            benchmark = new Benchmark();
        }
        benchmark.setTime(System.currentTimeMillis());
        benchmarks.put(key, benchmark);
    }

    public static long stop(String key, String name) {
        long time = 0L;
        Benchmark benchmark = (Benchmark)benchmarks.get(key);
        if (benchmark == null) {
            return -1L;
        }
        time = System.currentTimeMillis() - benchmark.getTime();
        String formattedTime = Benchmark.getFormattedTime(time);
        return time;
    }

    long getTime() {
        return this.time;
    }

    void setTime(long time) {
        this.time = time;
    }

    static final String getFormattedTime(long time) {
        long seconds = time / 1000L;
        long milliseconds = time % 1000L;
        String millisecondsStr = "" + milliseconds;
        while (millisecondsStr.length() != 3) {
            millisecondsStr = "0" + millisecondsStr;
        }
        return seconds + "," + millisecondsStr;
    }

    private static void resetSmartTimers() {
        Iterator temp = totalExecutionTimes.keysIterator();
        while (temp.hasNext()) {
            Object key = temp.next();
            totalExecutionTimes.put(key, new Long(0L));
            tempExecutionTimes.put(key, new Long(0L));
        }
        lastTime = System.currentTimeMillis();
    }

    private static void outputSmartTimers() {
        Iterator temp = totalExecutionTimes.keysIterator();
        while (temp.hasNext()) {
            Object key = temp.next();
            if ((Long)totalExecutionTimes.get(key) <= 0L) continue;
            String tempStr = timerDescriptions.get(key) == null ? "\"" + key.toString() + "\"" : "\"" + timerDescriptions.get(key) + "\"";
            if (!outputResults) continue;
        }
    }

    public static void setSmartTimerDescription(Object timerName, String description) {
        timerDescriptions.put(timerName, description);
    }

    public static void startSmartTimer(Object name) {
        tempExecutionTimes.put(name, new Long(System.currentTimeMillis()));
    }

    public static void incrementSmartTimer(Object name) {
        Long val = (Long)totalExecutionTimes.get(name);
        if (val == null) {
            totalExecutionTimes.put(name, new Long(0L));
        } else {
            totalExecutionTimes.put(name, new Long(val + 1L));
        }
    }

    public static void pauseSmartTimer(Object name) {
        Long val = (Long)tempExecutionTimes.get(name);
        if (val == null) {
            return;
        }
        if (val == 0L) {
            return;
        }
        Long soFar = (Long)totalExecutionTimes.get(name);
        long timeSpentSoFar = 0L;
        if (soFar != null) {
            timeSpentSoFar = soFar;
        }
        totalExecutionTimes.put(name, new Long(timeSpentSoFar + System.currentTimeMillis() - val));
        tempExecutionTimes.put(name, new Long(0L));
    }

    public static void check() {
        Benchmark.check(checkInterval);
    }

    public static void setSmartTimerCheckInterval(long value) {
        checkInterval = value;
    }

    public static void check(long desiredElapsedTime) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - desiredElapsedTime > lastTime) {
            if (outputResults) {
                System.out.println("---");
                System.out.println("> TIME ELAPSED : " + (currentTime - lastTime));
            }
            Benchmark.outputSmartTimers();
            Benchmark.resetSmartTimers();
        }
    }

    public static void haltOutput() {
        outputResults = false;
    }

    public static void resumeOutput() {
        outputResults = true;
    }

    static {
        lastTime = 0L;
        outputResults = true;
        checkInterval = 5000L;
        totalExecutionTimes = new HashMap();
        tempExecutionTimes = new HashMap();
        timerDescriptions = new HashMap();
        benchmarks = new HashMap();
    }
}

