/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.utils;

import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.objects.BookmarkLabel;
import com.youversion.objects.BookmarkLabelCollection;
import de.enough.polish.util.TextUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class BookmarksUtil {
    public static BookmarkLabelCollection getLabelsForCollection(BookmarkCollection collection) {
        BookmarkLabelCollection result = new BookmarkLabelCollection();
        Hashtable<String, Integer> temp = new Hashtable<String, Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            String labels = ((Bookmark)collection.elementAt(i)).getLabels();
            String[] individualLabels = TextUtil.split(labels, ',');
            for (int j = 0; j < individualLabels.length; ++j) {
                String tempLabel = individualLabels[j].trim();
                Object value = temp.get(tempLabel);
                if (value != null) {
                    Integer currentValue = (Integer)value;
                    Integer nextValue = new Integer(currentValue + 1);
                    temp.put(tempLabel, nextValue);
                    continue;
                }
                temp.put(tempLabel, new Integer(1));
            }
        }
        Enumeration keys = temp.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Integer value = (Integer)temp.get(key);
            BookmarkLabel curLabel = new BookmarkLabel();
            curLabel.setLabel(key);
            curLabel.setTotal(value);
            result.addElement(curLabel);
        }
        return result;
    }

    public static BookmarkCollection filterByLabel(BookmarkCollection originalCollection, BookmarkLabel labelToFilterBy) {
        if (labelToFilterBy == null) {
            return originalCollection;
        }
        BookmarkCollection result = new BookmarkCollection();
        String label = labelToFilterBy.getLabel();
        for (int i = 0; i < originalCollection.size(); ++i) {
            String labels = ((Bookmark)originalCollection.elementAt(i)).getLabels();
            String[] individualLabels = TextUtil.split(labels, ',');
            for (int j = 0; j < individualLabels.length; ++j) {
                if (!label.equals(individualLabels[j].trim())) continue;
                result.addElement((Bookmark)originalCollection.elementAt(i));
            }
        }
        result.setTotal(result.size());
        return result;
    }
}

