/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.util;

public class StringHelper {
    public static String urlEncode(String s) {
        return StringHelper.urlEncode(s, true);
    }

    public static String urlEncode(String s, boolean encodePlus) {
        if (s != null) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            try {
                while (true) {
                    char b;
                    if ((b = s.charAt(i++)) >= 'a' && b <= 'z' || b >= 'A' && b <= 'Z' || b >= '0' && b <= '9' || b == '_' || b == '.' || !encodePlus && b == '+' || b == '-' || b == '$') {
                        tmp.append(b);
                        continue;
                    }
                    tmp.append(StringHelper.encode(b));
                }
            }
            catch (Exception e) {
                return tmp.toString();
            }
        }
        return null;
    }

    public static String encode(char c) {
        if (c <= '\u007f') {
            return "%" + StringHelper.toEvenHexString(c);
        }
        if (c <= '\u07ff') {
            int hi = c >> 6;
            int lo = c & 0x3F;
            return "%" + StringHelper.toEvenHexString(0xC0 | hi).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | lo).toUpperCase();
        }
        if (c <= '\uffff') {
            int b1 = c >> 12;
            int b2 = (c & 0xFC0) >> 6;
            int b3 = c & 0x3F;
            return "%" + StringHelper.toEvenHexString(0xE0 | b1).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | b2).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | b3).toUpperCase();
        }
        if (c <= '\u10ffff') {
            int b1 = c >> 18;
            int b2 = (c & 0x3F000) >> 12;
            int b3 = (c & 0xFC0) >> 6;
            int b4 = c & 0x3F;
            return "%" + StringHelper.toEvenHexString(0xF0 | b1).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | b2).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | b3).toUpperCase() + "%" + StringHelper.toEvenHexString(0x80 | b4).toUpperCase();
        }
        return "";
    }

    private static String toEvenHexString(int i) {
        String hex = Integer.toHexString(i);
        int count = hex.length();
        if (count % 2 > 0) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s1 == s2;
        }
        if (s2 == null) {
            return false;
        }
        return s1.toLowerCase().equals(s2.toLowerCase());
    }
}

