/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.util;

import com.youversion.util.DateHelper;
import java.util.Calendar;
import java.util.Hashtable;

public class DateParser {
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected int milli;
    protected int tzoffset;
    protected static int local_tz;
    private static Hashtable timezones;
    private int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static long julianDayOffset;
    private static int millisPerHour;
    private static int millisPerDay;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final String[] wtb;
    private static final int[] ttb;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;

    DateParser(int inp_year, int inp_month, int inp_day, int inp_hour, int inp_minute, int inp_second) {
        if (inp_year < 1583 || inp_month < 0 || inp_month > 11 || inp_day < 0 || inp_day > this.days_in_month[inp_month] && (inp_month != 1 || inp_day != 29 || inp_year % 4 != 0) || inp_hour < 0 || inp_hour > 23 || inp_minute < 0 || inp_minute > 59 || inp_second < 0 || inp_second > 59) {
            throw new IllegalArgumentException();
        }
        this.year = inp_year;
        this.month = inp_month;
        this.day = inp_day;
        this.hour = inp_hour;
        this.minute = inp_minute;
        this.second = inp_second;
        this.milli = 0;
    }

    DateParser(String s) {
        this.internalParse(s);
    }

    DateParser(String s, boolean iso) {
        if (!iso) {
            this.internalParse(s);
        } else {
            this.internalParseISO(s);
        }
    }

    static void setTimeZone(String tz) {
        if (timezones.get(tz) == null) {
            return;
        }
        local_tz = (Integer)timezones.get(tz);
    }

    public static long parse(String s) {
        return new DateParser(s).getTime();
    }

    public static long parseDate(String s) {
        if (s == null || s.length() < 10) {
            throw new IllegalArgumentException("date must start with the format YYYY-MM-DD");
        }
        int year = Integer.parseInt(s.substring(0, 4));
        int month = Integer.parseInt(s.substring(5, 7)) - 1;
        int day = Integer.parseInt(s.substring(8, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        DateHelper.setToMidnight(cal);
        return cal.getTime().getTime();
    }

    public static long parseISO(String date) {
        return new DateParser(date, true).getTime();
    }

    private String stripMillis(String date) {
        int startIdx = date.indexOf(46);
        int endIdx = date.length() - 1;
        if (startIdx == -1) {
            return date;
        }
        for (int i = startIdx + 1; i < date.length(); ++i) {
            char c = date.charAt(i);
            if (c >= '0' && c <= '9') continue;
            endIdx = i;
            break;
        }
        return date.substring(0, startIdx) + date.substring(endIdx);
    }

    private void internalParseISO(String date) {
        date = this.stripMillis(date);
        int[] field = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        int field_ptr = 0;
        int c = -1;
        int i = 0;
        int num_dig = 4;
        int n = -1;
        int prevc = 0;
        if (date == null) {
            throw new IllegalArgumentException();
        }
        int limit = date.length();
        while (i < limit) {
            c = date.charAt(i);
            ++i;
            if (c == 43 || c == 45 || c == 90 || c == 32 || c == 84 || c == 58) {
                prevc = c;
                continue;
            }
            if (c < 48 || 57 < c) {
                throw new IllegalArgumentException();
            }
            n = c - 48;
            --num_dig;
            while (i < limit && num_dig > 0) {
                char c2 = date.charAt(i);
                c = c2;
                if ('0' > c2 || c > 57) break;
                n = n * 10 + c - 48;
                ++i;
                --num_dig;
            }
            num_dig = 2;
            boolean field_ok = false;
            switch (field_ptr) {
                case 0: {
                    if (prevc != 0) break;
                    field_ok = true;
                    break;
                }
                case 1: {
                    if (prevc != 45 && prevc != 0) break;
                    field_ok = true;
                    break;
                }
                case 2: {
                    if (prevc != 45 && prevc != 0) break;
                    field_ok = true;
                    break;
                }
                case 3: {
                    if (prevc != 32 && prevc != 84) break;
                    field_ok = true;
                    break;
                }
                case 4: {
                    if (prevc != 58 && prevc != 0) break;
                    field_ok = true;
                    break;
                }
                case 5: {
                    if (prevc == 58 || prevc == 0) {
                        field_ok = true;
                        break;
                    }
                    if (prevc != 43 && prevc != 45) break;
                    field[field_ptr++] = 0;
                    field[field_ptr++] = prevc == 45 ? -1 : 1;
                    field_ok = true;
                    break;
                }
                case 6: {
                    if (prevc != 43 && prevc != 45 && prevc != 0) break;
                    field[field_ptr++] = prevc == 45 ? -1 : 1;
                    field_ok = true;
                    break;
                }
                case 8: {
                    if (prevc != 58 && prevc != 0) break;
                    field_ok = true;
                }
            }
            if (!field_ok) {
                throw new IllegalArgumentException();
            }
            field[field_ptr++] = n;
            prevc = 0;
        }
        if (field_ptr >= 5 || prevc == 90) {
            field_ptr = 9;
        }
        if (field_ptr < 8) {
            throw new IllegalArgumentException();
        }
        this.year = field[0];
        this.month = field[1] - 1;
        this.day = field[2];
        this.hour = field[3];
        this.minute = field[4];
        this.second = field[5];
        this.tzoffset = field[6] * ((field[7] * 60 + field[8]) * 60 * 1000);
        this.milli = 0;
    }

    int getYear() {
        return this.year;
    }

    int getMonth() {
        return this.month;
    }

    int getDay() {
        return this.day;
    }

    int getHour() {
        return this.hour;
    }

    int getMinute() {
        return this.minute;
    }

    int getSecond() {
        return this.second;
    }

    long getTime() {
        long julianDay = this.computeJulianDay(this.year, this.month, this.day);
        long millis = this.julianDayToMillis(julianDay);
        int millisInDay = 0;
        millisInDay += this.hour;
        millisInDay *= 60;
        millisInDay += this.minute;
        millisInDay *= 60;
        millisInDay += this.second;
        millisInDay *= 1000;
        return millis + (long)(millisInDay += this.milli) - (long)this.tzoffset;
    }

    private final long computeJulianDay(int inp_year, int inp_month, int inp_day) {
        boolean isLeap = inp_year % 4 == 0;
        int y = inp_year - 1;
        long julianDay = 365L * (long)y + DateParser.floorDivide(y, 4L) + 1721423L;
        isLeap = isLeap && (inp_year % 100 != 0 || inp_year % 400 == 0);
        julianDay += DateParser.floorDivide(y, 400L) - DateParser.floorDivide(y, 100L) + 2L;
        julianDay += isLeap ? (long)LEAP_NUM_DAYS[inp_month] : (long)NUM_DAYS[inp_month];
        return julianDay += (long)inp_day;
    }

    private static final long floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    private long julianDayToMillis(long julian) {
        return (julian - julianDayOffset) * (long)millisPerDay;
    }

    private void internalParse(String s) {
        block40: {
            int inp_year = -1;
            int mon = -1;
            int mday = -1;
            int inp_hour = -1;
            int min = -1;
            int sec = -1;
            int c = -1;
            int i = 0;
            int n = -1;
            int inp_tzoffset = -1;
            int prevc = 0;
            if (s != null) {
                int limit = s.length();
                block0: while (i < limit) {
                    c = s.charAt(i);
                    ++i;
                    if (c <= 32 || c == 44) continue;
                    if (c == 40) {
                        int depth = 1;
                        while (i < limit) {
                            c = s.charAt(i);
                            ++i;
                            if (c == 40) {
                                ++depth;
                                continue;
                            }
                            if (c != 41 || --depth > 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (48 <= c && c <= 57) {
                        n = c - 48;
                        while (i < limit) {
                            char c2 = s.charAt(i);
                            c = c2;
                            if ('0' > c2 || c > 57) break;
                            n = n * 10 + c - 48;
                            ++i;
                        }
                        if (prevc == 43 || prevc == 45 && inp_year >= 0) {
                            n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                            if (prevc == 43) {
                                n = -n;
                            }
                            if (inp_tzoffset != 0 && inp_tzoffset != -1) break block40;
                            inp_tzoffset = n;
                        } else if (n >= 70) {
                            if (inp_year >= 0 || c > 32 && c != 44 && c != 47 && i < limit) break block40;
                            inp_year = n < 100 ? n + 1900 : n;
                        } else if (c == 58) {
                            if (inp_hour < 0) {
                                inp_hour = (byte)n;
                            } else {
                                if (min >= 0) break block40;
                                min = (byte)n;
                            }
                        } else if (c == 47) {
                            if (mon < 0) {
                                mon = (byte)(n - 1);
                            } else {
                                if (mday >= 0) break block40;
                                mday = (byte)n;
                            }
                        } else {
                            if (i < limit && c != 44 && c > 32 && c != 45) break block40;
                            if (inp_hour >= 0 && min < 0) {
                                min = (byte)n;
                            } else if (min >= 0 && sec < 0) {
                                sec = (byte)n;
                            } else {
                                if (mday >= 0) break block40;
                                mday = (byte)n;
                            }
                        }
                        prevc = 0;
                        continue;
                    }
                    if (c == 47 || c == 58 || c == 43 || c == 45) {
                        prevc = c;
                        continue;
                    }
                    int st = i - 1;
                    while (i < limit && (65 <= (c = (int)s.charAt(i)) && c <= 90 || 97 <= c && c <= 122)) {
                        ++i;
                    }
                    if (i <= st + 1) break block40;
                    int k = wtb.length;
                    while (--k >= 0) {
                        if (!wtb[k].regionMatches(true, 0, s, st, i - st)) continue;
                        int action = ttb[k];
                        if (action == 0) break;
                        if (action == 1) {
                            if (inp_hour <= 12 && inp_hour >= 1) {
                                if (inp_hour >= 12) break;
                                inp_hour += 12;
                                break;
                            }
                            break block40;
                        }
                        if (action == 14) {
                            if (inp_hour <= 12 && inp_hour >= 1) {
                                if (inp_hour != 12) break;
                                inp_hour = 0;
                                break;
                            }
                            break block40;
                        }
                        if (action <= 13) {
                            if (mon < 0) {
                                mon = (byte)(action - 2);
                                break;
                            }
                            break block40;
                        }
                        inp_tzoffset = action - 10000;
                        break;
                    }
                    if (k >= 0) {
                        prevc = 0;
                        continue;
                    }
                    break block40;
                }
                if (inp_year >= 1583 && mon >= 0 && mday >= 0) {
                    if (sec < 0) {
                        sec = 0;
                    }
                    if (min < 0) {
                        min = 0;
                    }
                    if (inp_hour < 0) {
                        inp_hour = 0;
                    }
                    this.year = inp_year;
                    this.month = mon;
                    this.day = mday;
                    this.hour = inp_hour;
                    this.tzoffset = -inp_tzoffset * 60 * 1000;
                    this.minute = min;
                    this.second = sec;
                    this.milli = 0;
                    return;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static void main(String[] args) {
        System.out.println(new DateParser(args[0], true).getTime());
    }

    static {
        julianDayOffset = 2440588L;
        millisPerHour = 3600000;
        millisPerDay = 24 * millisPerHour;
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
        NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        timezones = new Hashtable();
        timezones.put("GMT", new Integer(0 * millisPerHour));
        timezones.put("UT", new Integer(0 * millisPerHour));
        timezones.put("UTC", new Integer(0 * millisPerHour));
        timezones.put("PST", new Integer(-8 * millisPerHour));
        timezones.put("PDT", new Integer(-7 * millisPerHour));
        timezones.put("JST", new Integer(9 * millisPerHour));
        local_tz = (Integer)timezones.get("PST");
    }
}

