/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.util;

import java.util.Calendar;
import java.util.Date;

public final class DateHelper {
    private static final int[] LEAP_YEAR_DAYS_IN_MONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] NON_LEAP_YEAR_DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int DAY_IN_MILLIS = 86400000;

    private DateHelper() {
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 == 0) {
            if (year % 100 != 0) {
                return true;
            }
            if (year % 400 == 0) {
                return true;
            }
        }
        return false;
    }

    public static int getDayOfYear(Calendar date) {
        int year = date.get(1);
        int month = date.get(2);
        int sum = 0;
        for (int m = 0; m < month; ++m) {
            sum += DateHelper.getNumberOfDaysInMonth(m, year);
        }
        return sum += date.get(5);
    }

    public static int getNumberOfDaysInMonth(int month, int year) {
        if (DateHelper.isLeapYear(year)) {
            return LEAP_YEAR_DAYS_IN_MONTH[month];
        }
        return NON_LEAP_YEAR_DAYS_IN_MONTH[month];
    }

    public static int getNumberOfDays(Date from, Date to) {
        from = DateHelper.getMidnightTime(from);
        to = DateHelper.getMidnightTime(to);
        return (int)((to.getTime() - from.getTime()) / 86400000L);
    }

    public static Date getMidnightTime(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        DateHelper.setToMidnight(cal);
        return cal.getTime();
    }

    public static void setToMidnight(Calendar day) {
        day.set(11, 0);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
    }
}

