/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions.item;

import com.youversion.objects.ReadingPlan;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class PlanProgressItem
extends Container {
    private final ReadingPlan plan;
    private final StringItem titleItem;
    private final Gauge progressItem;
    private final StringItem textItem;

    public PlanProgressItem(ReadingPlan plan) {
        super(StyleSheet.plan_progressStyle);
        this.plan = plan;
        double percentageCompleted = plan.getSubscription().getCompletionPercentage();
        int currentDay = plan.getCurrentDay();
        int totalDays = plan.getTotalDays();
        this.titleItem = new StringItem(null, plan.getName().trim(), 0, StyleSheet.plan_progress_titleStyle);
        this.add(this.titleItem);
        String currentDayStr = "" + currentDay;
        String totalDaysStr = "" + totalDays;
        String percentageCompletedStr = "" + percentageCompleted;
        percentageCompletedStr = percentageCompletedStr.substring(0, percentageCompletedStr.indexOf(46) + 2);
        String[] params = new String[]{currentDayStr, totalDaysStr, percentageCompletedStr};
        String formattedProgress = Locale.get(3, params);
        Container progressList = new Container(false, StyleSheet.plan_progress_info_listStyle);
        this.progressItem = new Gauge(null, true, 100, (int)percentageCompleted, StyleSheet.plan_progress_info_progressStyle);
        progressList.add(this.progressItem);
        this.textItem = new StringItem(null, formattedProgress, 0, StyleSheet.plan_progress_info_textStyle);
        progressList.add(this.textItem);
        this.add(progressList);
        progressList.setAppearanceMode(0);
    }

    public ReadingPlan getPlan() {
        return this.plan;
    }
}

