/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions;

import com.youversion.polish.extensions.ImageResourceBackground;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PatchBackground
extends ImageResourceBackground {
    public static final int STYLE_FULL = 0;
    public static final int STYLE_TOP = 1;
    public static final int STYLE_CENTER = 2;
    public static final int STYLE_BOTTOM = 3;
    private int colorX;
    private int colorY;
    private int leftWidth;
    private int topHeight;
    private int rightWidth;
    private int bottomHeight;
    private int marginLeft;
    private int marginTop;
    private int marginRight;
    private int marginBottom;
    private int style;
    private int color;

    public PatchBackground(String imageUrl, int colorX, int colorY, int leftWidth, int topHeight, int rightWidth, int bottomHeight, int marginLeft, int marginTop, int marginRight, int marginBottom, int style) {
        super(imageUrl);
        this.colorX = colorX;
        this.colorY = colorY;
        this.color = ImageUtil.getPixelColor(this.image, this.colorX, this.colorY);
        this.leftWidth = leftWidth;
        this.topHeight = topHeight;
        this.rightWidth = rightWidth;
        this.bottomHeight = bottomHeight;
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
        this.style = style;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        width = width + this.marginLeft + this.marginRight;
        height = height + this.marginTop + this.marginBottom;
        this.paintCorners(x -= this.marginLeft, y -= this.marginTop, width, height, g);
        this.paintHorizontalFill(x, y, width, height, g);
        this.paintVerticalFill(x, y, width, height, g);
        this.paintColorFill(x, y, width, height, g);
    }

    private void paintCorners(int x, int y, int width, int height, Graphics g) {
        int dstY;
        int dstX;
        int srcY;
        int srcX;
        if (this.style == 0 || this.style == 1) {
            srcX = 0;
            srcY = 0;
            dstX = x + srcX;
            dstY = y + srcY;
            g.drawRegion(this.image, srcX, srcY, this.leftWidth, this.topHeight, 0, dstX, dstY, 20);
        }
        if (this.style == 0 || this.style == 1) {
            srcX = this.imageWidth - this.rightWidth;
            srcY = 0;
            dstX = x + (width - this.rightWidth);
            dstY = y;
            g.drawRegion(this.image, srcX, srcY, this.rightWidth, this.topHeight, 0, dstX, dstY, 20);
        }
        if (this.style == 0 || this.style == 3) {
            srcX = 0;
            srcY = this.imageHeight - this.bottomHeight;
            dstX = x;
            dstY = y + (height - this.bottomHeight);
            g.drawRegion(this.image, srcX, srcY, this.leftWidth, this.bottomHeight, 0, dstX, dstY, 20);
        }
        if (this.style == 0 || this.style == 3) {
            srcX = this.imageWidth - this.rightWidth;
            srcY = this.imageHeight - this.bottomHeight;
            dstX = x + (width - this.rightWidth);
            dstY = y + (height - this.bottomHeight);
            g.drawRegion(this.image, srcX, srcY, this.rightWidth, this.bottomHeight, 0, dstX, dstY, 20);
        }
    }

    private void paintHorizontalFill(int x, int y, int width, int height, Graphics g) {
        int xOffset;
        int dstY;
        int srcY;
        int srcX = this.leftWidth;
        int srcWidth = this.imageWidth - (this.leftWidth + this.rightWidth);
        int srcHeight = this.topHeight;
        int dstX = x + this.leftWidth;
        int fillWidth = width - (this.leftWidth + this.rightWidth);
        this.storeClipping(g);
        g.clipRect(dstX, y, fillWidth, height);
        if (this.style == 0 || this.style == 1) {
            srcY = 0;
            dstY = y;
            for (xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
                g.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, 0, dstX + xOffset, dstY, 20);
            }
        }
        if (this.style == 0 || this.style == 3) {
            srcY = this.imageHeight - this.bottomHeight;
            dstY = y + (height - this.bottomHeight);
            for (xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
                g.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, 0, dstX + xOffset, dstY, 20);
            }
        }
        this.restoreClipping(g);
    }

    private void paintVerticalFill(int x, int y, int width, int height, Graphics g) {
        int yOffset;
        int srcX = 0;
        int srcY = this.topHeight;
        int srcWidth = this.leftWidth;
        int srcHeight = this.imageHeight - (this.topHeight + this.bottomHeight);
        int dstX = x;
        int dstY = y;
        if (this.style == 1 || this.style == 0) {
            dstY += this.topHeight;
        }
        int fillHeight = height;
        if (this.style == 3 || this.style == 0) {
            fillHeight -= this.bottomHeight;
        }
        if (this.style == 1 || this.style == 0) {
            fillHeight -= this.topHeight;
        }
        this.storeClipping(g);
        g.clipRect(x, dstY, width, fillHeight);
        for (yOffset = 0; yOffset < fillHeight; yOffset += srcHeight) {
            g.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, 0, dstX, dstY + yOffset, 20);
        }
        srcX = this.imageWidth - this.rightWidth;
        dstX = x + (width - this.rightWidth);
        for (yOffset = 0; yOffset < fillHeight; yOffset += srcHeight) {
            g.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, 0, dstX, dstY + yOffset, 20);
        }
        this.restoreClipping(g);
    }

    private void paintColorFill(int x, int y, int width, int height, Graphics g) {
        int dstX = x + this.leftWidth;
        int dstY = y;
        if (this.style == 1 || this.style == 0) {
            dstY += this.topHeight;
        }
        int fillWidth = width - (this.leftWidth + this.rightWidth);
        int fillHeight = height;
        if (this.style == 3 || this.style == 0) {
            fillHeight -= this.bottomHeight;
        }
        if (this.style == 1 || this.style == 0) {
            fillHeight -= this.topHeight;
        }
        g.setColor(this.color);
        g.fillRect(dstX, dstY, fillWidth, fillHeight);
    }

    public PatchBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomHeight = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.colorX = dataInputStream.readInt();
        this.colorY = dataInputStream.readInt();
        this.leftWidth = dataInputStream.readInt();
        this.marginBottom = dataInputStream.readInt();
        this.marginLeft = dataInputStream.readInt();
        this.marginRight = dataInputStream.readInt();
        this.marginTop = dataInputStream.readInt();
        this.rightWidth = dataInputStream.readInt();
        this.style = dataInputStream.readInt();
        this.topHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomHeight);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.colorX);
        dataOutputStream.writeInt(this.colorY);
        dataOutputStream.writeInt(this.leftWidth);
        dataOutputStream.writeInt(this.marginBottom);
        dataOutputStream.writeInt(this.marginLeft);
        dataOutputStream.writeInt(this.marginRight);
        dataOutputStream.writeInt(this.marginTop);
        dataOutputStream.writeInt(this.rightWidth);
        dataOutputStream.writeInt(this.style);
        dataOutputStream.writeInt(this.topHeight);
    }
}

