/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.Language;
import com.youversion.objects.Version;
import com.youversion.util.JsonHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class VersionCollection
implements Externalizable {
    protected Hashtable _byAbbrev = new Hashtable();
    protected Hashtable _byLang = new Hashtable();
    protected Hashtable _langsHash = new Hashtable();
    protected Hashtable _defaults = new Hashtable();
    protected Vector _langs = new Vector();
    protected Vector _versions = new Vector();
    protected Vector _versionsByLang = null;

    public void add(Version v) {
        String iso = v.getLanguage().getIso().toLowerCase().trim();
        if (!this._byLang.containsKey(iso)) {
            this._byLang.put(iso, new Vector());
            this.addSorted(this._langs, v.getLanguage());
            this._langsHash.put(iso, v.getLanguage());
        }
        this.addSorted(this._versions, v);
        this.addSorted((Vector)this._byLang.get(iso), v);
        this._byAbbrev.put(v.getAbbreviation().toLowerCase().trim(), v);
    }

    private void addSorted(Vector vector, Version newVersion) {
        for (int i = 0; i < vector.size(); ++i) {
            Version version = (Version)vector.elementAt(i);
            if (version.getTitle().compareTo(newVersion.getTitle()) <= 0) continue;
            vector.insertElementAt(newVersion, i);
            return;
        }
        vector.addElement(newVersion);
    }

    private void addSorted(Vector vector, Language newLang) {
        for (int i = 0; i < vector.size(); ++i) {
            Language lang = (Language)vector.elementAt(i);
            if (lang.getIso().compareTo(newLang.getIso()) <= 0) continue;
            vector.insertElementAt(newLang, i);
            return;
        }
        vector.addElement(newLang);
    }

    public Version get(String abbreviation) {
        return (Version)this._byAbbrev.get(abbreviation.toLowerCase().trim());
    }

    public Vector getByLang(Language lang) {
        return this.getByLang(lang.getIso());
    }

    public Vector getByLang(String iso) {
        return (Vector)this._byLang.get(iso.toLowerCase().trim());
    }

    public Vector getLangs() {
        return this._langs;
    }

    public Hashtable getLangsHash() {
        return this._langsHash;
    }

    public Vector getVersions() {
        return this._versions;
    }

    public Vector getVersionsByLang() {
        if (this._versionsByLang == null) {
            this._versionsByLang = new Vector();
            for (int i = 0; i < this._langs.size(); ++i) {
                Language lang = (Language)this._langs.elementAt(i);
                Vector langVersions = this.getByLang(lang.getIso());
                for (int j = 0; j < langVersions.size(); ++j) {
                    this._versionsByLang.addElement(langVersions.elementAt(j));
                }
            }
        }
        return this._versionsByLang;
    }

    public int versionCount() {
        return this._byAbbrev.size();
    }

    public int languageCount() {
        return this._langs.size();
    }

    public static VersionCollection unloadJSON(JSONObject data) throws JSONException {
        VersionCollection collection = ApiBase.getApiFactory().newVersionCollection();
        JSONObject versions = data.getJSONObject("versions");
        JSONArray order = data.getJSONArray("order");
        JSONObject defaults = data.optJSONObject("defaults");
        for (int i = 0; i < order.length(); ++i) {
            String abbrev = order.getString(i);
            Version version = Version.unloadJSON(versions.getJSONObject(abbrev));
            version.setAbbreviation(abbrev);
            collection.add(version);
        }
        collection.setDefaults(JsonHelper.toHashtable(defaults));
        return collection;
    }

    public void setDefaults(Hashtable hashtable) {
        if (hashtable == null) {
            this._defaults.clear();
        } else {
            this._defaults = hashtable;
        }
    }

    public Hashtable getDefaults() {
        return this._defaults;
    }

    public void remove(Version v) {
        String iso = v.getLanguage().getIso().toLowerCase().trim();
        Vector langVector = (Vector)this._byLang.get(iso);
        langVector.removeElement(v);
        if (langVector.size() == 0) {
            this._byLang.remove(iso);
            this._langs.removeElement(v.getLanguage());
            this._langsHash.remove(iso);
        }
        this._versions.removeElement(v);
        this._byAbbrev.remove(v.getAbbreviation());
    }

    public void removeByLang(String iso) {
        iso = iso.toLowerCase().trim();
        Vector byLang = this.getByLang(iso);
        for (int i = 0; i < byLang.size(); ++i) {
            this.remove((Version)byLang.elementAt(i));
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this._byAbbrev = (Hashtable)Serializer.deserialize(dataInputStream);
        this._byLang = (Hashtable)Serializer.deserialize(dataInputStream);
        this._defaults = (Hashtable)Serializer.deserialize(dataInputStream);
        this._langs = (Vector)Serializer.deserialize(dataInputStream);
        this._langsHash = (Hashtable)Serializer.deserialize(dataInputStream);
        this._versions = (Vector)Serializer.deserialize(dataInputStream);
        this._versionsByLang = (Vector)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this._byAbbrev, dataOutputStream);
        Serializer.serialize(this._byLang, dataOutputStream);
        Serializer.serialize(this._defaults, dataOutputStream);
        Serializer.serialize(this._langs, dataOutputStream);
        Serializer.serialize(this._langsHash, dataOutputStream);
        Serializer.serialize(this._versions, dataOutputStream);
        Serializer.serialize(this._versionsByLang, dataOutputStream);
    }
}

