/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.Reference;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.json.me.JSONArray;

public class ReferenceCollection
implements Externalizable {
    protected Vector _data = new Vector();

    public Reference elementAt(int location) {
        return (Reference)this._data.elementAt(location);
    }

    public int size() {
        return this._data.size();
    }

    public void addElement(Reference v) {
        this._data.addElement(v);
    }

    public void addAll(ReferenceCollection v) {
        for (int i = 0; i < v.size(); ++i) {
            this.addElement(v.elementAt(i));
        }
    }

    public void removeElementAt(int index) {
        this._data.removeElementAt(index);
    }

    public boolean contains(Reference v) {
        for (int i = 0; i < this._data.size(); ++i) {
            if (!this.elementAt(i).contains(v)) continue;
            return true;
        }
        return false;
    }

    public String toOsis() {
        int count = this._data.size();
        if (count == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(this.elementAt(i).getOsis());
            sb.append("+");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String toBookChapterOsis() {
        int count = this._data.size();
        if (count == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(this.elementAt(i).getBookChapterOsis());
            sb.append("+");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static ReferenceCollection unloadJSON(JSONArray json) {
        try {
            ReferenceCollection obj = ApiBase.getApiFactory().newReferenceCollection();
            for (int i = 0; i < json.length(); ++i) {
                obj.addElement(Reference.unloadJSON(json.getJSONObject(i)));
            }
            return obj;
        }
        catch (Throwable throwable) {
            return ApiBase.getApiFactory().newReferenceCollection();
        }
    }

    public String toHumanString() {
        int count = this.size();
        if (count == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(this.elementAt(i).getHumanString());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this._data = (Vector)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this._data, dataOutputStream);
    }
}

