/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.util.StringHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Reference
implements Externalizable {
    protected String book;
    protected String humanBook;
    protected int chapter;
    protected int startVerse = 0;
    protected int endVerse = 0;

    public Reference() {
    }

    public Reference(String osis, String humanBook) {
        this.setOsis(osis);
        this.humanBook = humanBook;
    }

    public Reference(String book, int chapter, String humanBook) {
        this.book = book;
        this.chapter = chapter;
        this.humanBook = humanBook;
    }

    public Reference(String book, int chapter, int verse, String humanBook) {
        this(book, chapter, humanBook);
        this.setVerse(verse);
    }

    public Reference(String book, int chapter, int startVerse, int endVerse, String humanBook) {
        this(book, chapter, humanBook);
        this.setVerseRange(startVerse, endVerse);
    }

    public String getOsis() {
        return Reference.toString(this);
    }

    public String getBookChapterOsis() {
        return Reference.toString(this.book, this.chapter);
    }

    public void setOsis(String osis) {
        this.book = this.parseBook(osis);
        this.chapter = this.parseChapter(osis);
        this.startVerse = this.parseStartVerse(osis);
        this.endVerse = this.parseEndVerse(osis);
    }

    public String getHumanString() {
        if (this.endVerse > this.startVerse) {
            return this.humanBook + " " + this.chapter + ":" + this.startVerse + "-" + this.endVerse;
        }
        if (this.startVerse > 0) {
            return this.humanBook + " " + this.chapter + ":" + this.startVerse;
        }
        return this.humanBook + " " + this.chapter;
    }

    public void setHumanBook(String human) {
        this.humanBook = human;
    }

    public String getHumanBook() {
        return this.humanBook;
    }

    public int getChapter() {
        return this.chapter;
    }

    public void setChapter(int value) {
        this.chapter = value;
    }

    public int getStartVerse() {
        return this.startVerse;
    }

    public String getBookOsis() {
        return this.book;
    }

    public void setBook(String book) {
        this.book = book;
    }

    public int getEndVerse() {
        return this.endVerse == 0 ? this.startVerse : this.endVerse;
    }

    public void setVerse(int value) {
        this.startVerse = value;
        this.endVerse = 0;
    }

    public boolean hasVerse() {
        return this.startVerse > 0;
    }

    public void setVerseRange(int startVerse, int endVerse) {
        this.startVerse = startVerse;
        this.endVerse = endVerse;
    }

    public static Reference unloadJSON(JSONObject json) {
        try {
            if (json.has("reference")) {
                json = json.getJSONObject("reference");
            }
            String osis = json.getString("osis");
            String humanFull = json.getString("human");
            int indexOf = humanFull.lastIndexOf(32);
            String humanBook = humanFull.substring(0, indexOf);
            return ApiBase.getApiFactory().newReference(osis, humanBook);
        }
        catch (JSONException e) {
            ApiBase.getDebugHelper().logError("Reference: could not unload json", e);
            return null;
        }
    }

    protected boolean hasVerse(String osis) {
        int count = 0;
        int idx = -1;
        while ((idx = osis.indexOf(46, idx + 1)) >= 0) {
            ++count;
        }
        return count == 2;
    }

    protected int parseStartVerse(String osis) {
        if (!this.hasVerse(osis)) {
            return 0;
        }
        int lastIdx = osis.lastIndexOf(45);
        if (lastIdx < 0) {
            lastIdx = osis.length();
        }
        return Integer.parseInt(osis.substring(osis.lastIndexOf(46) + 1, lastIdx));
    }

    protected int parseEndVerse(String osis) {
        int lastIdx = osis.lastIndexOf(45);
        if (lastIdx < 0) {
            return 0;
        }
        return Integer.parseInt(osis.substring(lastIdx + 1, osis.length()));
    }

    protected String parseBook(String osis) {
        int index = osis.indexOf(46);
        if (index < 0) {
            return osis;
        }
        return osis.substring(0, index);
    }

    protected int parseChapter(String osis) {
        int index = osis.indexOf(46);
        if (index < 0) {
            return 0;
        }
        int lastIdx = osis.lastIndexOf(46);
        if (index == lastIdx) {
            return Integer.parseInt(osis.substring(index + 1));
        }
        return Integer.parseInt(osis.substring(index + 1, lastIdx));
    }

    public Object clone() {
        Reference reference = ApiBase.getApiFactory().newReference();
        reference.book = this.book;
        reference.chapter = this.chapter;
        reference.startVerse = this.startVerse;
        reference.endVerse = this.endVerse;
        reference.humanBook = this.humanBook;
        return reference;
    }

    public static String toString(Reference r) {
        return Reference.toString(r.book, r.chapter, r.startVerse, r.endVerse);
    }

    public static String toString(String book, int chapter) {
        return Reference.toString(book, chapter, 0, 0);
    }

    public static String toString(String book, int chapter, int verse) {
        return Reference.toString(book, chapter, verse, 0);
    }

    public static String toString(String book, int chapter, int startVerse, int endVerse) {
        StringBuffer sb = new StringBuffer();
        sb.append(book);
        sb.append('.');
        sb.append(chapter);
        if (startVerse > 0) {
            sb.append('.');
            sb.append(startVerse);
            if (endVerse > startVerse) {
                sb.append('-');
                sb.append(endVerse);
            }
        }
        return sb.toString();
    }

    public boolean contains(Reference reference) {
        return StringHelper.equalsIgnoreCase(this.getBookOsis(), reference.getBookOsis()) && this.getChapter() == reference.getChapter() && (this.getStartVerse() == 0 || this.getStartVerse() <= reference.getStartVerse() && this.getEndVerse() >= reference.getEndVerse());
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.book = (String)Serializer.deserialize(dataInputStream);
        this.chapter = dataInputStream.readInt();
        this.endVerse = dataInputStream.readInt();
        this.humanBook = (String)Serializer.deserialize(dataInputStream);
        this.startVerse = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.book, dataOutputStream);
        dataOutputStream.writeInt(this.chapter);
        dataOutputStream.writeInt(this.endVerse);
        Serializer.serialize(this.humanBook, dataOutputStream);
        dataOutputStream.writeInt(this.startVerse);
    }
}

