/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanCategory;
import com.youversion.util.JsonHelper;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class ReadingPlanCollection {
    protected Vector _data = new Vector();
    protected int total = 0;
    protected ReadingPlanCategory category = null;
    protected Hashtable facetTotalDays = null;

    public ReadingPlan elementAt(int location) {
        return (ReadingPlan)this._data.elementAt(location);
    }

    public int size() {
        return this._data.size();
    }

    public void addElement(ReadingPlan v) {
        this._data.addElement(v);
    }

    public void addAll(ReadingPlanCollection v) {
        for (int i = 0; i < v.size(); ++i) {
            this.addElement(v.elementAt(i));
        }
    }

    public void removeById(int id) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i).getId() != id) continue;
            this._data.removeElementAt(i);
            return;
        }
    }

    public void removeAllById(ReadingPlanCollection items) {
        for (int i = 0; i < items.size(); ++i) {
            this.removeById(items.elementAt(i).getId());
        }
    }

    public Vector asVector() {
        return this._data;
    }

    public ReadingPlanCategory getCategory() {
        return this.category;
    }

    public void setCategory(ReadingPlanCategory category) {
        this.category = category;
    }

    public static ReadingPlanCollection unloadJSON(JSONObject data) throws JSONException, YouVersionApiException {
        JSONObject totalDays;
        JSONObject facets;
        ReadingPlanCollection obj = ApiBase.getApiFactory().newReadingPlanCollection();
        obj.setTotal(data.getInt("total"));
        if (data.has("categories")) {
            JSONObject categories = data.getJSONObject("categories");
            obj.setCategory(ReadingPlanCategory.unloadJSON(categories));
        }
        if ((facets = data.optJSONObject("facets")) != null && (totalDays = facets.optJSONObject("total_days")) != null) {
            obj.facetTotalDays = JsonHelper.toHashtable(totalDays);
        }
        JSONArray plans = data.getJSONArray("reading_plans");
        for (int i = 0; i < plans.length(); ++i) {
            obj.addElement(ReadingPlan.unloadJSON(plans.getJSONObject(i)));
        }
        return obj;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Hashtable getFacetTotalDays() {
        return this.facetTotalDays;
    }

    public void setFacetTotalDays(Hashtable facetTotalDays) {
        this.facetTotalDays = facetTotalDays;
    }
}

