/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.util.JsonHelper;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class ReadingPlanCategory {
    protected String category = null;
    protected String label = null;
    protected ReadingPlanCategory parent = null;
    protected Vector children = null;
    protected Vector breadcrumbs = null;

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ReadingPlanCategory getParent() {
        return this.parent;
    }

    public void setParent(ReadingPlanCategory parent) {
        this.parent = parent;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public void addChild(ReadingPlanCategory child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(child);
    }

    public ReadingPlanCategory childAt(int index) {
        return (ReadingPlanCategory)this.children.elementAt(index);
    }

    public boolean isRoot() {
        return this.category == null;
    }

    public int size() {
        return this.children == null ? 0 : this.children.size();
    }

    public Vector getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(Vector breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    private void addBreadcrumb(ReadingPlanCategory breadcrumb) {
        if (this.breadcrumbs == null) {
            this.breadcrumbs = new Vector();
        }
        this.breadcrumbs.addElement(breadcrumb);
    }

    public static ReadingPlanCategory unloadJSON(JSONObject data) throws JSONException {
        JSONArray breadcrumbs;
        JSONArray children;
        ReadingPlanCategory obj = ApiBase.getApiFactory().newReadingPlanCategory();
        JSONObject parent = JsonHelper.getJSONObject(data, "parent");
        if (parent != null) {
            obj.parent = ApiBase.getApiFactory().newReadingPlanCategory();
            obj.parent.setCategory(parent.getString("category"));
            obj.parent.setLabel(JsonHelper.getLocaleString(parent, "labels"));
        } else {
            obj.parent = null;
        }
        JSONObject current = JsonHelper.getJSONObject(data, "current");
        if (current != null) {
            obj.setCategory(current.getString("category"));
            obj.setLabel(JsonHelper.getLocaleString(current, "labels"));
        }
        if ((children = JsonHelper.getJSONArray(data, "children")) != null) {
            for (int i = 0; i < children.length(); ++i) {
                JSONObject childData = children.getJSONObject(i);
                ReadingPlanCategory child = ApiBase.getApiFactory().newReadingPlanCategory();
                child.setCategory(childData.getString("category"));
                child.setLabel(JsonHelper.getLocaleString(childData, "labels"));
                obj.addChild(child);
            }
        }
        if ((breadcrumbs = JsonHelper.getJSONArray(data, "breadcrumbs")) != null) {
            for (int i = 0; i < breadcrumbs.length(); ++i) {
                JSONObject childData = breadcrumbs.getJSONObject(i);
                ReadingPlanCategory child = ApiBase.getApiFactory().newReadingPlanCategory();
                child.setCategory(childData.getString("category"));
                child.setLabel(JsonHelper.getLocaleString(childData, "labels"));
                obj.addBreadcrumb(child);
            }
        }
        return obj;
    }
}

