/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventItem;
import com.youversion.util.StringHelper;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class LiveEventItemPoll
extends LiveEventItem {
    public static final int POLL_TYPE_UNKNOWN = 0;
    public static final int POLL_TYPE_MULTI = 1;
    protected String question;
    protected int pollType;
    protected Vector responses;

    public void unloadJSON(JSONObject json) throws YouVersionApiException {
        super.unloadJSON(json);
        try {
            JSONObject jdata = new JSONObject(this.data);
            this.question = jdata.getString("poll_question");
            this.pollType = LiveEventItemPoll.parsePollType(jdata.getString("poll_type"));
            JSONArray jresponses = jdata.getJSONArray("poll_responses");
            this.responses = new Vector();
            for (int i = 0; i < jresponses.length(); ++i) {
                this.responses.addElement(jresponses.getString(i));
            }
        }
        catch (JSONException t) {
            throw new YouVersionApiException("LiveEventItem.unloadJSON failed: " + t.getMessage(), t);
        }
    }

    public static int parsePollType(String type) {
        if (type == null) {
            return 0;
        }
        if (StringHelper.equalsIgnoreCase("multi", type.trim())) {
            return 1;
        }
        return 0;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public int getPollType() {
        return this.pollType;
    }

    public void setPollType(int pollType) {
        this.pollType = pollType;
    }

    public Vector getResponses() {
        return this.responses;
    }

    public void setResponses(Vector responses) {
        this.responses = responses;
    }
}

