/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.LiveEventItem;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class LiveEventItemCollection
extends Vector {
    public static LiveEventItemCollection unloadJSON(JSONArray items) {
        try {
            LiveEventItemCollection collection = ApiBase.getApiFactory().newLiveEventItemCollection();
            for (int i = 0; i < items.length(); ++i) {
                LiveEventItem item;
                JSONObject json = items.getJSONObject(i);
                int typeId = json.getInt("type_id");
                switch (typeId) {
                    case 4: 
                    case 5: 
                    case 9: {
                        item = ApiBase.getApiFactory().newLiveEventItemLink();
                        break;
                    }
                    case 6: {
                        item = ApiBase.getApiFactory().newLiveEventItemPoll();
                        break;
                    }
                    case 1: {
                        item = ApiBase.getApiFactory().newLiveEventItemReference();
                        break;
                    }
                    case 10: {
                        item = ApiBase.getApiFactory().newLiveEventItemGiving();
                        break;
                    }
                    case 11: {
                        item = ApiBase.getApiFactory().newLiveEventItemShare();
                        break;
                    }
                    default: {
                        item = ApiBase.getApiFactory().newLiveEventItem();
                    }
                }
                item.unloadJSON(json);
                collection.addElement(item);
            }
            return collection;
        }
        catch (JSONException e) {
            ApiBase.getDebugHelper().logError("LiveEventItemCollection::unloadJSON failed", e);
        }
        catch (YouVersionApiException e) {
            ApiBase.getDebugHelper().logError("LiveEventItemCollection::unloadJSON failed", e);
        }
        return ApiBase.getApiFactory().newLiveEventItemCollection();
    }
}

