/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.GroupLocation;
import com.youversion.objects.LiveEventItemCollection;
import com.youversion.util.DateParser;
import java.util.Date;
import org.json.me.JSONObject;

public class LiveEvent {
    protected int id;
    protected int groupId;
    protected String groupName;
    protected String title;
    protected String subtitle;
    protected String description;
    protected Date published;
    protected Date hold;
    protected Date start;
    protected Date end;
    protected String timezone;
    protected GroupLocation groupLocation;
    protected String startFormatted;
    protected String liveDatetimeRange;
    protected String shortUrl;
    protected LiveEventItemCollection items;

    public static LiveEvent unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            LiveEvent obj = ApiBase.getApiFactory().newLiveEvent();
            obj.id = json.getInt("id");
            obj.groupId = json.getInt("group_id");
            obj.groupName = json.getString("group_name");
            obj.title = json.getString("title");
            obj.subtitle = json.getString("subtitle");
            obj.description = json.getString("description");
            obj.setPublished(new Date(DateParser.parseISO(json.getString("published"))));
            obj.setHold(new Date(DateParser.parseISO(json.getString("hold"))));
            obj.setStart(new Date(DateParser.parseISO(json.getString("start"))));
            obj.setEnd(new Date(DateParser.parseISO(json.getString("end"))));
            obj.timezone = json.getString("timezone");
            obj.startFormatted = json.getString("start_formatted");
            obj.liveDatetimeRange = json.getString("live_datetime_range");
            obj.shortUrl = json.getString("short_url");
            if (json.has("group_location")) {
                obj.groupLocation = GroupLocation.unloadJSON(json.getJSONObject("group_location"));
            }
            if (json.has("items")) {
                obj.items = LiveEventItemCollection.unloadJSON(json.getJSONArray("items"));
            }
            return obj;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("LiveEvent.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public Date getHold() {
        return this.hold;
    }

    public void setHold(Date hold) {
        this.hold = hold;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public GroupLocation getGroupLocation() {
        return this.groupLocation;
    }

    public void setGroupLocation(GroupLocation groupLocation) {
        this.groupLocation = groupLocation;
    }

    public LiveEventItemCollection getItems() {
        return this.items;
    }

    public void setItems(LiveEventItemCollection items) {
        this.items = items;
    }

    public String getStartFormatted() {
        return this.startFormatted;
    }

    public void setStartFormatted(String startFormatted) {
        this.startFormatted = startFormatted;
    }

    public String getLiveDatetimeRange() {
        return this.liveDatetimeRange;
    }

    public void setLiveDatetimeRange(String liveDatetimeRange) {
        this.liveDatetimeRange = liveDatetimeRange;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }
}

