/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.internal;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Reference;
import com.youversion.objects.Verse;
import com.youversion.objects.VerseCollection;
import com.youversion.util.JsonHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Chapter
implements Externalizable {
    protected String versionCode;
    protected String copyright;
    protected Reference reference;
    protected String html;
    protected VerseCollection verses = ApiBase.getApiFactory().newVerseCollection();
    protected Reference previous;
    protected Reference next;
    protected Vector audio = new Vector();

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = (Reference)reference.clone();
        this.reference.setVerse(0);
    }

    public VerseCollection getVerses() {
        return this.verses;
    }

    public void setVerses(VerseCollection verses) {
        this.verses = verses;
    }

    public Reference getPrevious() {
        return this.previous;
    }

    public void setPrevious(Reference previous) {
        this.previous = previous;
    }

    public Reference getNext() {
        return this.next;
    }

    public void setNext(Reference next) {
        this.next = next;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public boolean isHtml() {
        return this.html != null && this.html.length() > 0;
    }

    public String getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public Vector getAudio() {
        return this.audio;
    }

    public void setAudio(Vector audio) {
        this.audio = audio;
    }

    public static Chapter unloadResponse(String response) throws JSONException, YouVersionApiException {
        JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
        int code = parsed.getInt("code");
        if (code != 200) {
            throw new YouVersionApiException(code, parsed.getString("data"));
        }
        JSONObject json = parsed.getJSONArray("data").getJSONObject(0);
        return Chapter.unloadJSON(json);
    }

    public static Chapter unloadJSON(JSONObject json) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Chapter c = ApiBase.getApiFactory().newChapter();
        VerseCollection verses = ApiBase.getApiFactory().newVerseCollection();
        try {
            int code = json.getInt("code");
            if (ApiBase.isSuccess(code)) {
                Object previous;
                JSONObject obj = json.getJSONObject("data");
                JSONObject request = obj.getJSONObject("request");
                JSONArray content = request.optJSONArray("content");
                c.setReference(Reference.unloadJSON(request.getJSONObject("reference")));
                c.setCopyright(obj.getString("copyright"));
                Object next = obj.get("next");
                if (next instanceof JSONObject) {
                    c.setNext(Reference.unloadJSON((JSONObject)next));
                }
                if ((previous = obj.get("previous")) instanceof JSONObject) {
                    c.setPrevious(Reference.unloadJSON((JSONObject)previous));
                }
                if (content == null) {
                    c.setHtml(request.getString("content"));
                } else {
                    c.setVerses(verses);
                    for (int i = 0; i < content.length(); ++i) {
                        JSONObject verse = content.getJSONObject(i);
                        Verse v = ApiBase.getApiFactory().newVerse();
                        v.setReference(Reference.unloadJSON(verse.getJSONObject("reference")));
                        v.setContent(verse.getString("content"));
                        verses.addElement(v);
                    }
                }
                JSONArray audio = request.optJSONArray("audio");
                if (audio != null && audio.length() > 0) {
                    c.audio = AudioInfo.unloadMany(audio);
                }
                return c;
            }
            ex = ApiBase.buildReadException(json);
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.audio = (Vector)Serializer.deserialize(dataInputStream);
        this.copyright = (String)Serializer.deserialize(dataInputStream);
        this.html = (String)Serializer.deserialize(dataInputStream);
        this.next = (Reference)Serializer.deserialize(dataInputStream);
        this.previous = (Reference)Serializer.deserialize(dataInputStream);
        this.reference = (Reference)Serializer.deserialize(dataInputStream);
        this.verses = (VerseCollection)Serializer.deserialize(dataInputStream);
        this.versionCode = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.audio, dataOutputStream);
        Serializer.serialize(this.copyright, dataOutputStream);
        Serializer.serialize(this.html, dataOutputStream);
        Serializer.serialize(this.next, dataOutputStream);
        Serializer.serialize(this.previous, dataOutputStream);
        Serializer.serialize(this.reference, dataOutputStream);
        Serializer.serialize(this.verses, dataOutputStream);
        Serializer.serialize(this.versionCode, dataOutputStream);
    }

    public static class AudioInfo
    implements Externalizable {
        public static final String FORMAT_MP3_32K = "format_mp3_32k";
        protected int id;
        protected String title;
        protected Hashtable downloadUrls = new Hashtable();

        public Hashtable getDownloadUrls() {
            return this.downloadUrls;
        }

        public void setDownloadUrls(Hashtable urls) {
            this.downloadUrls = urls;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public static Vector unloadResponse(String apiResponse) throws JSONException, YouVersionApiException {
            JSONObject parsed = new JSONObject(apiResponse).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code != 200) {
                throw new YouVersionApiException(code, parsed.getString("data"));
            }
            JSONArray json = parsed.getJSONArray("data");
            return AudioInfo.unloadMany(json);
        }

        public static Vector unloadMany(JSONArray array) throws JSONException {
            Vector<AudioInfo> v = new Vector<AudioInfo>();
            for (int i = 0; i < array.length(); ++i) {
                AudioInfo a = AudioInfo.unloadJson(array.getJSONObject(i));
                v.addElement(a);
            }
            return v;
        }

        public static AudioInfo unloadJson(JSONObject json) throws JSONException {
            AudioInfo obj = ApiBase.getApiFactory().newAudioInfo();
            obj.id = json.getInt("id");
            obj.title = json.getString("title");
            JSONObject downloadUrls = json.getJSONObject("download_urls");
            obj.downloadUrls = JsonHelper.toHashtable(downloadUrls);
            return obj;
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.downloadUrls = (Hashtable)Serializer.deserialize(dataInputStream);
            this.id = dataInputStream.readInt();
            this.title = (String)Serializer.deserialize(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            Serializer.serialize(this.downloadUrls, dataOutputStream);
            dataOutputStream.writeInt(this.id);
            Serializer.serialize(this.title, dataOutputStream);
        }
    }
}

