/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.internal;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.BibleApi;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.internal.Chapter;
import com.youversion.internal.ChapterCollection;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.VersionCollection;
import java.util.Hashtable;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class BibleApiPrivate
extends BibleApi {
    public static String FORMAT_HTML = "html";
    public static String FORMAT_TEXT = "text";
    public static String FORMAT_HTML_BASIC = "html_basic";

    public static Chapter getChapter(ApiConnection conn, final String version, final String reference, final String format) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                if (reference != null) {
                    this.put("reference", reference);
                }
                if (format != null) {
                    this.put("format", format);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/chapter.json" + BibleApiPrivate.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            Chapter c = Chapter.unloadResponse(response.toString());
            c.setVersionCode(version);
            return c;
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public static ChapterCollection getChapters(ApiConnection conn, final String version, final ReferenceCollection references, final String format) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                if (references != null) {
                    this.put("reference", references.toBookChapterOsis());
                }
                if (format != null) {
                    this.put("format", format);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/chapter.json" + BibleApiPrivate.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code != 200) {
                throw new YouVersionApiException(code, parsed.getString("data"));
            }
            JSONArray items = parsed.getJSONArray("data");
            ChapterCollection c = ChapterCollection.unloadJSON(items);
            c.setVersionCode(version);
            return c;
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public static String getCopyright(ApiConnection conn, final String version, final String format) throws YouVersionApiException {
        YouVersionApiException ex = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (version != null) {
                    this.put("version", version);
                }
                if (format != null) {
                    this.put("format", format);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bible/copyright.json" + BibleApiPrivate.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code != 200) {
                throw new YouVersionApiException(code, parsed.getString("data"));
            }
            return parsed.getJSONObject("data").getString("copyright");
        }
        catch (YouVersionApiException e) {
            ex = e;
        }
        catch (Throwable e) {
            ex = new YouVersionApiException(e);
        }
        throw ex;
    }

    public static VersionCollection getVersions(ApiConnection conn) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/bible/versions.json?type=all";
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BibleApiPrivate.isSuccess(code)) {
                JSONObject obj = parsed.getJSONObject("data");
                return VersionCollection.unloadJSON(obj);
            }
            innerEx = BibleApiPrivate.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }
}

