/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.settings;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.core.BaseForm;
import com.youversion.application.views.settings.Languages;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.io.IOException;

public class SettingsLanguageForm
extends BaseForm
implements ItemCommandListener {
    private static final String KEY_LANGUAGE = "language";

    private static String getCountryCode(String language) {
        for (int index = 0; index < Languages.LANGUAGES_MAP.length; ++index) {
            String[] languageMapping = Languages.LANGUAGES_MAP[index];
            if (!language.equals(languageMapping[0])) continue;
            return languageMapping[1];
        }
        return null;
    }

    public SettingsLanguageForm() {
        this((Style)null);
    }

    public SettingsLanguageForm(Style style) {
        super(style);
        for (int index = 0; index < Languages.LANGUAGES_MAP.length; ++index) {
            String language = Languages.LANGUAGES_MAP[index][0];
            StringItem languageItem = new StringItem(null, language, StyleSheet.list_itemStyle);
            languageItem.setAttribute(KEY_LANGUAGE, language);
            languageItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            languageItem.setItemCommandListener(this);
            this.append(languageItem);
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(123);
    }

    public void commandAction(Command c, Item item) {
        String language = (String)item.getAttribute(KEY_LANGUAGE);
        String countryCode = SettingsLanguageForm.getCountryCode(language);
        EVENT_SYSTEM.queueEvent(770002);
        String translationsUrl = Languages.getTranslationsUrl(countryCode);
        try {
            Locale.loadTranslations(translationsUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OPTIONS.setOption(5, countryCode);
        OPTIONS.setLanguageAndBibleDefaults(countryCode);
        COMMANDS.applyLabels();
        EVENT_SYSTEM.queueEvent(998882, this);
        EVENT_SYSTEM.queueEvent(770003);
    }
}

