/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.reader;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.reader.BibleReaderChangeForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Language;
import com.youversion.objects.Version;
import com.youversion.objects.VersionCollection;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class BibleVersionsForm
extends BibleReaderChangeForm
implements ItemCommandListener {
    protected static final String KEY_VERSION = "obj";

    public BibleVersionsForm() {
        this((Style)null);
    }

    public BibleVersionsForm(Style style) {
        super(style);
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        VersionCollection versionCollection = workChapterDescriptor.getVersionCollection();
        Language language = workChapterDescriptor.getLanguage();
        Vector versions = versionCollection.getByLang(language);
        for (int index = 0; index < versions.size(); ++index) {
            Version v = (Version)versions.elementAt(index);
            StringItem item = new StringItem(null, v.getTitle(), StyleSheet.list_itemStyle);
            item.setDefaultCommand(COMMANDS.CMD_SELECT);
            item.setItemCommandListener(this);
            item.setAttribute(KEY_VERSION, v);
            this.container.add(item);
        }
        COMMANDS.CMD_READER_CHANGE.removeSubCommands();
        this.addCommand(COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_LANGUAGE, COMMANDS.CMD_READER_CHANGE);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(133);
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_READER_CHANGE_LANGUAGE == c) {
            EVENT_SYSTEM.queueEvent(990005);
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
            ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
            Version version = (Version)item.getAttribute(KEY_VERSION);
            Bookmark currentBookmark = (Bookmark)OPTIONS.getOption(3);
            Bookmark newBookmark = new Bookmark(version.getAbbreviation(), currentBookmark.getChapter());
            EVENT_SYSTEM.queueEvent(100010, new BookmarkChapterDescriptor(newBookmark));
            EVENT_SYSTEM.queueEvent(990004);
        }
    }
}

