/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notifications;

import com.youversion.apiextension.objects.J2MEUpgradeNotification;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.NAVIGATION_HISTORY;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.NotificationManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.utils.NotificationsUtil;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import javax.microedition.io.ConnectionNotFoundException;

public class UpdateNotificationForm
extends BaseForm
implements ItemCommandListener {
    public UpdateNotificationForm() {
        this((Style)null);
    }

    public UpdateNotificationForm(Style style) {
        super(style);
        NotificationManager manager = NotificationManager.getInstance();
        J2MEUpgradeNotification notification = (J2MEUpgradeNotification)NotificationsUtil.notificationToJ2meNotification(manager.getActiveNotification());
        IconItem logoItem = new IconItem(null, null, StyleSheet.logoStyle);
        logoItem.setAppearanceMode(0);
        this.append(logoItem);
        StringItem textItem = new StringItem(null, notification.get(OPTIONS.getLanguage()).getText(), StyleSheet.about_textStyle);
        this.append(textItem);
        String version = notification.getUpgradeToVersion();
        String aboutVersion = Locale.get(0, version);
        StringItem versionItem = new StringItem(null, aboutVersion, StyleSheet.about_versionStyle);
        this.append(versionItem);
        StringItem gotoItem = new StringItem(null, Locale.get(79), StyleSheet.buttonStyle);
        gotoItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        gotoItem.setItemCommandListener(this);
        this.append(gotoItem);
        this.addCommand(COMMANDS.CMD_NAVIGATION_DISMISS);
    }

    public String getTitle() {
        return Locale.get(80);
    }

    public void commandAction(Command c, Item item) {
        NotificationManager manager = NotificationManager.getInstance();
        J2MEUpgradeNotification notification = (J2MEUpgradeNotification)NotificationsUtil.notificationToJ2meNotification(manager.getActiveNotification());
        String link = notification.get(OPTIONS.getLanguage()).getLink();
        try {
            StyleSheet.midlet.platformRequest(link);
        }
        catch (ConnectionNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == COMMANDS.CMD_NAVIGATION_DISMISS) {
            NAVIGATION_HISTORY.removeFromStack(this);
            EVENT_SYSTEM.queueEvent(990006);
        }
    }
}

