/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Note;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;

public class EditNoteForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener {
    TextField noteTitle;
    TextField noteContent;
    StringItem editReferences;
    StringItem saveAsPublic;
    StringItem saveAsPrivate;
    StringItem saveAsDraft;
    boolean hasChanged = false;

    public EditNoteForm() {
        this((Style)null);
    }

    public EditNoteForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            EditNoteManager manager = EditNoteManager.getInstance();
            Note note = manager.getNote();
            Container itemContainer = new Container(false, StyleSheet.itemStyle);
            this.noteTitle = new TextField(Locale.get(54), note.getTitle(), 9999, 0, StyleSheet.textfieldStyle);
            this.noteTitle.setItemStateListener(this);
            itemContainer.add(this.noteTitle);
            this.noteContent = new TextField(Locale.get(51), note.getContentText(), 9999, 0, StyleSheet.textfieldStyle);
            this.noteContent.setItemStateListener(this);
            itemContainer.add(this.noteContent);
            StringItem referencesLabel = new StringItem(null, Locale.get(96), 0, StyleSheet.labelStyle);
            itemContainer.add(referencesLabel);
            this.editReferences = new StringItem(null, Locale.get(59), 3, StyleSheet.buttonStyle);
            this.editReferences.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.editReferences.setItemCommandListener(this);
            itemContainer.add(this.editReferences);
            StringItem saveAsLabel = new StringItem(null, Locale.get(64), 0, StyleSheet.labelStyle);
            itemContainer.add(saveAsLabel);
            this.saveAsPublic = new StringItem(null, Locale.get(63), 3, StyleSheet.list_itemStyle);
            this.saveAsPublic.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.saveAsPublic.setItemCommandListener(this);
            itemContainer.add(this.saveAsPublic);
            this.saveAsPrivate = new StringItem(null, Locale.get(62), 3, StyleSheet.list_itemStyle);
            this.saveAsPrivate.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.saveAsPrivate.setItemCommandListener(this);
            itemContainer.add(this.saveAsPrivate);
            this.saveAsDraft = new StringItem(null, Locale.get(61), 3, StyleSheet.list_itemStyle);
            this.saveAsDraft.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.saveAsDraft.setItemCommandListener(this);
            itemContainer.add(this.saveAsDraft);
            this.append(itemContainer);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Item item) {
        EditNoteManager manager = EditNoteManager.getInstance();
        Note note = manager.getNote();
        if (item == this.editReferences) {
            EVENT_SYSTEM.queueEvent(990050, note);
        } else if (item == this.saveAsDraft) {
            note.setContentText(this.noteContent.getString());
            note.setTitle(this.noteTitle.getString());
            note.setUserStatus("draft");
            note.setReferences(manager.getTempReferences());
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(200046, manager.getContext(), 2, note);
        } else if (item == this.saveAsPrivate) {
            note.setContentText(this.noteContent.getString());
            note.setTitle(this.noteTitle.getString());
            note.setUserStatus("private");
            note.setReferences(manager.getTempReferences());
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(200046, manager.getContext(), 2, note);
        } else if (item == this.saveAsPublic) {
            note.setContentText(this.noteContent.getString());
            note.setTitle(this.noteTitle.getString());
            note.setUserStatus("public");
            note.setReferences(manager.getTempReferences());
            EVENT_SYSTEM.queueEvent(998882, this);
            EVENT_SYSTEM.queueEvent(200046, manager.getContext(), 2, note);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_NAVIGATION_BACK == c) {
            if (this.getChanged()) {
                AlertForm.showQuestionDialog(Locale.get(142), Locale.get(135), this, null);
            } else {
                super.commandAction(c, d);
            }
        } else if (COMMANDS.CMD_YES == c) {
            super.commandAction(COMMANDS.CMD_NAVIGATION_BACK, d);
        } else {
            super.commandAction(c, d);
        }
    }

    public void setChanged(boolean value) {
        this.hasChanged = value;
    }

    public boolean getChanged() {
        return this.hasChanged;
    }

    public void itemStateChanged(Item item) {
        EditNoteManager manager = EditNoteManager.getInstance();
        Note note = manager.getNote();
        this.setChanged(true);
    }
}

