/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.live;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.LiveManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.LiveEvent;
import com.youversion.objects.LiveEventCollection;
import com.youversion.polish.extensions.item.LiveEventSearchItem;
import com.youversion.utils.StyleHelper;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;

public class LiveEventSearchForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener,
CommandListener {
    private Container header = new Container(StyleSheet.search_headerStyle);
    private Container results = new Container(StyleSheet.itemStyle);
    private TextField searchField;
    private StringItem searchButton;

    public LiveEventSearchForm() {
        this((Style)null);
    }

    public LiveEventSearchForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.deleteAll();
            this.removeAllCommands();
            LiveManager searchManager = LiveManager.getInstance();
            LiveEventCollection collection = searchManager.getCollection();
            String query = searchManager.getLocation();
            this.header.clear();
            this.results.clear();
            this.searchField = new TextField(null, query, 128, 0);
            this.searchField.setHelpText(Locale.get(39));
            this.setItemStateListener(this);
            this.header.add(this.searchField);
            this.searchButton = new StringItem(null, Locale.get(120), 3);
            this.searchButton.setItemCommandListener(this);
            this.searchButton.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.header.add(this.searchButton);
            this.append(16, this.header);
            this.append(this.results);
            this.setSearchButtonState();
            this.setActiveFrame(16);
            if (collection != null && collection.size() > 0) {
                this.populateSearchResults(collection);
            } else if (query != null) {
                StringItem noneFoundItem = new StringItem(null, Locale.get(121), StyleSheet.textStyle);
                this.results.add(noneFoundItem);
            }
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Item item) {
        if (item == this.searchButton) {
            String query = this.searchField.getString();
            EVENT_SYSTEM.queueEvent(200034, 2, query);
        } else if (item instanceof LiveEventSearchItem) {
            LiveEventSearchItem liveEventSearchItem = (LiveEventSearchItem)item;
            LiveEvent liveEvent = liveEventSearchItem.getLiveEvent();
            EVENT_SYSTEM.queueEvent(990048, 2, new Integer(liveEvent.getId()));
        }
    }

    public void setSearchButtonState() {
        if (this.searchField.getString().length() == 0) {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.button_disabledStyle);
            this.searchButton.setStyle(disabledStyle);
            this.searchButton.setAppearanceMode(0);
        } else {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.buttonStyle);
            this.searchButton.setStyle(disabledStyle);
            this.searchButton.setAppearanceMode(3);
        }
    }

    public void itemStateChanged(Item item) {
        this.setSearchButtonState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSearchResults(LiveEventCollection results) {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.results.clear();
            for (int index = 0; index < results.size(); ++index) {
                LiveEvent liveEvent = (LiveEvent)results.elementAt(index);
                LiveEventSearchItem item = new LiveEventSearchItem(liveEvent);
                item.setDefaultCommand(COMMANDS.CMD_SELECT);
                item.setItemCommandListener(this);
                this.results.add(item);
            }
        }
    }
}

