/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.live;

import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.LiveManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.LiveEvent;
import com.youversion.objects.LiveEventItemPoll;
import com.youversion.objects.LiveEventPollResultItem;
import com.youversion.polish.extensions.item.LiveEventContentItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class LiveEventPollResultForm
extends BaseForm {
    private LiveEvent liveEvent;
    private LiveEventPollResultItem pollResultItem;
    private LiveEventItemPoll liveEventItemPoll;

    public LiveEventPollResultForm() {
        this((Style)null);
    }

    public String getTitle() {
        return this.liveEvent.getTitle();
    }

    public LiveEventPollResultForm(Style style) {
        super(style);
        LiveManager liveManager = LiveManager.getInstance();
        this.liveEvent = liveManager.getLiveEvent();
        this.pollResultItem = liveManager.getPollResultItem();
        this.liveEventItemPoll = (LiveEventItemPoll)liveManager.getLiveEventItem();
        LiveEventContentItem contentItem = new LiveEventContentItem(this.liveEventItemPoll.getTypeId(), this.liveEventItemPoll.getTitle());
        Container contentList = contentItem.getContentList();
        StringItem descriptionItem = new StringItem(null, this.liveEventItemPoll.getQuestion(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
        Vector pollResponses = this.pollResultItem.getResponses();
        for (int index = 0; index < pollResponses.size(); ++index) {
            LiveEventPollResultItem.PollResponse pollResponse = (LiveEventPollResultItem.PollResponse)pollResponses.elementAt(index);
            String response = pollResponse.getResponse();
            int percentage = (int)pollResponse.getPercentage();
            String[] params = new String[]{response, Integer.toString(percentage)};
            String title = Locale.get(1, params);
            StringItem responseTitleItem = new StringItem(null, title, StyleSheet.live_content_textStyle);
            contentList.add(responseTitleItem);
            Gauge responseResultItem = new Gauge(null, false, 100, percentage, StyleSheet.live_content_poll_result_percentageStyle);
            contentList.add(responseResultItem);
        }
        this.append(contentItem);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }
}

