/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.core;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Note;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.Verse;
import com.youversion.objects.VerseCollection;
import com.youversion.utils.StyleHelper;
import com.youversion.utils.TextUtil;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import java.util.Vector;

public abstract class BaseReaderForm
extends BaseForm
implements ItemCommandListener {
    protected static final String OBJECT = "obj";
    protected Vector selectedItems = new Vector();

    public abstract String getVersionStr();

    public BaseReaderForm() {
        this((Style)null);
    }

    public BaseReaderForm(Style style) {
        super(style);
    }

    public String getItemText(Verse v) {
        String result = "  " + String.valueOf(v.getReference().getStartVerse()) + ". " + TextUtil.stripBadCharactersFromVerseText(v.getContent());
        return result;
    }

    public Style getStyleFor(Verse verse) {
        Style verseStyle = null;
        if (this.selectedItems.indexOf(verse) < 0) {
            switch ((Integer)OPTIONS.getOption(0)) {
                case 1: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_smallStyle);
                    break;
                }
                case 2: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_mediumStyle);
                    break;
                }
                case 3: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_largeStyle);
                }
            }
        } else {
            switch ((Integer)OPTIONS.getOption(0)) {
                case 1: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_small_selectedStyle);
                    break;
                }
                case 2: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_medium_selectedStyle);
                    break;
                }
                case 3: {
                    verseStyle = StyleHelper.getStyle(StyleSheet.reader_text_large_selectedStyle);
                }
            }
        }
        return verseStyle;
    }

    public Command[] getCommandsFor(Verse v) {
        Command[] result = null;
        result = this.selectedItems.indexOf(v) < 0 ? new Command[]{COMMANDS.CMD_SELECT} : new Command[]{COMMANDS.CMD_UNSELECT};
        return result;
    }

    public void processVerseToItem(Verse v, Item item) {
        ArrayList initialCommands = item.getItemCommands();
        if (item.getItemCommands() != null) {
            while (initialCommands.size() > 0) {
                item.removeCommand((Command)initialCommands.get(0));
            }
        }
        item.setDefaultCommand(null);
        Command[] commands = this.getCommandsFor(v);
        for (int j = 0; j < commands.length; ++j) {
            if (j == 0) {
                item.setDefaultCommand(commands[j]);
            }
            item.addCommand(commands[j]);
        }
        ((StringItem)item).setText(this.getItemText(v));
        int scrollYOffset = this.container.getScrollYOffset();
        this.focus(-1);
        StyleHelper.setStyle(item, this.getStyleFor(v));
        this.focus(item);
        this.container.setScrollYOffset(scrollYOffset);
    }

    public void generateCommands() {
        this.removeCommand(COMMANDS.CMD_ADD_NOTE);
        this.removeCommand(COMMANDS.CMD_SHARE);
        this.removeCommand(COMMANDS.CMD_READER_ADD_TO_BOOKMARKS);
        this.removeCommand(COMMANDS.CMD_VIEW_ITEM_NOTES);
        if (this.selectedItems.size() > 0) {
            this.addCommand(COMMANDS.CMD_ADD_NOTE);
            this.addCommand(COMMANDS.CMD_SHARE);
            this.addCommand(COMMANDS.CMD_READER_ADD_TO_BOOKMARKS);
            this.addCommand(COMMANDS.CMD_VIEW_ITEM_NOTES);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            Verse v = (Verse)item.getAttribute(OBJECT);
            this.selectedItems.addElement(v);
            this.processVerseToItem(v, item);
            this.generateCommands();
        } else if (COMMANDS.CMD_UNSELECT == c) {
            Verse v = (Verse)item.getAttribute(OBJECT);
            this.selectedItems.removeElement(v);
            this.processVerseToItem(v, item);
            this.generateCommands();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == COMMANDS.CMD_READER_ADD_TO_BOOKMARKS) {
            ReferenceCollection references = new ReferenceCollection();
            for (int i = 0; i < this.selectedItems.size(); ++i) {
                Verse v = (Verse)this.selectedItems.elementAt(i);
                references.addElement(v.getReference());
            }
            Bookmark newBookmark = new Bookmark(this.getVersionStr(), references.toOsis());
            newBookmark.setChapter(references.elementAt(0));
            newBookmark.setReferences(references);
            EVENT_SYSTEM.queueEvent(99055, newBookmark);
        } else if (c == COMMANDS.CMD_SHARE) {
            Verse v = (Verse)this.selectedItems.elementAt(0);
            String text = "";
            for (int i = 0; i < this.selectedItems.size(); ++i) {
                text = text + TextUtil.stripBadCharactersFromVerseText(((Verse)this.selectedItems.elementAt(i)).getContent()) + "\n";
            }
            String link = "http://bible.us/" + v.getReference().getBookOsis() + v.getReference().getChapter() + "." + v.getReference().getStartVerse() + "." + this.getVersionStr();
            EVENT_SYSTEM.queueEvent(990011, new Object[]{text, link});
        } else if (c == COMMANDS.CMD_VIEW_ITEM_NOTES) {
            ReferenceCollection references = new ReferenceCollection();
            for (int i = 0; i < this.selectedItems.size(); ++i) {
                references.addElement(((Verse)this.selectedItems.elementAt(i)).getReference());
            }
            EVENT_SYSTEM.queueEvent(990044, references);
        } else if (c == COMMANDS.CMD_ADD_NOTE) {
            ReferenceCollection references = new ReferenceCollection();
            for (int i = 0; i < this.selectedItems.size(); ++i) {
                references.addElement(((Verse)this.selectedItems.elementAt(i)).getReference());
            }
            Note note = new Note();
            Bookmark bookmark = (Bookmark)OPTIONS.getOption(3);
            note.setVersion(bookmark.getVersion());
            note.setReferences(references);
            EditNoteManager.getInstance().setContext(1);
            EVENT_SYSTEM.queueEvent(990046, note);
        } else {
            super.commandAction(c, d);
        }
    }

    public void populateVerseContainer(VerseCollection verses, Container container) {
        this.populateVerseContainer(verses, container, -1);
    }

    public void populateVerseContainer(VerseCollection verses, Container container, int verseNoToFocus) {
        Style verseStyle = null;
        StringItem toBeFocused = null;
        for (int i = 0; i < verses.size(); ++i) {
            Verse v = verses.elementAt(i);
            verseStyle = this.getStyleFor(v);
            StringItem item = new StringItem(null, this.getItemText(v), verseStyle);
            this.processVerseToItem(v, item);
            item.setItemCommandListener(this);
            item.setAttribute(OBJECT, v);
            container.add(item);
            if (v.getReference().getStartVerse() != verseNoToFocus) continue;
            toBeFocused = item;
        }
        if (toBeFocused != null) {
            this.focus(toBeFocused);
        }
    }
}

