/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.SearchManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.BibleSearchResult;
import com.youversion.objects.BibleSearchResultItem;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Version;
import com.youversion.polish.extensions.item.SearchResultItem;
import com.youversion.utils.StyleHelper;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;

public class SearchForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener,
CommandListener {
    private String query;
    private int page;
    private BibleSearchResult searchResult;
    private Container header = new Container(StyleSheet.search_headerStyle);
    private Container results = new Container(StyleSheet.itemStyle);
    private TextField searchField;
    private StringItem searchButton;

    public SearchForm() {
        this((Style)null);
    }

    public SearchForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(122);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.deleteAll();
            this.removeAllCommands();
            SearchManager searchManager = SearchManager.getInstance();
            this.page = searchManager.getPage();
            this.searchResult = searchManager.getResult();
            this.query = searchManager.getQuery();
            this.header.clear();
            this.results.clear();
            this.searchField = new TextField(null, this.query, 128, 0, StyleSheet.textfieldStyle);
            this.setItemStateListener(this);
            this.header.add(this.searchField);
            this.searchButton = new StringItem("", Locale.get(120), 3, StyleSheet.buttonStyle);
            this.searchButton.setItemCommandListener(this);
            this.searchButton.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.header.add(this.searchButton);
            this.append(16, this.header);
            this.append(this.results);
            this.setSearchButtonState();
            this.setActiveFrame(16);
            if (this.searchResult != null && this.searchResult.size() > 0) {
                this.populateSearchResults(this.searchResult);
            } else if (this.query != null) {
                StringItem noneFoundItem = new StringItem(null, Locale.get(121), StyleSheet.textStyle);
                this.results.add(noneFoundItem);
            }
            this.populateMenu(this.page, this.searchResult);
        }
    }

    public void populateMenu(int page, BibleSearchResult searchResult) {
        if (searchResult != null && searchResult.size() > 0) {
            int total = searchResult.getTotal();
            int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
            if (page > 1) {
                this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            }
            if (page < pages) {
                this.addCommand(COMMANDS.CMD_NEXT_PAGE);
            }
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public void commandAction(Command c, Displayable d) {
        Bookmark bookmark = (Bookmark)OPTIONS.getOption(3);
        Version version = new Version();
        version.setAbbreviation(bookmark.getVersion());
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            Integer nextPage = new Integer(this.page + 1);
            EVENT_SYSTEM.queueEvent(200028, 2, new Object[]{this.query, version, nextPage});
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            Integer previousPage = new Integer(this.page - 1);
            EVENT_SYSTEM.queueEvent(200028, 2, new Object[]{this.query, version, previousPage});
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (item == this.searchButton) {
            Bookmark bookmark = (Bookmark)OPTIONS.getOption(3);
            Version version = new Version();
            version.setAbbreviation(bookmark.getVersion());
            Integer page = new Integer(1);
            String query = this.searchField.getString();
            EVENT_SYSTEM.queueEvent(200028, 2, new Object[]{query, version, page});
        } else if (item instanceof SearchResultItem) {
            SearchResultItem sel = (SearchResultItem)item;
            BibleSearchResultItem searchResult = sel.getSearchResultItem();
            Bookmark bookmark = (Bookmark)OPTIONS.getOption(3);
            bookmark.setChapter(searchResult.getReference());
            bookmark.setVersion(searchResult.getVersion());
            BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(bookmark);
            EVENT_SYSTEM.queueEvent(990004, bookmarkChapterDescriptor);
        }
    }

    public void setSearchButtonState() {
        if (this.searchField.getString().length() == 0) {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.button_disabledStyle);
            this.searchButton.setStyle(disabledStyle);
            this.searchButton.setAppearanceMode(0);
        } else {
            Style disabledStyle = StyleHelper.getStyle(StyleSheet.buttonStyle);
            this.searchButton.setStyle(disabledStyle);
            this.searchButton.setAppearanceMode(3);
        }
    }

    public void itemStateChanged(Item item) {
        this.setSearchButtonState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSearchResults(BibleSearchResult results) {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.results.clear();
            for (int i = 0; i < results.size(); ++i) {
                SearchResultItem item = new SearchResultItem(results.getVerses().elementAt(i));
                item.setDefaultCommand(COMMANDS.CMD_SELECT);
                item.setItemCommandListener(this);
                this.results.add(item);
            }
            if (results.size() > 0) {
                // empty if block
            }
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.searchResult == null || this.searchResult.size() == 0) {
            return super.handleKeyReleased(keycode, gameAction);
        }
        int total = this.searchResult.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (this.page > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (this.page < pages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }

    public void showNotify() {
        super.showNotify();
    }
}

