/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.core.BaseForm;
import com.youversion.application.views.settings.Languages;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import javax.microedition.io.ConnectionNotFoundException;

public class HelpForm
extends BaseForm
implements ItemCommandListener {
    StringItem forgotPassword;
    StringItem resendVerification;
    StringItem supportWebsite;

    public HelpForm() {
        this((Style)null);
    }

    public HelpForm(Style style) {
        super(style);
        if (!OPTIONS.isLoggedIn()) {
            this.forgotPassword = new StringItem(null, Locale.get(24), 3, StyleSheet.list_itemStyle);
            this.forgotPassword.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.forgotPassword.setItemCommandListener(this);
            this.append(this.forgotPassword);
            this.resendVerification = new StringItem(null, Locale.get(25), 3, StyleSheet.list_itemStyle);
            this.resendVerification.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.resendVerification.setItemCommandListener(this);
            this.append(this.resendVerification);
        }
        this.supportWebsite = new StringItem(null, Locale.get(26), 3, StyleSheet.list_itemStyle);
        this.supportWebsite.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.supportWebsite.setItemCommandListener(this);
        this.append(this.supportWebsite);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(2);
    }

    public void commandAction(Command c, Item item) {
        String locale = OPTIONS.getLanguage();
        if (item == this.forgotPassword) {
            this.openURL(Languages.getForgotPasswordUrlForLocale(locale));
        } else if (item == this.supportWebsite) {
            this.openURL(Languages.getSupportWebsiteUrlForLocale(locale));
        } else if (item == this.resendVerification) {
            this.openURL(Languages.getResendVerificationUrlForLocale(locale));
        }
    }

    protected void openURL(String url) {
        try {
            StyleSheet.midlet.platformRequest(url);
        }
        catch (ConnectionNotFoundException e) {
            e.printStackTrace();
        }
    }
}

