/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.NAVIGATION_HISTORY;
import com.youversion.application.views.core.BaseForm;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import de.enough.polish.util.Locale;

public class AlertForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener {
    public static final int TYPE_QUESTION = 1;
    public static final int TYPE_NOTIFICATION = 2;
    public static final int TYPE_OK_DISMISS_DO_NOT_SHOW_AGAIN = 3;
    private final String title;
    private final String content;
    private final Event dismissEvent;
    private final Event okEvent;
    private final Event doNotShowAgainEvent;
    protected int mode = 2;
    protected CommandListener target;
    protected Object optionalData;
    protected ChoiceItem dontRemindMeItem;
    protected StringItem showButton;

    public AlertForm(String title, String content, Event dismissEvent) {
        this(title, content, dismissEvent, null);
    }

    public AlertForm(String title, String content, Event dismissEvent, int mode) {
        this(title, content, null, dismissEvent, null, mode, null);
    }

    public AlertForm(String title, String content, Event dismissEvent, int mode, Style style) {
        this(title, content, null, dismissEvent, null, mode, style);
    }

    public static void showQuestionDialog(String title, String content, CommandListener target, Object optionalData) {
        AlertForm alert = new AlertForm(title, content, null, 1, StyleSheet.alertStyle);
        alert.target = target;
        alert.optionalData = optionalData;
        NAVIGATION_HISTORY.push(alert);
    }

    public static void showOkDismissDoNotShowThisAgain(String title, String content, Event okEvent, Event dismissEvent, Event doNotShowAgainEvent) {
        AlertForm alert = new AlertForm(title, content, okEvent, dismissEvent, doNotShowAgainEvent, 3, StyleSheet.alertStyle);
        NAVIGATION_HISTORY.push(alert);
    }

    public AlertForm(String title, String content, Event dismissEvent, Style style) {
        this(title, content, null, dismissEvent, null, 2, style);
    }

    public AlertForm(String title, String content, Event okEvent, Event dismissEvent, Event doNotShowThisAgainEvent, int mode) {
        this(title, content, okEvent, dismissEvent, doNotShowThisAgainEvent, mode, null);
    }

    public AlertForm(String title, String content, Event okEvent, Event dismissEvent, Event doNotShowThisAgainEvent, Style style) {
        this(title, content, okEvent, dismissEvent, doNotShowThisAgainEvent, 3, style);
    }

    public AlertForm(String title, String content, Event okEvent, Event dismissEvent, Event doNotShowThisAgainEvent, int mode, Style style) {
        super(style);
        this.title = title;
        this.content = content;
        this.okEvent = okEvent;
        this.dismissEvent = dismissEvent;
        this.doNotShowAgainEvent = doNotShowThisAgainEvent;
        this.mode = mode;
        this.setTitle(this.title);
        StringItem alertText = new StringItem(null, this.content, 0, StyleSheet.popup_textStyle);
        this.append(alertText);
        if (this.mode == 2) {
            this.addCommand(COMMANDS.CMD_NAVIGATION_ALERT_OK);
        } else if (this.mode == 3) {
            ChoiceGroup dontRemindMeGroup = new ChoiceGroup(null, 2);
            this.dontRemindMeItem = new ChoiceItem(Locale.get(137), null, 2, StyleSheet.checkboxStyle);
            dontRemindMeGroup.add(this.dontRemindMeItem);
            dontRemindMeGroup.setItemStateListener(this);
            this.append(dontRemindMeGroup);
            this.showButton = new StringItem(null, Locale.get(78), 3, StyleSheet.buttonStyle);
            this.showButton.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.showButton.setItemCommandListener(this);
            this.append(this.showButton);
            this.addCommand(COMMANDS.CMD_NAVIGATION_DISMISS, StyleSheet.rightcommandStyle);
            this.focus(this.showButton);
        } else {
            this.addCommand(COMMANDS.CMD_YES, StyleSheet.rightcommandStyle);
            this.addCommand(COMMANDS.CMD_NO, StyleSheet.leftcommandStyle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void commandAction(Command c, Displayable d) {
        if (this.mode == 1) {
            if (c == COMMANDS.CMD_YES || c == COMMANDS.CMD_NO) {
                c.setData(this.optionalData);
                this.target.commandAction(c, this);
                NAVIGATION_HISTORY.removeFromStack(this);
                NAVIGATION_HISTORY.showDisplayable(NAVIGATION_HISTORY.peek());
                this.hideNotify();
            } else {
                super.commandAction(c, d);
            }
        } else if (this.mode == 3) {
            if (c == COMMANDS.CMD_NAVIGATION_DISMISS) {
                NAVIGATION_HISTORY.removeFromStack(this);
                NAVIGATION_HISTORY.showDisplayable(NAVIGATION_HISTORY.peek());
                this.hideNotify();
                if (this.dontRemindMeItem.isSelected() && this.doNotShowAgainEvent != null) {
                    EVENT_SYSTEM.queueEvent(this.doNotShowAgainEvent);
                }
                if (this.dismissEvent != null) {
                    EVENT_SYSTEM.queueEvent(this.dismissEvent);
                }
            }
        } else if (c == COMMANDS.CMD_NAVIGATION_ALERT_OK || c == COMMANDS.CMD_NAVIGATION_BACK) {
            this.hideNotify();
            EVENT_SYSTEM.queueEvent(998881, this);
            if (this.dismissEvent != null) {
                EVENT_SYSTEM.queueEvent(this.dismissEvent);
            }
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (item == this.showButton) {
            NAVIGATION_HISTORY.removeFromStack(this);
            NAVIGATION_HISTORY.showDisplayable(NAVIGATION_HISTORY.peek());
            this.hideNotify();
            if (this.dontRemindMeItem.isSelected() && this.doNotShowAgainEvent != null) {
                EVENT_SYSTEM.queueEvent(this.doNotShowAgainEvent);
            }
            if (this.okEvent != null) {
                EVENT_SYSTEM.queueEvent(this.okEvent);
            }
        }
    }

    public void itemStateChanged(Item item) {
        Debug.debug("debug", "com.youversion.application.views.AlertForm", 268, (Object)"> ", this.dontRemindMeItem.isSelected());
        boolean select = this.dontRemindMeItem.isSelected();
        this.dontRemindMeItem.select(select);
    }
}

