/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.internal.caching;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.GLOBAL;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.internal.BibleApiPrivate;
import com.youversion.internal.Chapter;
import com.youversion.objects.Book;
import com.youversion.objects.Version;
import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.source.ContentSource;
import de.enough.polish.content.storage.StorageReference;
import de.enough.polish.util.Debug;
import java.io.IOException;

public class BibleChapterSource
extends ContentSource {
    public static final String KEY_PAYLOAD = "payload";
    public static final Chapter MISSING_CHAPTER = new Chapter();

    public BibleChapterSource(String id) {
        super(id);
    }

    protected Object load(ContentDescriptor descriptor) throws IOException {
        Integer requestedChapterNumber;
        Book requestedBook;
        Version requestedVersion;
        Object payload = descriptor.getAttribute(KEY_PAYLOAD);
        if (payload instanceof BookmarkChapterDescriptor) {
            BookmarkChapterDescriptor bookmarkChapterDescriptor = (BookmarkChapterDescriptor)payload;
            requestedVersion = bookmarkChapterDescriptor.getVersion();
            requestedBook = bookmarkChapterDescriptor.getBook();
            requestedChapterNumber = bookmarkChapterDescriptor.getChapterNumber();
        } else if (payload instanceof Object[]) {
            Object[] params = (Object[])payload;
            requestedChapterNumber = (Integer)params[0];
            requestedBook = (Book)params[1];
            requestedVersion = (Version)params[2];
        } else {
            throw new IllegalArgumentException("wrong payload type for EVENTS.REQUEST_BIBLE_BOOK_CHAPTER");
        }
        try {
            Debug.debug("debug", "com.youversion.application.internal.caching.BibleChapterSource", 65, (Object)("LOAD CHAPTER FROM WEB: " + requestedVersion.getAbbreviation() + "." + requestedBook.getAbbreviation() + "."), requestedChapterNumber.toString());
            Chapter readChapterResultChapter = BibleApiPrivate.getChapter(GLOBAL.API_CONNECTION, requestedVersion.getAbbreviation(), requestedBook.getAbbreviation() + "." + requestedChapterNumber.toString(), BibleApiPrivate.FORMAT_TEXT);
            return readChapterResultChapter;
        }
        catch (YouVersionApiException e) {
            if (e.getStatusCode() == 404) {
                return MISSING_CHAPTER;
            }
            EVENT_SYSTEM.queueEvent(0, e);
            return null;
        }
    }

    protected Object load(StorageReference reference) throws IOException {
        return null;
    }

    protected Object store(ContentDescriptor descriptor, Object data) throws IOException {
        return null;
    }

    protected void destroy(StorageReference reference) throws IOException {
    }

    protected Object[] storeContentAndGetDataSize(ContentDescriptor descriptor, Object data) throws IOException {
        return null;
    }
}

